/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.utils.localization;

import com.ibm.icu.text.MessageFormat;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.brailleblaster.utils.BBData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0011\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0086\u0002J+\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\u0016\u0010\u0012\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0013\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0014J(\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\u0018\u0010\u0012\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/brailleblaster/utils/localization/LocaleHandler;", "", "bundlePath", "", "locale", "Ljava/util/Locale;", "<init>", "(Ljava/lang/String;Ljava/util/Locale;)V", "getLocale", "()Ljava/util/Locale;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "bundle", "Ljava/util/ResourceBundle;", "get", "key", "format", "arguments", "", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "", "Companion", "utils"})
public class LocaleHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Locale locale;
    private final Logger log;
    @Nullable
    private final ResourceBundle bundle;
    @NotNull
    private static Map<Pair<String, Locale>, LocaleHandler> lhMap = new LinkedHashMap();

    public LocaleHandler(@NotNull String bundlePath, @NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)bundlePath, (String)"bundlePath");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        this.locale = locale;
        this.log = LoggerFactory.getLogger(LocaleHandler.class);
        try {
            String[] stringArray = new String[]{"programData", "lang"};
            URL langUrl = BBData.INSTANCE.getBrailleblasterPath(stringArray).toURI().toURL();
            URL[] uRLArray = new URL[]{langUrl};
            ClassLoader loader = new URLClassLoader(uRLArray);
            this.bundle = ResourceBundle.getBundle(bundlePath, this.locale, loader);
        }
        catch (Exception ex) {
            throw new RuntimeException("Cannot load locale", ex);
        }
    }

    @NotNull
    public final Locale getLocale() {
        return this.locale;
    }

    @NotNull
    public final String get(@NotNull String key) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        try {
            Object object2 = this.bundle;
            if (object2 == null || (object2 = ((ResourceBundle)object2).getString(key)) == null) {
                object2 = key;
            }
            object = object2;
        }
        catch (MissingResourceException e) {
            this.log.warn("Locale key '{}' not found!", (Object)key);
            object = key;
        }
        return object;
    }

    @NotNull
    public final String format(@NotNull String key, Object ... arguments) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        String pattern = this.get(key);
        MessageFormat mf = new MessageFormat(pattern, this.locale);
        String string = mf.format(arguments, new StringBuffer(), null).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final String format(@NotNull String key, @Nullable Map<String, ? extends Object> arguments) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String pattern = this.get(key);
        MessageFormat mf = new MessageFormat(pattern, this.locale);
        String string = mf.format(arguments, new StringBuffer(), null).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final LocaleHandler getInstance(@NotNull String bundleName, @NotNull Locale locale) {
        return Companion.getInstance(bundleName, locale);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final LocaleHandler getDefault(@NotNull Locale locale) {
        return Companion.getDefault(locale);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final LocaleHandler getBanaStyles(@NotNull Locale locale) {
        return Companion.getBanaStyles(locale);
    }

    @JvmStatic
    public static final void clearLocaleCache() {
        Companion.clearLocaleCache();
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final LocaleHandler getInstance(@NotNull String bundleName) {
        return Companion.getInstance(bundleName);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final LocaleHandler getDefault() {
        return Companion.getDefault();
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final LocaleHandler getBanaStyles() {
        return Companion.getBanaStyles();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00072\b\b\u0002\u0010\r\u001a\u00020\bH\u0007J\u0012\u0010\u000e\u001a\u00020\t2\b\b\u0002\u0010\r\u001a\u00020\bH\u0007J\u0012\u0010\u000f\u001a\u00020\t2\b\b\u0002\u0010\r\u001a\u00020\bH\u0007J\b\u0010\u0010\u001a\u00020\u0011H\u0007R0\u0010\u0004\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u0012\u0004\u0012\u00020\t0\u00058\u0002@\u0002X\u0083\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\n\u0010\u0003\u00a8\u0006\u0012"}, d2={"Lorg/brailleblaster/utils/localization/LocaleHandler$Companion;", "", "<init>", "()V", "lhMap", "", "Lkotlin/Pair;", "", "Ljava/util/Locale;", "Lorg/brailleblaster/utils/localization/LocaleHandler;", "getLhMap$annotations", "getInstance", "bundleName", "locale", "getDefault", "getBanaStyles", "clearLocaleCache", "", "utils"})
    @SourceDebugExtension(value={"SMAP\nLocaleHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocaleHandler.kt\norg/brailleblaster/utils/localization/LocaleHandler$Companion\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,82:1\n383#2,7:83\n*S KotlinDebug\n*F\n+ 1 LocaleHandler.kt\norg/brailleblaster/utils/localization/LocaleHandler$Companion\n*L\n70#1:83,7\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private static /* synthetic */ void getLhMap$annotations() {
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @JvmOverloads
        @NotNull
        public final LocaleHandler getInstance(@NotNull String bundleName, @NotNull Locale locale) {
            Object object;
            void $this$getOrPut$iv;
            Intrinsics.checkNotNullParameter((Object)bundleName, (String)"bundleName");
            Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
            Map map = lhMap;
            Pair key$iv = TuplesKt.to((Object)bundleName, (Object)locale);
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                LocaleHandler answer$iv = new LocaleHandler(bundleName, locale);
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            return (LocaleHandler)object;
        }

        public static /* synthetic */ LocaleHandler getInstance$default(Companion companion, String string, Locale locale, int n, Object object) {
            if ((n & 2) != 0) {
                Locale locale2 = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault(...)");
                locale = locale2;
            }
            return companion.getInstance(string, locale);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final LocaleHandler getDefault(@NotNull Locale locale) {
            Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
            return this.getInstance("i18n", locale);
        }

        public static /* synthetic */ LocaleHandler getDefault$default(Companion companion, Locale locale, int n, Object object) {
            if ((n & 1) != 0) {
                Locale locale2 = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault(...)");
                locale = locale2;
            }
            return companion.getDefault(locale);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final LocaleHandler getBanaStyles(@NotNull Locale locale) {
            Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
            return this.getInstance("bana-styles", locale);
        }

        public static /* synthetic */ LocaleHandler getBanaStyles$default(Companion companion, Locale locale, int n, Object object) {
            if ((n & 1) != 0) {
                Locale locale2 = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault(...)");
                locale = locale2;
            }
            return companion.getBanaStyles(locale);
        }

        @JvmStatic
        public final void clearLocaleCache() {
            lhMap.clear();
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final LocaleHandler getInstance(@NotNull String bundleName) {
            Intrinsics.checkNotNullParameter((Object)bundleName, (String)"bundleName");
            return org.brailleblaster.utils.localization.LocaleHandler$Companion.getInstance$default(this, bundleName, null, 2, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final LocaleHandler getDefault() {
            return org.brailleblaster.utils.localization.LocaleHandler$Companion.getDefault$default(this, null, 1, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final LocaleHandler getBanaStyles() {
            return org.brailleblaster.utils.localization.LocaleHandler$Companion.getBanaStyles$default(this, null, 1, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

