/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.javaChecker;

import kotlin.Metadata;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.brailleblaster.AppProperties;
import org.brailleblaster.BBIni;
import org.brailleblaster.perspectives.mvc.BBSimpleManager;
import org.brailleblaster.perspectives.mvc.SimpleEvent;
import org.brailleblaster.perspectives.mvc.events.AppStartedEvent;
import org.brailleblaster.utils.PropertyFileManager;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/brailleblaster/javaChecker/JavaCheckerModule;", "Lorg/brailleblaster/perspectives/mvc/BBSimpleManager$SimpleListener;", "<init>", "()V", "onEvent", "", "event", "Lorg/brailleblaster/perspectives/mvc/SimpleEvent;", "brailleblaster-java-checker"})
public final class JavaCheckerModule
implements BBSimpleManager.SimpleListener {
    @NotNull
    public static final JavaCheckerModule INSTANCE = new JavaCheckerModule();

    private JavaCheckerModule() {
    }

    public void onEvent(@NotNull SimpleEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event instanceof AppStartedEvent) {
            Runtime.Version minVersion = Runtime.Version.parse("21");
            Runtime.Version jvmVersion = Runtime.version();
            PropertyFileManager propManager = BBIni.getPropertyFileManager();
            Intrinsics.checkNotNull((Object)jvmVersion);
            Comparable comparable = jvmVersion;
            Runtime.Version version = Runtime.Version.parse(propManager.getProperty("javaChecker.warn.version", "11"));
            Intrinsics.checkNotNullExpressionValue((Object)version, (String)"parse(...)");
            Runtime.Version warnVersion = (Runtime.Version)ComparisonsKt.maxOf((Comparable)comparable, (Comparable)version);
            if (warnVersion.compareTo(minVersion) < 0) {
                Display display = Display.getCurrent();
                MessageDialogWithToggle result = MessageDialogWithToggle.openWarning((Shell)(display != null ? display.getActiveShell() : null), (String)"Outdated Java", (String)("Your Java runtime is no longer supported by " + AppProperties.INSTANCE.getDisplayName() + " and may in the future fail to run this software. Please update to at least Java " + minVersion + "."), (String)"Do not show this warning again", (boolean)false, null, null);
                if (result.getToggleState()) {
                    String string = minVersion.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    propManager.save("javaChecker.warn.version", string);
                }
            }
        }
    }
}

