/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.temporal;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.cast.JSToIntegerOrInfinityNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.temporal.ISODateRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainMonthDay;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainMonthDayObject;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.util.TemporalUtil;

public abstract class TemporalMonthDayFromFieldsNode
extends JavaScriptBaseNode {
    protected TemporalMonthDayFromFieldsNode() {
    }

    public abstract JSTemporalPlainMonthDayObject execute(TruffleString var1, JSDynamicObject var2, TemporalUtil.Overflow var3);

    @Specialization
    protected JSTemporalPlainMonthDayObject monthDayFromFields(TruffleString calendar, JSDynamicObject fields, TemporalUtil.Overflow overflow, @Cached JSToIntegerOrInfinityNode toIntOrInfinityNode, @Cached InlinedBranchProfile errorBranch) {
        JSContext context = this.getJSContext();
        TemporalUtil.calendarResolveFields(context, calendar, fields, TemporalUtil.FieldsType.MONTH_DAY, toIntOrInfinityNode);
        ISODateRecord result = TemporalUtil.calendarMonthDayToISOReferenceDate(calendar, fields, overflow);
        return JSTemporalPlainMonthDay.create(context, this.getRealm(), result.month(), result.day(), calendar, result.year(), this, errorBranch);
    }
}

