/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.utd;

import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Nodes;
import nu.xom.ParentNode;
import nu.xom.Text;
import org.brailleblaster.utd.Cursor;
import org.brailleblaster.utd.IStyle;
import org.brailleblaster.utd.IStyleMap;
import org.brailleblaster.utd.ITranslationEngine;
import org.brailleblaster.utd.MetadataHelper;
import org.brailleblaster.utd.PageBuilder;
import org.brailleblaster.utd.PageNumberTracker;
import org.brailleblaster.utd.StyleMap;
import org.brailleblaster.utd.StyleStack;
import org.brailleblaster.utd.exceptions.UTDInterruption;
import org.brailleblaster.utd.formatters.Formatter;
import org.brailleblaster.utd.formatters.LiteraryFormatter;
import org.brailleblaster.utd.internal.PartialFormatNodeAncestor;
import org.brailleblaster.utd.internal.elements.NewPage;
import org.brailleblaster.utd.properties.PageNumberType;
import org.brailleblaster.utd.properties.UTDElements;
import org.brailleblaster.utd.tables.AutoTableFormatter;
import org.brailleblaster.utd.utils.PageBuilderHelper;
import org.brailleblaster.utd.utils.UTDHelper;
import org.brailleblaster.utd.utils.dom.BoxUtils;
import org.brailleblaster.utils.Counter;
import org.brailleblaster.utils.CountersKt;
import org.brailleblaster.utils.RepeatingLetters;
import org.brailleblaster.utils.SetList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 92\u00020\u0001:\u00019B#\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u0011\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\nJ\u0010\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u001e\u0010\u001f\u001a\u00020 2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\"J\u0016\u0010#\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020 0$H\u0002J\u0018\u0010%\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010&\u001a\u0004\u0018\u00010'J*\u0010(\u001a\u00020 2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*2\u0006\u0010,\u001a\u00020\u001c2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\"J\u0016\u0010-\u001a\u00020 2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020 0$H\u0002J\u001a\u0010/\u001a\u00020\u00162\b\u00100\u001a\u0004\u0018\u00010\u001c2\u0006\u00101\u001a\u000202H\u0002J\u000e\u00106\u001a\u00020\u00162\u0006\u00107\u001a\u00020\fJ\u0010\u00108\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u000e\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u00103\u001a\u0002028F\u00a2\u0006\u0006\u001a\u0004\b4\u00105\u00a8\u0006:"}, d2={"Lorg/brailleblaster/utd/FormatSelector;", "", "styleMap", "Lorg/brailleblaster/utd/IStyleMap;", "styleStack", "Lorg/brailleblaster/utd/StyleStack;", "engine", "Lorg/brailleblaster/utd/ITranslationEngine;", "<init>", "(Lorg/brailleblaster/utd/IStyleMap;Lorg/brailleblaster/utd/StyleStack;Lorg/brailleblaster/utd/ITranslationEngine;)V", "(Lorg/brailleblaster/utd/ITranslationEngine;)V", "pageLimit", "", "Ljava/lang/Integer;", "totalPageCount", "startIndex", "getStartIndex", "()I", "setStartIndex", "(I)V", "processedPages", "formatDocument", "", "doc", "Lnu/xom/Document;", "isNewLine", "", "node", "Lnu/xom/Node;", "isIgnorableNode", "currPage", "formatNode", "Lorg/brailleblaster/utd/PageBuilder;", "pageBuilders", "", "handleNewLine", "", "startPartialFormat", "printPageBrl", "Lnu/xom/Element;", "partialFormat", "pathToStart", "Ljava/util/Deque;", "Lorg/brailleblaster/utd/internal/PartialFormatNodeAncestor;", "startPoint", "writePagesUTD", "results", "addStyleAttributes", "n", "style", "Lorg/brailleblaster/utd/IStyle;", "currentStyle", "getCurrentStyle", "()Lorg/brailleblaster/utd/IStyle;", "increaseTotalPageCount", "count", "cleanMetaData", "Companion", "utd"})
@SourceDebugExtension(value={"SMAP\nFormatSelector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FormatSelector.kt\norg/brailleblaster/utd/FormatSelector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,416:1\n1#2:417\n*E\n"})
public final class FormatSelector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public final IStyleMap styleMap;
    @JvmField
    @NotNull
    public final StyleStack styleStack;
    @JvmField
    @NotNull
    public final ITranslationEngine engine;
    @Nullable
    private Integer pageLimit;
    private int totalPageCount;
    private int startIndex;
    private int processedPages;
    private int currPage;
    private static final Logger log = LoggerFactory.getLogger(FormatSelector.class);
    private static boolean enableWriteUTD = true;

    public FormatSelector(@Nullable IStyleMap styleMap, @Nullable StyleStack styleStack, @NotNull ITranslationEngine engine) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        if (!(styleMap != null && styleStack != null)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.styleMap = styleMap;
        this.styleStack = styleStack;
        this.engine = engine;
        this.totalPageCount = 0;
    }

    public final int getStartIndex() {
        return this.startIndex;
    }

    public final void setStartIndex(int n) {
        this.startIndex = n;
    }

    public FormatSelector(@NotNull ITranslationEngine engine) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        this(new StyleMap(), new StyleStack(), engine);
    }

    public final void formatDocument(@Nullable Document doc) {
        if (doc == null) {
            boolean $i$a$-requireNotNull-FormatSelector$formatDocument$22 = false;
            String $i$a$-requireNotNull-FormatSelector$formatDocument$22 = "Expected Document, received null";
            throw new IllegalArgumentException($i$a$-requireNotNull-FormatSelector$formatDocument$22.toString());
        }
        this.pageLimit = null;
        SetList pbs = new SetList();
        pbs.add((Object)new PageBuilder(this.engine, new Cursor(0.0, 0.0, 3, null), new PageNumberTracker(null, 1, null)));
        this.cleanMetaData(doc);
        PageBuilder pageBuilder = this.formatNode((Node)doc, (Set)pbs);
        pageBuilder.writeUTD();
        Set<Element> brls = pageBuilder.getBrlElementsOnPage();
        for (Element brl : brls) {
            this.engine.getCallback().onUpdateNode((Node)brl);
        }
    }

    private final boolean isNewLine(Node node) {
        if (node instanceof Element) {
            return Intrinsics.areEqual((Object)"http://brailleblaster.org/ns/utd", (Object)((Element)node).getNamespaceURI()) && Intrinsics.areEqual((Object)"newLine", (Object)((Element)node).getLocalName());
        }
        return false;
    }

    private final boolean isIgnorableNode(Node node) {
        boolean bl;
        if (this.pageLimit != null) {
            Integer n = this.pageLimit;
            Intrinsics.checkNotNull((Object)n);
            if (this.processedPages > n) {
                return true;
            }
        }
        if (node instanceof Element) {
            if (!PageBuilderHelper.isSkipLinesNode(node)) {
                String action = ((Element)node).getAttributeValue("utd-action");
                String action2 = ((Element)node).getAttributeValue("overrideAction", "http://brailleblaster.org/ns/utd");
                if (action != null && Intrinsics.areEqual((Object)action, (Object)"SkipAction") || action2 != null && Intrinsics.areEqual((Object)action2, (Object)"SkipAction")) {
                    return true;
                }
            }
            String string = ((Element)node).getAttributeValue("class");
            bl = string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"utd:table", (boolean)false, (int)2, null) : false;
        } else {
            bl = !(node instanceof Text);
        }
        return bl;
    }

    @NotNull
    public final PageBuilder formatNode(@Nullable Node node, @NotNull Set<PageBuilder> pageBuilders) {
        Intrinsics.checkNotNullParameter(pageBuilders, (String)"pageBuilders");
        Set<PageBuilder> pageBuilders2 = pageBuilders;
        if (Thread.currentThread().isInterrupted()) {
            log.warn("Abort current thread");
            throw new UTDInterruption();
        }
        log.debug(" formatNode called for {}", (Object)node);
        if (node == null) {
            boolean $i$a$-requireNotNull-FormatSelector$formatNode$22 = false;
            String $i$a$-requireNotNull-FormatSelector$formatNode$22 = "Expected node, received null";
            throw new IllegalArgumentException($i$a$-requireNotNull-FormatSelector$formatNode$22.toString());
        }
        if (node instanceof Document) {
            return this.formatNode((Node)((Document)node).getRootElement(), pageBuilders2);
        }
        if (this.isNewLine(node)) {
            return this.handleNewLine(pageBuilders2);
        }
        if (this.isIgnorableNode(node)) {
            log.debug("Ignoring node");
            return this.writePagesUTD(pageBuilders2);
        }
        PageBuilder pageBuilder = (PageBuilder)CollectionsKt.last((Iterable)pageBuilders2);
        if (this.currPage != pageBuilder.getBraillePageNumber().getPageNumber()) {
            if (pageBuilder.getBraillePageNumber().getPageNumber() == 1) {
                int n = this.totalPageCount;
                this.totalPageCount = n + 1;
            } else {
                this.totalPageCount += pageBuilder.getBraillePageNumber().getPageNumber() - this.currPage;
            }
            this.currPage = pageBuilder.getBraillePageNumber().getPageNumber();
        }
        IStyle nodeStyle = (IStyle)this.styleMap.findValueOrDefault(node);
        this.styleStack.push(nodeStyle);
        this.addStyleAttributes(node, nodeStyle);
        if (node instanceof Element) {
            BoxUtils.stripBoxBrl((Element)node);
        }
        if (enableWriteUTD) {
            PageBuilder pb = this.writePagesUTD(pageBuilders2);
            pageBuilders2.clear();
            pageBuilders2.add(pb);
        }
        if (PageBuilderHelper.isSkipLinesNode(node)) {
            v0 = PageBuilderHelper.INSTANCE.applySkipLinesNode((Element)node, this.styleStack, pageBuilders2, this);
        } else if (this.styleStack.getFormat() != null) {
            if (log.isDebugEnabled()) {
                log.debug("About to format node with {} formatter", (Object)this.styleStack.getFormat().name());
            }
            if (this.styleStack.getFormat() == IStyle.Format.SIMPLE) {
                AutoTableFormatter atf = new AutoTableFormatter();
                v0 = atf.format(node, this.styleStack, pageBuilders2, this);
            } else {
                v0 = this.styleStack.getFormat().getFormatter().format(node, this.styleStack, pageBuilders2, this);
            }
        } else {
            log.debug("About to format node with default formatter");
            v0 = pageBuilders2 = IStyle.Format.NORMAL.getFormatter().format(node, this.styleStack, pageBuilders2, this);
        }
        if (enableWriteUTD) {
            pageBuilder = this.writePagesUTD(pageBuilders2);
        }
        this.styleStack.pop();
        if (log.isDebugEnabled()) {
            Object[] objectArray = new Object[]{node, pageBuilder.getBraillePageNumber().getPageNumber(), pageBuilder.getPrintPageNumber()};
            log.debug("Finished Processing node {} which reaches to Braille page {} on print page {}", objectArray);
        }
        return pageBuilder;
    }

    private final PageBuilder handleNewLine(Set<PageBuilder> pageBuilders) {
        PageBuilder curPage = this.writePagesUTD(pageBuilders);
        Set pages = (Set)curPage.insertNewLineOverride();
        curPage = this.writePagesUTD(pages);
        return curPage;
    }

    public final void startPartialFormat(@NotNull Node node, @Nullable Element printPageBrl) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Nodes earlierNewPages = node.query("preceding::utd:newPage", UTDElements.UTD_XPATH_CONTEXT);
        if (UTDElements.NEW_PAGE.isA(node)) {
            if (earlierNewPages.size() > 0) {
                earlierNewPages.append(node);
            }
        } else {
            Node firstChild;
            Node firstBrl;
            Nodes relatedBrls = UTDHelper.INSTANCE.getBrlElements(node);
            if (relatedBrls.size() > 0 && (firstBrl = relatedBrls.get(0)).getChildCount() > 0 && UTDElements.NEW_PAGE.isA(firstChild = firstBrl.getChild(0))) {
                earlierNewPages.append(firstChild);
            }
        }
        Node startPoint = null;
        Deque pathToStart = new LinkedList();
        boolean startOfLine = false;
        int i = earlierNewPages.size();
        while (startPoint == null && i > 0) {
            Node tmpNode;
            Node tmpSP;
            pathToStart.clear();
            boolean startPointStartsBrl = false;
            Node node2 = tmpSP = earlierNewPages.get(--i);
            Intrinsics.checkNotNull((Object)node2);
            ParentNode parentNode = node2.getParent();
            Intrinsics.checkNotNull((Object)parentNode, (String)"null cannot be cast to non-null type nu.xom.Element");
            Element tmpBrl = (Element)parentNode;
            if (tmpBrl.indexOf(tmpSP) == 0) {
                startPointStartsBrl = true;
            }
            if (UTDHelper.getAssociatedNode(tmpBrl) == null) continue;
            while (tmpNode != null) {
                IStyle tmpStyle = (IStyle)this.styleMap.findValueOrDefault(tmpNode);
                IStyle.Format tmpFormat = tmpStyle.getFormat();
                if (tmpFormat == null || tmpFormat == IStyle.Format.NORMAL) {
                    if (startPointStartsBrl) {
                        Element firstBrl = UTDHelper.getDescendantBrlFastFirst(tmpNode);
                        if (firstBrl != null && !Intrinsics.areEqual((Object)tmpBrl, (Object)firstBrl)) {
                            startPointStartsBrl = false;
                        } else if (!startOfLine && tmpStyle.getLinesBefore() > 0 && firstBrl != null && Intrinsics.areEqual((Object)tmpBrl, (Object)firstBrl)) {
                            startOfLine = true;
                        }
                    }
                    pathToStart.addFirst(new PartialFormatNodeAncestor(tmpNode, tmpStyle, startOfLine, startPointStartsBrl));
                    tmpNode = (Node)tmpNode.getParent();
                    continue;
                }
                tmpSP = null;
                tmpNode = null;
            }
            startPoint = tmpSP;
        }
        if (startPoint == null) {
            this.formatDocument(node.getDocument());
            return;
        }
        Node node3 = earlierNewPages.get(0);
        Intrinsics.checkNotNull((Object)node3, (String)"null cannot be cast to non-null type nu.xom.Element");
        NewPage newPage = new NewPage((Element)node3);
        this.totalPageCount = earlierNewPages.size();
        PageNumberTracker pageNumber = new PageNumberTracker(newPage.getPageNumber(), newPage.getPageNumberType(), this.engine.getPageSettings().isContinuePages());
        PageNumberType curType = newPage.getPageNumberType();
        for (i = 1; i < earlierNewPages.size(); ++i) {
            Node child = earlierNewPages.get(i);
            Intrinsics.checkNotNull((Object)child, (String)"null cannot be cast to non-null type nu.xom.Element");
            newPage = new NewPage((Element)child);
            if (curType != newPage.getPageNumberType()) {
                curType = newPage.getPageNumberType();
                pageNumber.setPageNumberType(curType, this.engine.getPageSettings().isContinuePages());
            } else if (newPage.getPageNumber() != pageNumber.getPageNumber()) {
                if (newPage.getPageNumber() == 1) {
                    pageNumber.resetNumberCounters(newPage.getPageNumberType(), this.engine.getPageSettings().isContinuePages());
                } else {
                    pageNumber = pageNumber.nextPage(newPage.getPageNumberType(), this.engine.getPageSettings().isContinuePages());
                }
            }
            if (Intrinsics.areEqual((Object)child, (Object)startPoint)) break;
        }
        PageBuilder pageBuilder = new PageBuilder(this.engine, new Cursor(0.0, 0.0, 3, null), pageNumber);
        SetList pageBuilders = new SetList();
        pageBuilders.add((Object)pageBuilder);
        if (printPageBrl != null) {
            String string = printPageBrl.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
            String string2 = printPageBrl.getAttributeValue("printPageBrl");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAttributeValue(...)");
            String newContLetter = StringsKt.replace$default((String)string, (String)string2, (String)"", (boolean)false, (int)4, null);
            if (((CharSequence)newContLetter).length() > 0) {
                String string3 = printPageBrl.getAttributeValue("printPageBrl");
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getAttributeValue(...)");
                pageBuilder.setPrintPageBrl(string3, (Counter)RepeatingLetters.box-impl((int)CountersKt.toRepeatingLetters((String)newContLetter)));
            } else {
                String string4 = printPageBrl.getAttributeValue("printPageBrl");
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getAttributeValue(...)");
                pageBuilder.setPrintPageBrl(string4);
            }
            String string5 = printPageBrl.getAttributeValue("printPage");
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getAttributeValue(...)");
            pageBuilder.setPrintPageNumber(string5);
        }
        pageBuilder.setStartOfBlock(startOfLine);
        pageBuilder = this.partialFormat(pathToStart, startPoint, (Set)pageBuilders);
        if (!pageBuilder.hasWrittenUTD()) {
            pageBuilder.writeUTD();
            Set<Element> brls = pageBuilder.getBrlElementsOnPage();
            for (Element brl : brls) {
                this.engine.getCallback().onUpdateNode((Node)brl);
            }
        }
    }

    @NotNull
    public final PageBuilder partialFormat(@NotNull Deque<PartialFormatNodeAncestor> pathToStart, @NotNull Node startPoint, @NotNull Set<PageBuilder> pageBuilders) {
        PageBuilder pageBuilder;
        Intrinsics.checkNotNullParameter(pathToStart, (String)"pathToStart");
        Intrinsics.checkNotNullParameter((Object)startPoint, (String)"startPoint");
        Intrinsics.checkNotNullParameter(pageBuilders, (String)"pageBuilders");
        PartialFormatNodeAncestor pathElement = pathToStart.getFirst();
        Node node = pathElement.getNode();
        IStyle style = pathElement.getStyle();
        this.styleStack.push(style);
        this.addStyleAttributes(node, style);
        if (node instanceof Element) {
            if (pathElement.isFirstBrailleAtStartPoint()) {
                BoxUtils.stripBoxBrl((Element)node);
            } else {
                Element endSeparator;
                Element element = endSeparator = BoxUtils.INSTANCE.getEndSeparator((Element)node);
                if (element != null) {
                    element.detach();
                }
            }
        }
        Formatter formatter = IStyle.Format.NORMAL.getFormatter();
        Intrinsics.checkNotNull((Object)formatter, (String)"null cannot be cast to non-null type org.brailleblaster.utd.formatters.LiteraryFormatter");
        pageBuilders.addAll((Collection<PageBuilder>)((LiteraryFormatter)formatter).partialFormat(pathToStart, startPoint, this.styleStack, pageBuilders, this));
        PageBuilder it = pageBuilder = this.writePagesUTD(pageBuilders);
        boolean bl = false;
        this.styleStack.pop();
        return pageBuilder;
    }

    private final PageBuilder writePagesUTD(Set<PageBuilder> results) {
        PageBuilder pageBuilder = null;
        Iterator<PageBuilder> iter = results.iterator();
        while (iter.hasNext()) {
            PageBuilder iterPB = iter.next();
            if (!iter.hasNext()) {
                pageBuilder = iterPB;
                break;
            }
            if (iterPB.hasWrittenUTD()) continue;
            ++this.processedPages;
            iterPB.writeUTD();
        }
        PageBuilder pageBuilder2 = pageBuilder;
        Intrinsics.checkNotNull(pageBuilder2);
        return pageBuilder2;
    }

    private final void addStyleAttributes(Node n, IStyle style) {
        if (n instanceof Element) {
            Attribute styleAttribute = new Attribute("utd-style", style.getName());
            ((Element)n).addAttribute(styleAttribute);
        }
    }

    @NotNull
    public final IStyle getCurrentStyle() {
        return this.styleStack;
    }

    public final void increaseTotalPageCount(int count) {
        this.totalPageCount += count;
    }

    private final void cleanMetaData(Document doc) {
        List<Element> metas = MetadataHelper.getUTDMeta(doc);
        for (Element meta : metas) {
            if (meta.getAttribute("used") == null) continue;
            meta.removeAttribute(meta.getAttribute("used"));
        }
    }

    @JvmStatic
    public static final void setEnableWriteUTD(boolean enableWriteUTD) {
        Companion.setEnableWriteUTD(enableWriteUTD);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0007R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/brailleblaster/utd/FormatSelector$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "enableWriteUTD", "", "setEnableWriteUTD", "", "utd"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void setEnableWriteUTD(boolean enableWriteUTD) {
            enableWriteUTD = enableWriteUTD;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

