/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.utd;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import nu.xom.Document;
import nu.xom.Node;
import nu.xom.Nodes;
import org.brailleblaster.utd.IStyle;
import org.brailleblaster.utd.IStyleMap;
import org.brailleblaster.utd.ITranslationEngine;
import org.brailleblaster.utd.Style;
import org.brailleblaster.utd.UTDTranslationEngine;
import org.brailleblaster.utd.matchers.XPathMatcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\rJ \u0010\u000e\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\b\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\f\u00a8\u0006\u0012"}, d2={"Lorg/brailleblaster/utd/GuideWords;", "", "<init>", "()V", "applyGuide", "", "document", "Lnu/xom/Document;", "engine", "Lorg/brailleblaster/utd/UTDTranslationEngine;", "findGuideWords", "node", "Lnu/xom/Node;", "Lorg/brailleblaster/utd/ITranslationEngine;", "styleMapper", "xpath", "", "parentNode", "utd"})
public final class GuideWords {
    public final void applyGuide(@NotNull Document document, @NotNull UTDTranslationEngine engine) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        Nodes lists = document.query("descendant::*[name()='dl'][ancestor::rearmatter]");
        int n = lists.size();
        for (int i = 0; i < n; ++i) {
            Node node = lists.get(i);
            Intrinsics.checkNotNullExpressionValue((Object)node, (String)"get(...)");
            IStyle style = engine.getStyle(node);
            if (style == null || !style.isGuideWords()) continue;
            Node node2 = lists.get(i);
            Intrinsics.checkNotNullExpressionValue((Object)node2, (String)"get(...)");
            this.findGuideWords(node2, engine);
        }
    }

    public final void findGuideWords(@NotNull Node node, @NotNull ITranslationEngine engine) {
        String xpathSib;
        int i;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        this.styleMapper("child::*[name()='dt'][1]", engine, node);
        this.styleMapper("child::*[name()='dt'][last()]", engine, node);
        String xpathMain = "child::*[name()='dt'][preceding::*[name()='newpage']][preceding-sibling::*[1][name()!='dd']]";
        Nodes foundNodes = node.query(xpathMain);
        String xpath = null;
        int n = foundNodes.size();
        for (i = 0; i < n; ++i) {
            xpath = xpathMain + "[" + (i + 1) + "]";
            this.styleMapper(xpath, engine, node);
        }
        xpathMain = "child::*[name()='dt'][preceding::*[name()='newpage']][following-sibling::*[2][name()!='dt']]";
        foundNodes = node.query(xpathMain);
        n = foundNodes.size();
        for (i = 0; i < n; ++i) {
            xpath = xpathMain + "[" + (i + 1) + "]";
            this.styleMapper(xpath, engine, node);
        }
        xpathMain = "child::*[name()='dt'][descendant::*[name()='newpage']]";
        foundNodes = node.query(xpathMain);
        n = foundNodes.size();
        for (i = 0; i < n; ++i) {
            xpath = xpathMain + "[" + (i + 1) + "]";
            this.styleMapper(xpath, engine, node);
            xpathSib = "following-sibling::*[name()='dt'][1]";
            Node node2 = foundNodes.get(i);
            Intrinsics.checkNotNullExpressionValue((Object)node2, (String)"get(...)");
            this.styleMapper(xpathSib, engine, node2);
        }
        xpathMain = "child::*[name()='dd'][descendant::*[name()='newpage']]";
        foundNodes = node.query(xpathMain);
        n = foundNodes.size();
        for (i = 0; i < n; ++i) {
            xpath = xpathMain + "[" + (i + 1) + "]";
            this.styleMapper(xpath, engine, node);
            xpathSib = "following-sibling::*[name()='dt'][1]";
            Node node3 = foundNodes.get(i);
            Intrinsics.checkNotNullExpressionValue((Object)node3, (String)"get(...)");
            this.styleMapper(xpathSib, engine, node3);
            xpathSib = "preceding-sibling::*[name()='dt'][1]";
            Node node4 = foundNodes.get(i);
            Intrinsics.checkNotNullExpressionValue((Object)node4, (String)"get(...)");
            this.styleMapper(xpathSib, engine, node4);
        }
    }

    public final void styleMapper(@Nullable String xpath, @NotNull ITranslationEngine engine, @NotNull Node parentNode) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        Intrinsics.checkNotNullParameter((Object)parentNode, (String)"parentNode");
        IStyleMap styleMap = engine.getStyleMap();
        Node incNode = parentNode.query(xpath).get(0);
        Intrinsics.checkNotNull((Object)incNode);
        Object v = styleMap.findValueOrDefault(incNode);
        Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type org.brailleblaster.utd.Style");
        Style style = (Style)v;
        style.setGuideWords(true);
        ((Map)styleMap).put(new XPathMatcher(xpath), style);
    }
}

