/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.utd;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.brailleblaster.utd.InsertionPatternEntry;
import org.brailleblaster.utd.LineWrapper;
import org.brailleblaster.utd.exceptions.NoLineBreakPointException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0005\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u001b\b\u0007\u0012\u0010\b\u0002\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0012H\u0016J\u001a\u0010\u0018\u001a\u00020\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u001bR\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\r0\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006 "}, d2={"Lorg/brailleblaster/utd/RegexLineWrapper;", "Lorg/brailleblaster/utd/LineWrapper;", "patterns", "", "Lorg/brailleblaster/utd/InsertionPatternEntry;", "<init>", "(Ljava/util/List;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "matchPatterns", "", "Ljava/util/regex/Pattern;", "", "findNextBreakPoint", "Lorg/brailleblaster/utd/LineWrapper$LineBreakResult;", "brlText", "startPoint", "", "lineWrapCheck", "checkStartLineInsertion", "Lorg/brailleblaster/utd/LineWrapper$InsertionResult;", "start", "startLineInsertions", "setLineStartInsertions", "", "insertions", "", "lineStartInsertions", "getLineStartInsertions", "()Ljava/util/Map;", "Companion", "utd"})
public final class RegexLineWrapper
implements LineWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final Logger log;
    @NotNull
    private final Map<Pattern, String> matchPatterns;
    @NotNull
    private final Map<Pattern, String> startLineInsertions;
    @JvmField
    @NotNull
    public static final List<InsertionPatternEntry> NEMETH_BREAK_POINTS;
    @JvmField
    @NotNull
    public static final List<InsertionPatternEntry> UEB_MATH_BREAK_POINTS;

    @JvmOverloads
    public RegexLineWrapper(@Nullable List<InsertionPatternEntry> patterns) {
        this.log = LoggerFactory.getLogger(RegexLineWrapper.class);
        this.matchPatterns = new LinkedHashMap();
        this.startLineInsertions = new LinkedHashMap();
        this.log.debug("Creating RegexLineWrapper with expressions {}", patterns);
        if (patterns != null) {
            for (InsertionPatternEntry patternStr : patterns) {
                this.matchPatterns.put(Pattern.compile(patternStr.getMatchPattern()), patternStr.getInsertionDots());
                this.log.debug("Added pattern \"{}\" to list of patterns", (Object)patternStr);
            }
        }
        this.matchPatterns.put(Pattern.compile(" "), null);
        this.matchPatterns.put(Pattern.compile("\u00a0"), null);
        this.log.debug("Finished creating RegexLineWrapper");
    }

    public /* synthetic */ RegexLineWrapper(List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            list = null;
        }
        this(list);
    }

    @Override
    @NotNull
    public LineWrapper.LineBreakResult findNextBreakPoint(@NotNull String brlText, int startPoint, int lineWrapCheck) throws NoLineBreakPointException {
        Intrinsics.checkNotNullParameter((Object)brlText, (String)"brlText");
        int maxLineLength = startPoint + lineWrapCheck;
        int continuationDotsPos = -1;
        if (maxLineLength >= brlText.length()) {
            this.log.debug("No need for line wrapping as text is shorter than remaining line, inText \"{}\"", (Object)brlText);
            return new LineWrapper.LineBreakResult(brlText.length(), null, -1);
        }
        int breakPoint = 0;
        int outsideBreakPoint = brlText.length();
        int outsideContinuationDotsPos = -1;
        String outsideContinuationDots = null;
        String continuationDots = null;
        for (Map.Entry<Pattern, String> entry : this.matchPatterns.entrySet()) {
            Pattern p = entry.getKey();
            String curContDots = entry.getValue();
            breakPoint = -1;
            int i = startPoint;
            Matcher m = p.matcher(brlText);
            this.log.debug("Testing pattern {}", (Object)m.pattern().pattern());
            while (i <= maxLineLength && m.find(i)) {
                boolean bl;
                int n;
                i = m.end();
                try {
                    n = m.end("contDots");
                }
                catch (IllegalArgumentException e) {
                    n = -1;
                }
                int contDotsEnd = n;
                if (contDotsEnd >= 0) {
                    String string = curContDots;
                    Intrinsics.checkNotNull((Object)string);
                    bl = i <= maxLineLength - string.length();
                } else {
                    bl = i <= maxLineLength;
                }
                boolean isInBoundBreak = bl;
                this.log.debug("i={}, maxLineLength={}", (Object)i, (Object)maxLineLength);
                if (!isInBoundBreak) {
                    if (i >= outsideBreakPoint) break;
                    outsideContinuationDotsPos = contDotsEnd;
                    outsideContinuationDots = curContDots;
                    outsideBreakPoint = i;
                    break;
                }
                continuationDotsPos = contDotsEnd;
                continuationDots = curContDots;
                breakPoint = i++;
            }
            if (breakPoint <= startPoint) continue;
            this.log.debug("Found break point at {} in inText \"{}\"", (Object)breakPoint, (Object)brlText);
            return new LineWrapper.LineBreakResult(breakPoint, continuationDots, continuationDotsPos);
        }
        this.log.debug("No line break inside preferred line length, next possible break point is {}", (Object)outsideBreakPoint);
        throw new NoLineBreakPointException("No possible line break was found for preferred length", new LineWrapper.LineBreakResult(outsideBreakPoint, outsideContinuationDots, outsideContinuationDotsPos));
    }

    @Override
    @NotNull
    public LineWrapper.InsertionResult checkStartLineInsertion(@NotNull String brlText, int start) {
        Intrinsics.checkNotNullParameter((Object)brlText, (String)"brlText");
        for (Map.Entry<Pattern, String> entry : this.startLineInsertions.entrySet()) {
            Pattern p = entry.getKey();
            String value = entry.getValue();
            Matcher m = p.matcher(brlText);
            if (!(m = m.region(start, brlText.length())).lookingAt()) continue;
            return new LineWrapper.InsertionResult(value, m.end());
        }
        return new LineWrapper.InsertionResult(null, -1);
    }

    public final void setLineStartInsertions(@NotNull Map<String, String> insertions) {
        Intrinsics.checkNotNullParameter(insertions, (String)"insertions");
        this.startLineInsertions.clear();
        for (Map.Entry<String, String> entry : insertions.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            this.startLineInsertions.put(Pattern.compile(key), value);
        }
    }

    @NotNull
    public final Map<String, String> getLineStartInsertions() {
        Map result = new LinkedHashMap();
        for (Map.Entry<Pattern, String> entry : this.startLineInsertions.entrySet()) {
            Pattern key = entry.getKey();
            String value = entry.getValue();
            result.put(key.pattern(), value);
        }
        return result;
    }

    @JvmOverloads
    public RegexLineWrapper() {
        this(null, 1, null);
    }

    static {
        Object[] objectArray = new InsertionPatternEntry[]{new InsertionPatternEntry(" (?=(/?\\.k|\\.1|\"\\.) )", "\""), new InsertionPatternEntry("(?=\\+|-|\\./|`\\*)", "\"")};
        NEMETH_BREAK_POINTS = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new InsertionPatternEntry[]{new InsertionPatternEntry("(?=\"7|`[<>])", "\""), new InsertionPatternEntry("(?=\"[68-])", "\"")};
        UEB_MATH_BREAK_POINTS = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/brailleblaster/utd/RegexLineWrapper$Companion;", "", "<init>", "()V", "NEMETH_BREAK_POINTS", "", "Lorg/brailleblaster/utd/InsertionPatternEntry;", "UEB_MATH_BREAK_POINTS", "utd"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

