/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.utd;

import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.annotation.XmlAccessOrder;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorOrder;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlID;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlTransient;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import nu.xom.Node;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.brailleblaster.utd.ConditionalValue;
import org.brailleblaster.utd.IConditionalValueGetter;
import org.brailleblaster.utd.IStyle;
import org.brailleblaster.utd.NamespaceMap;
import org.brailleblaster.utd.internal.StyleOptionsFactory;
import org.brailleblaster.utd.properties.Align;
import org.brailleblaster.utd.properties.NumberLinePosition;
import org.brailleblaster.utd.properties.PageNumberType;
import org.brailleblaster.utd.properties.PageSide;
import org.brailleblaster.utd.utils.UTDHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlAccessorOrder(value=XmlAccessOrder.ALPHABETICAL)
@XmlSeeAlso(value={StyleOptionsFactory.class})
public class Style
implements IStyle,
Serializable {
    @XmlTransient
    @Nullable
    private Style baseStyle;
    @XmlAttribute(name="baseStyle")
    @Nullable
    private String baseStyleName;
    private static final Logger log = LoggerFactory.getLogger(Style.class);
    @XmlTransient
    private static final StyleOptionsFactory factory = new StyleOptionsFactory();
    @XmlElement
    private String id;
    @XmlID
    @XmlElement(required=true)
    private String name;
    @XmlElementRef(name="linesBefore")
    private JAXBElement<Integer> linesBefore = null;
    @XmlElementRef(name="linesAfter")
    private JAXBElement<Integer> linesAfter = null;
    @XmlElementRef(name="indent")
    private JAXBElement<Integer> indent = null;
    @XmlElementRef(name="lineLength")
    private JAXBElement<Integer> lineLength = null;
    @XmlElementRef(name="firstLineIndent")
    private JAXBElement<Integer> firstLineIndent = null;
    @XmlElementRef(name="skipNumberLines")
    private JAXBElement<NumberLinePosition> skipNumberLines = null;
    @XmlElementRef(name="skipPages")
    private JAXBElement<Integer> skipPages = null;
    @XmlElementRef(name="align")
    private JAXBElement<Align> align = null;
    @XmlElementRef(name="format")
    private JAXBElement<IStyle.Format> format = null;
    @XmlElementRef(name="newPagesBefore")
    private JAXBElement<Integer> newPagesBefore = null;
    @XmlElementRef(name="newPagesAfter")
    private JAXBElement<Integer> newPagesAfter = null;
    @XmlElementRef(name="pageSide")
    private JAXBElement<PageSide> pageSide = null;
    @XmlElementRef(name="braillePageNumberFormat")
    private JAXBElement<PageNumberType> braillePageNumberFormat;
    @XmlElementRef(name="dontSplit")
    private JAXBElement<Boolean> dontSplit = null;
    @XmlElementRef(name="keepWithNext")
    private JAXBElement<Boolean> keepWithNext = null;
    @XmlElementRef(name="keepWithPrevious")
    private JAXBElement<Boolean> keepWithPrevious = null;
    @XmlElementRef(name="orphanControl")
    private JAXBElement<Integer> orphanControl = null;
    @XmlElementRef(name="isTable")
    private JAXBElement<Boolean> isTable = null;
    @XmlElementRef(name="isTableRow")
    private JAXBElement<Boolean> isTableRow = null;
    @XmlElementRef(name="isTableCell")
    private JAXBElement<Boolean> isTableCell = null;
    @XmlElementRef(name="lineSpacing")
    private JAXBElement<Integer> lineSpacing = null;
    @XmlElementRef(name="guideWords")
    private JAXBElement<Boolean> guideWords = null;
    @XmlElementRef(name="startSeparator")
    private JAXBElement<String> startSeparator = null;
    @XmlElementRef(name="color")
    private JAXBElement<String> color = null;
    @XmlElementRef(name="endSeparator")
    private JAXBElement<String> endSeparator = null;
    @XmlElementRef(name="pageNum")
    private JAXBElement<Boolean> pageNum = null;
    @XmlElementRef(name="lineNumber")
    private JAXBElement<Boolean> lineNumber = null;
    @XmlElementRef(name="volumeEnd")
    private JAXBElement<Boolean> volumeEnd = null;
    private List<ConditionalValue<Integer>> linesBeforeWhen;
    private List<ConditionalValue<Integer>> linesAfterWhen;
    @XmlElementRef(name="leftPadding")
    private JAXBElement<Integer> leftPadding = null;
    @XmlElementRef(name="rightPadding")
    private JAXBElement<Integer> rightPadding;

    public Style(Style otherStyle, String newId, String newName) {
        this(otherStyle);
        this.id = newId;
        this.name = newName;
    }

    private Style(IStyle defaultStyle) {
        if (defaultStyle instanceof Style) {
            this.setBaseStyle((Style)defaultStyle);
        }
        this.id = defaultStyle.getId();
        this.name = defaultStyle.getName();
        this.linesBeforeWhen = defaultStyle.getLinesBeforeWhen();
        this.linesAfterWhen = defaultStyle.getLinesAfterWhen();
    }

    public Style() {
        this.id = "DEFAULT";
        this.name = "DEFAULT";
        this.linesBeforeWhen = new ArrayList<ConditionalValue<Integer>>();
        this.linesAfterWhen = new ArrayList<ConditionalValue<Integer>>();
    }

    @Override
    @NotNull
    public Style copy(@NotNull String id, @NotNull String name) {
        Style copy = new Style();
        if (this.baseStyle != null) {
            copy.setBaseStyle(this.getBaseStyle());
        }
        if (this.align != null) {
            copy.setAlign(this.getAlign());
        }
        if (this.braillePageNumberFormat != null) {
            copy.setBraillePageNumberFormat(this.getBraillePageNumberFormat());
        }
        if (this.dontSplit != null) {
            copy.setDontSplit(this.isDontSplit());
        }
        if (this.endSeparator != null) {
            copy.setEndSeparator(this.getEndSeparator());
        }
        if (this.firstLineIndent != null) {
            copy.setFirstLineIndent(this.getFirstLineIndent());
        }
        if (this.format != null) {
            copy.setFormat(this.getFormat());
        }
        if (this.guideWords != null) {
            copy.setGuideWords(this.isGuideWords());
        }
        copy.setId(id);
        if (this.indent != null) {
            copy.setIndent(this.getIndent());
        }
        if (this.keepWithNext != null) {
            copy.setKeepWithNext(this.isKeepWithNext());
        }
        if (this.keepWithPrevious != null) {
            copy.setKeepWithPrevious(this.isKeepWithPrevious());
        }
        if (this.lineLength != null) {
            copy.setLineLength(this.getLineLength());
        }
        if (this.lineNumber != null) {
            copy.setLineNumber(this.isLineNumber());
        }
        if (this.linesAfter != null) {
            copy.setLinesAfter(this.getLinesAfter());
        }
        if (this.linesBefore != null) {
            copy.setLinesBefore(this.getLinesBefore());
        }
        if (this.lineSpacing != null) {
            copy.setLineSpacing(this.getLineSpacing());
        }
        if (this.linesBeforeWhen != null) {
            copy.setLinesBeforeWhen(this.getAllLinesBeforeWhen());
        }
        if (this.linesAfterWhen != null) {
            copy.setLinesAfterWhen(this.getAllLinesAfterWhen());
        }
        copy.setName(name);
        if (this.newPagesAfter != null) {
            copy.setNewPagesAfter(this.getNewPagesAfter());
        }
        if (this.newPagesBefore != null) {
            copy.setNewPagesBefore(this.getNewPagesBefore());
        }
        if (this.orphanControl != null) {
            copy.setOrphanControl(this.getOrphanControl());
        }
        if (this.pageNum != null) {
            copy.setPageNum(this.isPageNum());
        }
        if (this.pageSide != null) {
            copy.setPageSide(this.getPageSide());
        }
        if (this.skipNumberLines != null) {
            copy.setSkipNumberLines(this.getSkipNumberLines());
        }
        if (this.skipPages != null) {
            copy.setSkipPages(this.getSkipPages());
        }
        if (this.startSeparator != null) {
            copy.setStartSeparator(this.getStartSeparator());
        }
        if (this.color != null) {
            copy.setColor(this.getColor());
        }
        if (this.isTable != null) {
            copy.setIsTable(this.isTable());
        }
        if (this.isTableCell != null) {
            copy.setIsTableCell(this.isTableCell());
        }
        if (this.isTableRow != null) {
            copy.setIsTableRow(this.isTableRow());
        }
        if (this.volumeEnd != null) {
            copy.setVolumeEnd(this.isVolumeEnd());
        }
        return copy;
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    public Style setId(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new IllegalArgumentException("Style ID cannot be blank");
        }
        this.id = id;
        return this;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    public Style setName(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("Name cannot be blank");
        }
        this.name = name;
        return this;
    }

    @Override
    public int getLinesBefore() {
        if (this.linesBefore != null) {
            return (Integer)this.linesBefore.getValue();
        }
        if (this.baseStyle != null) {
            return this.baseStyle.getLinesBefore();
        }
        return (Integer)StyleOption.LINES_BEFORE.getDefaultValue();
    }

    public Style setLinesBefore(int linesBefore) {
        this.validateLinesBefore(linesBefore);
        if (this.baseStyle == null && (Integer)StyleOption.LINES_BEFORE.getDefaultValue() == linesBefore) {
            this.linesBefore = null;
        } else if (this.linesBefore == null) {
            this.linesBefore = factory.createLinesBefore(linesBefore);
        } else {
            this.linesBefore.setValue((Object)linesBefore);
        }
        return this;
    }

    private void validateLinesBefore(int linesBefore) {
        if (linesBefore < 0) {
            throw new IllegalArgumentException("linesBefore must be positive, given " + linesBefore);
        }
    }

    @Override
    public int getLinesAfter() {
        if (this.linesAfter != null) {
            return (Integer)this.linesAfter.getValue();
        }
        if (this.baseStyle != null) {
            return this.baseStyle.getLinesAfter();
        }
        return (Integer)StyleOption.LINES_AFTER.getDefaultValue();
    }

    public Style setLinesAfter(int linesAfter) {
        this.validateLinesAfter(linesAfter);
        if (this.baseStyle == null && (Integer)StyleOption.LINES_AFTER.getDefaultValue() == linesAfter) {
            this.linesAfter = null;
        } else if (this.linesAfter == null) {
            this.linesAfter = factory.createLinesAfter(linesAfter);
        } else {
            this.linesAfter.setValue((Object)linesAfter);
        }
        return this;
    }

    private void validateLinesAfter(int linesAfter) {
        if (linesAfter < 0) {
            throw new IllegalArgumentException("linesAfter must be positive, given " + linesAfter);
        }
    }

    public void validateSkipPages(int skipPages) {
        if (skipPages < 0) {
            throw new IllegalArgumentException("skipPages must be positive, given " + skipPages);
        }
    }

    @Override
    public Integer getIndent() {
        if (this.indent != null) {
            return (Integer)this.indent.getValue();
        }
        if (this.baseStyle != null) {
            return this.baseStyle.getIndent();
        }
        return (Integer)StyleOption.INDENT.getDefaultValue();
    }

    public Style setIndent(Integer indent) {
        this.validateIndent(indent);
        if (this.baseStyle == null && Objects.equals(StyleOption.INDENT.getDefaultValue(), indent)) {
            this.indent = null;
        } else if (this.indent == null) {
            this.indent = factory.createIndent(indent);
        } else {
            this.indent.setValue((Object)indent);
        }
        return this;
    }

    private void validateIndent(Integer indent) {
        if (indent != null && indent < 0) {
            throw new IllegalArgumentException("indent must be positive, given " + indent);
        }
    }

    @Override
    public Integer getLineLength() {
        if (this.lineLength != null) {
            return (Integer)this.lineLength.getValue();
        }
        if (this.baseStyle != null) {
            return this.baseStyle.getLineLength();
        }
        return (Integer)StyleOption.LINE_LENGTH.getDefaultValue();
    }

    public Style setLineLength(Integer lineLength) {
        if (this.baseStyle == null && Objects.equals(StyleOption.LINE_LENGTH.getDefaultValue(), lineLength)) {
            this.lineLength = null;
        } else if (this.lineLength == null) {
            this.lineLength = factory.createLineLength(lineLength);
        } else {
            this.lineLength.setValue((Object)lineLength);
        }
        return this;
    }

    @Override
    public Integer getFirstLineIndent() {
        if (this.firstLineIndent != null) {
            return (Integer)this.firstLineIndent.getValue();
        }
        if (this.baseStyle != null) {
            return this.baseStyle.getFirstLineIndent();
        }
        return (Integer)StyleOption.FIRST_LINE_INDENT.getDefaultValue();
    }

    public Style setFirstLineIndent(Integer firstLineIndent) {
        this.validateFirstLineIndent(firstLineIndent);
        if (this.baseStyle == null && Objects.equals(StyleOption.FIRST_LINE_INDENT.getDefaultValue(), firstLineIndent)) {
            this.firstLineIndent = null;
        } else if (this.firstLineIndent == null) {
            this.firstLineIndent = factory.createFirstLineIndent(firstLineIndent);
        } else {
            this.firstLineIndent.setValue((Object)firstLineIndent);
        }
        return this;
    }

    private void validateFirstLineIndent(Integer firstLineIndent) {
        if (firstLineIndent != null && firstLineIndent < 0) {
            throw new IllegalArgumentException("firstLineIndent must be positive, given " + firstLineIndent);
        }
    }

    @Override
    public NumberLinePosition getSkipNumberLines() {
        if (this.skipNumberLines != null) {
            return (NumberLinePosition)((Object)this.skipNumberLines.getValue());
        }
        if (this.baseStyle != null) {
            return this.baseStyle.getSkipNumberLines();
        }
        return (NumberLinePosition)((Object)StyleOption.SKIP_NUMBER_LINES.getDefaultValue());
    }

    public Style setSkipNumberLines(NumberLinePosition skipNumberLines) {
        if (this.baseStyle == null && Objects.equals(StyleOption.SKIP_NUMBER_LINES.getDefaultValue(), (Object)skipNumberLines)) {
            this.skipNumberLines = null;
        } else if (this.skipNumberLines == null) {
            this.skipNumberLines = factory.createSkipPageNumberLines(skipNumberLines);
        } else {
            this.skipNumberLines.setValue((Object)skipNumberLines);
        }
        return this;
    }

    @Override
    public int getSkipPages() {
        if (this.skipPages != null) {
            return (Integer)this.skipPages.getValue();
        }
        if (this.baseStyle != null) {
            return this.baseStyle.getSkipPages();
        }
        return (Integer)StyleOption.SKIP_PAGES.getDefaultValue();
    }

    public Style setSkipPages(int skipPages) {
        this.validateSkipPages(skipPages);
        if (this.baseStyle == null && (Integer)StyleOption.SKIP_PAGES.getDefaultValue() == skipPages) {
            this.skipPages = null;
        } else if (this.skipPages == null) {
            this.skipPages = factory.createSkipPages(skipPages);
        } else {
            this.skipPages.setValue((Object)skipPages);
        }
        return this;
    }

    @Override
    public Align getAlign() {
        if (this.align != null) {
            return (Align)((Object)this.align.getValue());
        }
        if (this.baseStyle != null) {
            return this.baseStyle.getAlign();
        }
        return (Align)((Object)StyleOption.ALIGN.getDefaultValue());
    }

    public Style setAlign(Align align) {
        this.validateAlign(align);
        if (this.baseStyle == null && Objects.equals(StyleOption.ALIGN.getDefaultValue(), (Object)align)) {
            this.align = null;
        } else if (this.align == null) {
            this.align = factory.createAlign(align);
        } else {
            this.align.setValue((Object)align);
        }
        return this;
    }

    private void validateAlign(Align align) {
        if (align == null) {
            throw new NullPointerException("align");
        }
    }

    @Override
    public IStyle.Format getFormat() {
        if (this.format != null) {
            return (IStyle.Format)((Object)this.format.getValue());
        }
        if (this.baseStyle != null) {
            return this.baseStyle.getFormat();
        }
        return (IStyle.Format)((Object)StyleOption.FORMAT.getDefaultValue());
    }

    public Style setFormat(IStyle.Format format) {
        this.validateFormat(format);
        if (this.baseStyle == null && Objects.equals(StyleOption.FORMAT.getDefaultValue(), (Object)format)) {
            this.format = null;
        } else if (this.format == null) {
            this.format = factory.createFormat(format);
        } else {
            this.format.setValue((Object)format);
        }
        return this;
    }

    private void validateFormat(IStyle.Format format) {
        if (format == null) {
            throw new NullPointerException("format");
        }
    }

    @Override
    public int getNewPagesBefore() {
        if (this.newPagesBefore != null) {
            return (Integer)this.newPagesBefore.getValue();
        }
        if (this.baseStyle != null) {
            return this.baseStyle.getNewPagesBefore();
        }
        return (Integer)StyleOption.NEW_PAGES_BEFORE.getDefaultValue();
    }

    public Style setNewPagesBefore(int newPageBefore) {
        if (this.baseStyle == null && (Integer)StyleOption.NEW_PAGES_BEFORE.getDefaultValue() == newPageBefore) {
            this.newPagesBefore = null;
        } else if (this.newPagesBefore == null) {
            this.newPagesBefore = factory.createNewPagesBefore(newPageBefore);
        } else {
            this.newPagesBefore.setValue((Object)newPageBefore);
        }
        return this;
    }

    @Override
    public int getNewPagesAfter() {
        if (this.newPagesAfter != null) {
            return (Integer)this.newPagesAfter.getValue();
        }
        if (this.baseStyle != null) {
            return this.baseStyle.getNewPagesAfter();
        }
        return (Integer)StyleOption.NEW_PAGES_AFTER.getDefaultValue();
    }

    public Style setNewPagesAfter(int newPageAfter) {
        if (this.baseStyle == null && (Integer)StyleOption.NEW_PAGES_AFTER.getDefaultValue() == newPageAfter) {
            this.newPagesAfter = null;
        } else if (this.newPagesAfter == null) {
            this.newPagesAfter = factory.createNewPagesAfter(newPageAfter);
        } else {
            this.newPagesAfter.setValue((Object)newPageAfter);
        }
        return this;
    }

    @Override
    public PageSide getPageSide() {
        if (this.pageSide != null) {
            return (PageSide)((Object)this.pageSide.getValue());
        }
        if (this.baseStyle != null) {
            return this.baseStyle.getPageSide();
        }
        return (PageSide)((Object)StyleOption.PAGE_SIDE.getDefaultValue());
    }

    public Style setPageSide(PageSide pageSide) {
        this.validatePageSide(pageSide);
        if (this.baseStyle == null && Objects.equals(StyleOption.PAGE_SIDE.getDefaultValue(), (Object)pageSide)) {
            this.pageSide = null;
        } else if (this.pageSide == null) {
            this.pageSide = factory.createPageSide(pageSide);
        } else {
            this.pageSide.setValue((Object)pageSide);
        }
        return this;
    }

    private void validatePageSide(PageSide pageSide) {
        if (pageSide == null) {
            throw new NullPointerException("pageSide");
        }
    }

    @Override
    public PageNumberType getBraillePageNumberFormat() {
        if (this.braillePageNumberFormat != null) {
            return (PageNumberType)((Object)this.braillePageNumberFormat.getValue());
        }
        if (this.baseStyle != null) {
            return this.baseStyle.getBraillePageNumberFormat();
        }
        return (PageNumberType)((Object)StyleOption.BRAILLE_PAGE_NUMBER_FORMAT.getDefaultValue());
    }

    public Style setBraillePageNumberFormat(PageNumberType braillePageNumberFormat) {
        this.validateBraillePageNumberFormat(braillePageNumberFormat);
        if (this.baseStyle == null && Objects.equals(StyleOption.BRAILLE_PAGE_NUMBER_FORMAT.getDefaultValue(), (Object)braillePageNumberFormat)) {
            this.braillePageNumberFormat = null;
        } else if (this.braillePageNumberFormat != null) {
            this.braillePageNumberFormat.setValue((Object)braillePageNumberFormat);
        } else {
            this.braillePageNumberFormat = factory.createBraillePageNumberFormat(braillePageNumberFormat);
        }
        return this;
    }

    private void validateBraillePageNumberFormat(PageNumberType braillePageNumberFormat) {
    }

    @Override
    public boolean isDontSplit() {
        if (this.dontSplit != null) {
            return (Boolean)this.dontSplit.getValue();
        }
        if (this.baseStyle != null) {
            return this.baseStyle.isDontSplit();
        }
        return (Boolean)StyleOption.DONT_SPLIT.getDefaultValue();
    }

    public Style setDontSplit(boolean dontSplit) {
        if (this.baseStyle == null && (Boolean)StyleOption.DONT_SPLIT.getDefaultValue() == dontSplit) {
            this.dontSplit = null;
        } else if (this.dontSplit == null) {
            this.dontSplit = factory.createDontSplit(dontSplit);
        } else {
            this.dontSplit.setValue((Object)dontSplit);
        }
        return this;
    }

    @Override
    public boolean isKeepWithNext() {
        if (this.keepWithNext != null) {
            return (Boolean)this.keepWithNext.getValue();
        }
        if (this.baseStyle != null) {
            return this.baseStyle.isKeepWithNext();
        }
        return (Boolean)StyleOption.KEEP_WITH_NEXT.getDefaultValue();
    }

    public Style setKeepWithNext(boolean keepWithNext) {
        if (this.baseStyle == null && (Boolean)StyleOption.KEEP_WITH_NEXT.getDefaultValue() == keepWithNext) {
            this.keepWithNext = null;
        } else if (this.keepWithNext == null) {
            this.keepWithNext = factory.createKeepWithNext(keepWithNext);
        } else {
            this.keepWithNext.setValue((Object)keepWithNext);
        }
        return this;
    }

    @Override
    public boolean isKeepWithPrevious() {
        if (this.keepWithPrevious != null) {
            return (Boolean)this.keepWithPrevious.getValue();
        }
        if (this.baseStyle != null) {
            return this.baseStyle.isKeepWithPrevious();
        }
        return (Boolean)StyleOption.KEEP_WITH_PREVIOUS.getDefaultValue();
    }

    public Style setKeepWithPrevious(boolean keepWithPrevious) {
        if (this.baseStyle == null && (Boolean)StyleOption.KEEP_WITH_PREVIOUS.getDefaultValue() == keepWithPrevious) {
            this.keepWithPrevious = null;
        } else if (this.keepWithPrevious == null) {
            this.keepWithPrevious = factory.createKeepWithPrevious(keepWithPrevious);
        } else {
            this.keepWithPrevious.setValue((Object)keepWithPrevious);
        }
        return this;
    }

    @Override
    public int getOrphanControl() {
        if (this.orphanControl != null) {
            return (Integer)this.orphanControl.getValue();
        }
        if (this.baseStyle != null) {
            return this.baseStyle.getOrphanControl();
        }
        return (Integer)StyleOption.ORPHAN_CONTROL.getDefaultValue();
    }

    public Style setOrphanControl(int orphanControl) {
        this.validateOrphanControl(orphanControl);
        if (this.baseStyle == null && (Integer)StyleOption.ORPHAN_CONTROL.getDefaultValue() == orphanControl) {
            this.orphanControl = null;
        } else if (this.orphanControl == null) {
            this.orphanControl = factory.createOrphanControl(orphanControl);
        } else {
            this.orphanControl.setValue((Object)orphanControl);
        }
        return this;
    }

    private void validateOrphanControl(int orphanControl) {
        if (orphanControl < 1) {
            throw new IllegalArgumentException("orphanControl must be positive, > 2 to take effect, given " + orphanControl);
        }
    }

    @Override
    public int getLineSpacing() {
        if (this.lineSpacing != null) {
            return (Integer)this.lineSpacing.getValue();
        }
        if (this.baseStyle != null) {
            return this.baseStyle.getLineSpacing();
        }
        return (Integer)StyleOption.LINE_SPACING.getDefaultValue();
    }

    public Style setLineSpacing(int lineSpacing) {
        this.validateLineSpacing(lineSpacing);
        if (this.baseStyle == null && (Integer)StyleOption.LINE_SPACING.getDefaultValue() == lineSpacing) {
            this.lineSpacing = null;
        } else if (this.lineSpacing == null) {
            this.lineSpacing = factory.createLineSpacing(lineSpacing);
        } else {
            this.lineSpacing.setValue((Object)lineSpacing);
        }
        return this;
    }

    private void validateLineSpacing(int lineSpacing) {
        if (lineSpacing < 0) {
            throw new IllegalArgumentException("lineSpacing must be positive, given " + lineSpacing);
        }
    }

    @Override
    public String getStartSeparator() {
        if (this.startSeparator != null) {
            return (String)this.startSeparator.getValue();
        }
        if (this.baseStyle != null) {
            return this.baseStyle.getStartSeparator();
        }
        return (String)StyleOption.START_SEPARATOR.getDefaultValue();
    }

    public Style setStartSeparator(String startSeparator) {
        if (this.baseStyle == null && Objects.equals(StyleOption.START_SEPARATOR.getDefaultValue(), startSeparator)) {
            this.startSeparator = null;
        } else if (this.startSeparator == null) {
            this.startSeparator = factory.createStartSeparator(startSeparator);
        } else {
            this.startSeparator.setValue((Object)startSeparator);
        }
        return this;
    }

    @Override
    public String getColor() {
        if (this.color != null) {
            return (String)this.color.getValue();
        }
        if (this.baseStyle != null) {
            return this.baseStyle.getColor();
        }
        return (String)StyleOption.COLOR.getDefaultValue();
    }

    public Style setColor(String color) {
        if (this.baseStyle == null && Objects.equals(StyleOption.COLOR.getDefaultValue(), color)) {
            this.color = null;
        } else if (this.color == null) {
            this.color = factory.createColor(color);
        } else {
            this.color.setValue((Object)color);
        }
        return this;
    }

    @Override
    public String getEndSeparator() {
        if (this.endSeparator != null) {
            return (String)this.endSeparator.getValue();
        }
        if (this.baseStyle != null) {
            return this.baseStyle.getEndSeparator();
        }
        return (String)StyleOption.END_SEPARATOR.getDefaultValue();
    }

    public Style setEndSeparator(String endSeparator) {
        if (this.baseStyle == null && Objects.equals(StyleOption.END_SEPARATOR.getDefaultValue(), endSeparator)) {
            this.endSeparator = null;
        } else if (this.endSeparator == null) {
            this.endSeparator = factory.createEndSeparator(endSeparator);
        } else {
            this.endSeparator.setValue((Object)endSeparator);
        }
        return this;
    }

    public int hashCode() {
        return new HashCodeBuilder(19, 37).append((Object)this.getName()).append((Object)this.getId()).append((Object)this.getAlign()).append((Object)this.getBraillePageNumberFormat()).toHashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        Style rhs = (Style)other;
        return new EqualsBuilder().append((Object)this.getId(), (Object)rhs.getId()).append((Object)this.getName(), (Object)rhs.getName()).append((Object)this.getAlign(), (Object)rhs.getAlign()).append((Object)this.getBraillePageNumberFormat(), (Object)rhs.getBraillePageNumberFormat()).append((Object)this.getFormat(), (Object)rhs.getFormat()).append((Object)this.getIndent(), (Object)rhs.getIndent()).append((Object)this.getFirstLineIndent(), (Object)rhs.getFirstLineIndent()).append((Object)this.getLineLength(), (Object)rhs.getLineLength()).append(this.getOrphanControl(), rhs.getOrphanControl()).append(this.isDontSplit(), rhs.isDontSplit()).append(this.isKeepWithNext(), rhs.isKeepWithNext()).append(this.getLinesAfter(), rhs.getLinesAfter()).append(this.getLinesBefore(), rhs.getLinesBefore()).append(this.getLineSpacing(), rhs.getLineSpacing()).append(this.getNewPagesAfter(), rhs.getNewPagesAfter()).append(this.getNewPagesBefore(), rhs.getNewPagesBefore()).append(this.getSkipPages(), rhs.getSkipPages()).append((Object)this.getEndSeparator(), (Object)rhs.getEndSeparator()).append((Object)this.getStartSeparator(), (Object)rhs.getStartSeparator()).append((Object)this.getPageSide(), (Object)rhs.getPageSide()).append((Object)this.getSkipNumberLines(), (Object)rhs.getSkipNumberLines()).append(this.isGuideWords(), rhs.isGuideWords()).append(this.isKeepWithPrevious(), rhs.isKeepWithPrevious()).append(this.isLineNumber(), rhs.isLineNumber()).append(this.isPageNum(), rhs.isPageNum()).append(this.isTable(), rhs.isTable()).append(this.isTableCell(), rhs.isTableCell()).append(this.isTableRow(), rhs.isTableRow()).append(this.isVolumeEnd(), rhs.isVolumeEnd()).isEquals();
    }

    public String toString() {
        return UTDHelper.autoToString(this, ToStringStyle.MULTI_LINE_STYLE);
    }

    public Style setGuideWords(boolean guideWords) {
        this.validateGuideWords(guideWords);
        if (this.baseStyle == null && (Boolean)StyleOption.GUIDE_WORDS.getDefaultValue() == guideWords) {
            this.guideWords = null;
        } else if (this.guideWords == null) {
            this.guideWords = factory.createGuideWords(guideWords);
        } else {
            this.guideWords.setValue((Object)guideWords);
        }
        return this;
    }

    private void validateGuideWords(boolean guideWords) {
        if (guideWords) {
            this.setSkipNumberLines(NumberLinePosition.BOTTOM);
        }
    }

    @Override
    public boolean isGuideWords() {
        if (this.guideWords != null) {
            return (Boolean)this.guideWords.getValue();
        }
        if (this.baseStyle != null) {
            return this.baseStyle.isGuideWords();
        }
        return (Boolean)StyleOption.GUIDE_WORDS.getDefaultValue();
    }

    @Override
    public boolean isTable() {
        if (this.isTable != null) {
            return (Boolean)this.isTable.getValue();
        }
        if (this.baseStyle != null) {
            return this.baseStyle.isTable();
        }
        return (Boolean)StyleOption.IS_TABLE.getDefaultValue();
    }

    public Style setIsTable(boolean isTable) {
        if (this.baseStyle == null && (Boolean)StyleOption.IS_TABLE.getDefaultValue() == isTable) {
            this.isTable = null;
        } else if (this.isTable == null) {
            this.isTable = factory.createIsTable(isTable);
        } else {
            this.isTable.setValue((Object)isTable);
        }
        return this;
    }

    @Override
    public boolean isTableRow() {
        if (this.isTableRow != null) {
            return (Boolean)this.isTableRow.getValue();
        }
        if (this.baseStyle != null) {
            return this.baseStyle.isTableRow();
        }
        return (Boolean)StyleOption.IS_TABLE_ROW.getDefaultValue();
    }

    public Style setIsTableRow(boolean isTableRow) {
        if (this.baseStyle == null && (Boolean)StyleOption.IS_TABLE_ROW.getDefaultValue() == isTableRow) {
            this.isTableRow = null;
        } else if (this.isTableRow == null) {
            this.isTableRow = factory.createIsTableRow(isTableRow);
        } else {
            this.isTableRow.setValue((Object)isTableRow);
        }
        return this;
    }

    @Override
    public boolean isTableCell() {
        if (this.isTableCell != null) {
            return (Boolean)this.isTableCell.getValue();
        }
        if (this.baseStyle != null) {
            return this.baseStyle.isTableCell();
        }
        return (Boolean)StyleOption.IS_TABLE_CELL.getDefaultValue();
    }

    public Style setIsTableCell(boolean isTableCell) {
        if (this.baseStyle == null && (Boolean)StyleOption.IS_TABLE_CELL.getDefaultValue() == isTableCell) {
            this.isTableCell = null;
        } else if (this.isTableCell == null) {
            this.isTableCell = factory.createIsTableCell(isTableCell);
        } else {
            this.isTableCell.setValue((Object)isTableCell);
        }
        return this;
    }

    @Override
    public boolean isPageNum() {
        if (this.pageNum != null) {
            return (Boolean)this.pageNum.getValue();
        }
        if (this.baseStyle != null) {
            return this.baseStyle.isPageNum();
        }
        return (Boolean)StyleOption.PAGE_NUM.getDefaultValue();
    }

    public Style setPageNum(boolean pageNum) {
        if (this.baseStyle == null && (Boolean)StyleOption.PAGE_NUM.getDefaultValue() == pageNum) {
            this.pageNum = null;
        } else if (this.pageNum == null) {
            this.pageNum = factory.createPageNum(pageNum);
        } else {
            this.pageNum.setValue((Object)pageNum);
        }
        return this;
    }

    @Override
    public boolean isLineNumber() {
        if (this.lineNumber != null) {
            return (Boolean)this.lineNumber.getValue();
        }
        if (this.baseStyle != null) {
            return this.baseStyle.isLineNumber();
        }
        return (Boolean)StyleOption.LINE_NUMBER.getDefaultValue();
    }

    public void setLineNumber(boolean lineNumber) {
        if (this.baseStyle == null && (Boolean)StyleOption.LINE_NUMBER.getDefaultValue() == lineNumber) {
            this.lineNumber = null;
        } else if (this.lineNumber == null) {
            this.lineNumber = factory.createLineNumber(lineNumber);
        } else {
            this.lineNumber.setValue((Object)lineNumber);
        }
    }

    @Override
    public boolean isVolumeEnd() {
        if (this.volumeEnd != null) {
            return (Boolean)this.volumeEnd.getValue();
        }
        if (this.baseStyle != null) {
            return this.baseStyle.isVolumeEnd();
        }
        return (Boolean)StyleOption.VOLUME_END.getDefaultValue();
    }

    public void setVolumeEnd(boolean volumeEnd) {
        if (this.baseStyle == null && (Boolean)StyleOption.VOLUME_END.getDefaultValue() == volumeEnd) {
            this.volumeEnd = null;
        } else if (this.volumeEnd == null) {
            this.volumeEnd = factory.createVolumeEned(volumeEnd);
        } else {
            this.volumeEnd.setValue((Object)volumeEnd);
        }
    }

    private Integer getConditionalValueFromList(List<ConditionalValue<Integer>> conditionalValues, IConditionalValueGetter<IStyle, Integer> getterFunction, Node node, NamespaceMap namespaces, Integer defaultValue) {
        log.debug("Checking {} exceptions in style {}", (Object)conditionalValues.size(), (Object)this.getName());
        for (ConditionalValue<Integer> conditional : conditionalValues) {
            if (!conditional.checkCondition(node, namespaces)) continue;
            return conditional.getValue();
        }
        if (this.baseStyle != null) {
            return getterFunction.get(this.baseStyle, node, namespaces);
        }
        return defaultValue;
    }

    @Override
    public List<ConditionalValue<Integer>> getLinesBeforeWhen() {
        return this.linesBeforeWhen;
    }

    public void setLinesBeforeWhen(List<ConditionalValue<Integer>> restrictions) {
        this.linesBeforeWhen = restrictions;
    }

    @Override
    public Integer getLinesBefore(Node node, NamespaceMap namespaces) {
        return this.getConditionalValueFromList(this.linesBeforeWhen, IStyle::getLinesBefore, node, namespaces, null);
    }

    @Override
    public List<ConditionalValue<Integer>> getLinesAfterWhen() {
        return this.linesAfterWhen;
    }

    public void setLinesAfterWhen(List<ConditionalValue<Integer>> restrictions) {
        this.linesAfterWhen = restrictions;
    }

    @Override
    public Integer getLinesAfter(Node node, NamespaceMap namespaces) {
        return this.getConditionalValueFromList(this.linesAfterWhen, IStyle::getLinesAfter, node, namespaces, null);
    }

    @Nullable
    public Style getBaseStyle() {
        return this.baseStyle;
    }

    public void setBaseStyle(@Nullable Style baseStyle) {
        this.baseStyle = baseStyle;
        this.baseStyleName = baseStyle != null ? baseStyle.getName() : null;
    }

    @Nullable
    public String getBaseStyleName() {
        return this.baseStyleName;
    }

    public void setBaseStyleName(@Nullable String baseStyleName) {
        this.baseStyleName = baseStyleName;
    }

    void afterUnmarshal(Unmarshaller ignoredU, Object parent) {
        this.validateAlign(this.getAlign());
        this.validateBraillePageNumberFormat(this.getBraillePageNumberFormat());
        this.validateFirstLineIndent(this.getFirstLineIndent());
        this.validateFormat(this.getFormat());
        this.validateGuideWords(this.isGuideWords());
        this.validateIndent(this.getIndent());
        this.validateLinesBefore(this.getLinesBefore());
        this.validateLinesAfter(this.getLinesAfter());
        this.validateLineSpacing(this.getLineSpacing());
        this.validateOrphanControl(this.getOrphanControl());
        this.validatePageSide(this.getPageSide());
        this.validateSkipPages(this.getSkipPages());
    }

    @Override
    public List<ConditionalValue<Integer>> getAllLinesBeforeWhen() {
        ArrayList<ConditionalValue<Integer>> result = new ArrayList<ConditionalValue<Integer>>(this.getLinesBeforeWhen());
        if (this.baseStyle != null) {
            result.addAll(this.baseStyle.getAllLinesBeforeWhen());
        }
        return result;
    }

    @Override
    public List<ConditionalValue<Integer>> getAllLinesAfterWhen() {
        ArrayList<ConditionalValue<Integer>> result = new ArrayList<ConditionalValue<Integer>>(this.getLinesAfterWhen());
        if (this.baseStyle != null) {
            result.addAll(this.baseStyle.getAllLinesAfterWhen());
        }
        return result;
    }

    @Override
    public int getLeftPadding() {
        if (this.leftPadding != null) {
            return (Integer)this.leftPadding.getValue();
        }
        if (this.baseStyle != null) {
            return this.baseStyle.getLeftPadding();
        }
        return (Integer)StyleOption.LEFT_PADDING.getDefaultValue();
    }

    public void setLeftPadding(int leftPadding) {
        if (this.baseStyle == null && Objects.equals(StyleOption.LEFT_PADDING.getDefaultValue(), leftPadding)) {
            this.leftPadding = null;
        } else if (this.leftPadding == null) {
            this.leftPadding = factory.createLeftPadding(leftPadding);
        } else {
            this.leftPadding.setValue((Object)leftPadding);
        }
    }

    @Override
    public int getRightPadding() {
        if (this.rightPadding != null) {
            return (Integer)this.rightPadding.getValue();
        }
        if (this.baseStyle != null) {
            return this.baseStyle.getRightPadding();
        }
        return (Integer)StyleOption.RIGHT_PADDING.getDefaultValue();
    }

    public void setRightPadding(int rightPadding) {
        if (this.baseStyle == null && Objects.equals(StyleOption.RIGHT_PADDING.getDefaultValue(), rightPadding)) {
            this.rightPadding = null;
        } else if (this.rightPadding == null) {
            this.rightPadding = factory.createRightPadding(rightPadding);
        } else {
            this.rightPadding.setValue((Object)rightPadding);
        }
    }

    public static enum StyleOption {
        ALIGN("align", (Object)((Object)Align.LEFT)),
        BRAILLE_PAGE_NUMBER_FORMAT("braillePageNumberFormat", null),
        DONT_SPLIT("dontSplit", false),
        END_SEPARATOR("endSeparator", null),
        FIRST_LINE_INDENT("firstLineIndent", null),
        FORMAT("format", (Object)((Object)IStyle.Format.NORMAL)),
        GUIDE_WORDS("guideWords", false),
        INDENT("indent", null),
        LEFT_PADDING("leftPadding", 0),
        LINES_AFTER("linesAfter", 0),
        LINES_BEFORE("linesBefore", 0),
        LINE_LENGTH("lineLength", null),
        LINE_SPACING("lineSpacing", 0),
        NEW_PAGES_AFTER("newPagesAfter", 0),
        NEW_PAGES_BEFORE("newPagesBefore", 0),
        ORPHAN_CONTROL("orphanControl", 1),
        PAGE_SIDE("pageSide", (Object)((Object)PageSide.AUTO)),
        RIGHT_PADDING("rightPadding", 0),
        SKIP_NUMBER_LINES("skipNumberLines", (Object)((Object)NumberLinePosition.NONE)),
        SKIP_PAGES("skipPages", 0),
        START_SEPARATOR("startSeparator", null),
        COLOR("color", null),
        KEEP_WITH_NEXT("keepWithNext", false),
        KEEP_WITH_PREVIOUS("keepWithPrevious", false),
        LINE_NUMBER("lineNumber", false),
        PAGE_NUM("pageNum", false),
        VOLUME_END("volumeEnd", false),
        IS_TABLE("isTable", false),
        IS_TABLE_CELL("isTableCell", false),
        IS_TABLE_ROW("isTableRow", false);

        private final Object defaultValue;
        private final String optionName;

        private StyleOption(String optionName, Object defaultValue) {
            this.optionName = optionName;
            this.defaultValue = defaultValue;
        }

        public Object getDefaultValue() {
            return this.defaultValue;
        }

        public String getOptionName() {
            return this.optionName;
        }
    }
}

