/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.utd;

import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.List;
import kotlin.NotImplementedError;
import nu.xom.Node;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.brailleblaster.utd.ConditionalValue;
import org.brailleblaster.utd.IStyle;
import org.brailleblaster.utd.NamespaceMap;
import org.brailleblaster.utd.Style;
import org.brailleblaster.utd.properties.Align;
import org.brailleblaster.utd.properties.NumberLinePosition;
import org.brailleblaster.utd.properties.PageNumberType;
import org.brailleblaster.utd.properties.PageSide;
import org.jetbrains.annotations.NotNull;

public class StyleStack
extends ArrayDeque<IStyle>
implements IStyle {
    private final Style defaultStyle = new Style();
    private String name;

    public StyleStack(String name) {
        this();
        this.name = name;
    }

    public StyleStack() {
        this.defaultStyle.setIndent(0);
        this.defaultStyle.setLineLength(0);
        this.defaultStyle.setFirstLineIndent(0);
        this.defaultStyle.setAlign(Align.LEFT);
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    private IStyle getInnerMostStyle() {
        IStyle style = (IStyle)this.peek();
        if (style == null) {
            style = this.defaultStyle;
        }
        return style;
    }

    @Override
    @NotNull
    public String getId() {
        return this.getInnerMostStyle().getId();
    }

    @Override
    public int getLinesBefore() {
        return this.getInnerMostStyle().getLinesBefore();
    }

    @Override
    public int getLinesAfter() {
        return this.getInnerMostStyle().getLinesAfter();
    }

    @Override
    public Integer getIndent() {
        Integer value = null;
        Iterator iter = this.iterator();
        while (iter.hasNext() && value == null) {
            value = ((IStyle)iter.next()).getIndent();
        }
        if (value == null) {
            value = this.defaultStyle.getIndent();
        }
        return value;
    }

    @Override
    public Integer getLineLength() {
        Integer value = null;
        Iterator iter = this.iterator();
        while (iter.hasNext() && value == null) {
            value = ((IStyle)iter.next()).getLineLength();
        }
        if (value == null) {
            value = this.defaultStyle.getLineLength();
        }
        return value;
    }

    @Override
    public Integer getFirstLineIndent() {
        Align align = this.getAlign();
        if (align != Align.LEFT && align != null) {
            return this.getIndent();
        }
        Integer value = null;
        Iterator iter = this.iterator();
        while (iter.hasNext() && value == null) {
            value = ((IStyle)iter.next()).getFirstLineIndent();
        }
        if (value == null) {
            value = this.getIndent();
        }
        return value;
    }

    @Override
    public int getNewPagesBefore() {
        return this.getInnerMostStyle().getNewPagesBefore();
    }

    @Override
    public int getNewPagesAfter() {
        return this.getInnerMostStyle().getNewPagesAfter();
    }

    @Override
    public boolean isDontSplit() {
        return this.getInnerMostStyle().isDontSplit();
    }

    @Override
    public boolean isKeepWithNext() {
        return this.getInnerMostStyle().isKeepWithNext();
    }

    @Override
    public boolean isKeepWithPrevious() {
        return this.getInnerMostStyle().isKeepWithPrevious();
    }

    @Override
    public int getOrphanControl() {
        return this.getInnerMostStyle().getOrphanControl();
    }

    @Override
    public NumberLinePosition getSkipNumberLines() {
        NumberLinePosition pos = NumberLinePosition.NONE;
        Iterator iter = this.iterator();
        while (iter.hasNext() && pos == NumberLinePosition.NONE) {
            pos = ((IStyle)iter.next()).getSkipNumberLines();
        }
        if (pos == null) {
            pos = this.defaultStyle.getSkipNumberLines();
        }
        return pos;
    }

    @Override
    public IStyle.Format getFormat() {
        return this.getInnerMostStyle().getFormat();
    }

    @Override
    public int hashCode() {
        int result = 1;
        return result += this.defaultStyle == null ? 0 : this.defaultStyle.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof StyleStack)) {
            return false;
        }
        StyleStack input = (StyleStack)obj;
        Iterator iter = input.iterator();
        if (this.size() != input.size()) {
            return false;
        }
        if (this == input) {
            return true;
        }
        for (IStyle style : this) {
            if (style.equals(iter.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    @Override
    public int getSkipPages() {
        return this.getInnerMostStyle().getSkipPages();
    }

    @Override
    public Align getAlign() {
        Align value = Align.LEFT;
        Iterator iter = this.iterator();
        while (iter.hasNext() && value == Align.LEFT) {
            value = ((IStyle)iter.next()).getAlign();
        }
        return value;
    }

    @Override
    public PageSide getPageSide() {
        return this.getInnerMostStyle().getPageSide();
    }

    @Override
    public PageNumberType getBraillePageNumberFormat() {
        PageNumberType type = PageNumberType.NORMAL;
        Iterator iter = this.iterator();
        while (iter.hasNext() && type == PageNumberType.NORMAL) {
            type = ((IStyle)iter.next()).getBraillePageNumberFormat();
        }
        if (type == null) {
            type = this.defaultStyle.getBraillePageNumberFormat();
        }
        return type;
    }

    @Override
    public int getLineSpacing() {
        int result = 0;
        Iterator it = this.iterator();
        while (result == 0 && it.hasNext()) {
            IStyle style = (IStyle)it.next();
            result = style.getLineSpacing();
        }
        return result == 0 ? 1 : result;
    }

    @Override
    public boolean isTable() {
        return this.getInnerMostStyle().isTable();
    }

    @Override
    public boolean isTableRow() {
        return this.getInnerMostStyle().isTableRow();
    }

    @Override
    public boolean isTableCell() {
        return this.getInnerMostStyle().isTable();
    }

    @Override
    public String getEndSeparator() {
        return this.getInnerMostStyle().getEndSeparator();
    }

    @Override
    public String getStartSeparator() {
        return this.getInnerMostStyle().getStartSeparator();
    }

    @Override
    public String getColor() {
        return this.getInnerMostStyle().getColor();
    }

    @Override
    public boolean isGuideWords() {
        for (IStyle style : this) {
            if (!style.isGuideWords()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isPageNum() {
        return this.getInnerMostStyle().isPageNum();
    }

    @Override
    public boolean isLineNumber() {
        return this.getInnerMostStyle().isLineNumber();
    }

    @Override
    public boolean isVolumeEnd() {
        return this.getInnerMostStyle().isVolumeEnd();
    }

    @Override
    public List<ConditionalValue<Integer>> getLinesBeforeWhen() {
        if (!this.isEmpty()) {
            return ((IStyle)this.getFirst()).getLinesBeforeWhen();
        }
        return this.defaultStyle.getLinesBeforeWhen();
    }

    @Override
    public List<ConditionalValue<Integer>> getLinesAfterWhen() {
        if (!this.isEmpty()) {
            return ((IStyle)this.getFirst()).getLinesAfterWhen();
        }
        return this.defaultStyle.getLinesAfterWhen();
    }

    @Override
    public Integer getLinesAfter(Node node, NamespaceMap namespaces) {
        if (!this.isEmpty()) {
            return ((IStyle)this.getFirst()).getLinesAfter(node, namespaces);
        }
        return this.defaultStyle.getLinesAfter(node, namespaces);
    }

    @Override
    public Integer getLinesBefore(Node node, NamespaceMap namespaces) {
        if (!this.isEmpty()) {
            return ((IStyle)this.getFirst()).getLinesBefore(node, namespaces);
        }
        return this.defaultStyle.getLinesBefore(node, namespaces);
    }

    @Override
    @NotNull
    public IStyle copy(@NotNull String id, @NotNull String name) {
        throw new NotImplementedError("StyleStacks currently cannot be copied.");
    }

    @Override
    public List<ConditionalValue<Integer>> getAllLinesBeforeWhen() {
        if (!this.isEmpty()) {
            return ((IStyle)this.getFirst()).getAllLinesBeforeWhen();
        }
        return this.defaultStyle.getAllLinesBeforeWhen();
    }

    @Override
    public List<ConditionalValue<Integer>> getAllLinesAfterWhen() {
        if (!this.isEmpty()) {
            return ((IStyle)this.getFirst()).getAllLinesAfterWhen();
        }
        return this.defaultStyle.getAllLinesAfterWhen();
    }

    @Override
    public int getLeftPadding() {
        if (!this.isEmpty()) {
            return ((IStyle)this.getFirst()).getLeftPadding();
        }
        return this.defaultStyle.getLeftPadding();
    }

    @Override
    public int getRightPadding() {
        if (!this.isEmpty()) {
            return ((IStyle)this.getFirst()).getRightPadding();
        }
        return this.defaultStyle.getRightPadding();
    }
}

