/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.utd.asciimath;

import com.oracle.truffle.js.scriptengine.GraalJSScriptEngine;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Stack;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.script.Invocable;
import javax.script.ScriptException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import nu.xom.Attribute;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Node;
import nu.xom.Nodes;
import nu.xom.ParsingException;
import nu.xom.Text;
import nu.xom.converters.DOMConverter;
import nu.xom.xslt.XSLException;
import nu.xom.xslt.XSLTransform;
import org.brailleblaster.utd.UTDTranslationEngine;
import org.brailleblaster.utd.asciimath.AbstractNodeIterator;
import org.brailleblaster.utd.asciimath.ChildNodeIterator;
import org.brailleblaster.utd.asciimath.JSNavigator;
import org.brailleblaster.utd.asciimath.JSWindow;
import org.brailleblaster.utd.asciimath.MathTextFinder;
import org.brailleblaster.utd.asciimath.NodesIterator;
import org.brailleblaster.utd.properties.UTDElements;
import org.brailleblaster.utils.xom.NodeUtilsKt;
import org.graalvm.polyglot.Context;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002:\u00019B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rJ\u0018\u0010\u000e\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0006H\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0016\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u001e\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cJ/\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0012\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u00020 0\u001f\"\u00020 \u00a2\u0006\u0002\u0010!J7\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0012\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u00020 0\u001f\"\u00020 \u00a2\u0006\u0002\u0010\"J\u0018\u0010#\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002J\u0018\u0010%\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020\u001aH\u0002J\u0018\u0010(\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*H\u0002J$\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\n2\u0006\u0010.\u001a\u00020*2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020-00H\u0002J.\u00101\u001a\u00020\u001a2\b\u00102\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u00103\u001a\u00020\u001c2\b\b\u0002\u00104\u001a\u00020\u001cH\u0007J\u000e\u00105\u001a\u0002062\u0006\u00102\u001a\u00020\u0006J\u0010\u00107\u001a\u00020\u00062\b\u00108\u001a\u0004\u0018\u00010\u0006R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lorg/brailleblaster/utd/asciimath/AsciiMathConverter;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "<init>", "()V", "ASCII_MATH_XSLT_PATH", "", "ASCII_MATH_PARSER_JS", "MATHML_NS", "MATHML_ATTRS_LIST", "", "getBrailleText", "node", "Lnu/xom/Node;", "getBrailleTextFromNode", "s", "jsEngine", "Lcom/oracle/truffle/js/scriptengine/GraalJSScriptEngine;", "close", "", "transformer", "Lnu/xom/xslt/XSLTransform;", "amParser", "Lorg/brailleblaster/utd/asciimath/AsciiMathConverter$ASCIIMathParser;", "toAsciiMath", "mathml", "Lnu/xom/Nodes;", "bbSpaces", "", "includeMathMarkers", "finders", "", "Lorg/brailleblaster/utd/asciimath/MathTextFinder;", "(Lnu/xom/Nodes;Z[Lorg/brailleblaster/utd/asciimath/MathTextFinder;)Ljava/lang/String;", "(Lnu/xom/Nodes;ZZ[Lorg/brailleblaster/utd/asciimath/MathTextFinder;)Ljava/lang/String;", "transformFromMathML", "n", "compareMathML", "m1", "m2", "compareMathMLElement", "e1", "Lnu/xom/Element;", "e2", "filterAttributes", "Lnu/xom/Attribute;", "elem", "p", "Ljava/util/function/Predicate;", "toMathML", "asciiMath", "addAltText", "stripMathMarkers", "toMathMLHTMLNodes", "Lorg/w3c/dom/Element;", "asciiToBraille", "ascii", "ASCIIMathParser", "utd"})
@SourceDebugExtension(value={"SMAP\nAsciiMathConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AsciiMathConverter.kt\norg/brailleblaster/utd/asciimath/AsciiMathConverter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Strings.kt\nkotlin/text/StringsKt__StringsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,416:1\n812#2,12:417\n296#2,2:491\n106#3:429\n78#3,22:430\n106#3:454\n78#3,22:455\n37#4,2:452\n12033#5,10:477\n14060#5:487\n14061#5:489\n12043#5:490\n1#6:488\n*S KotlinDebug\n*F\n+ 1 AsciiMathConverter.kt\norg/brailleblaster/utd/asciimath/AsciiMathConverter\n*L\n144#1:417,12\n204#1:491,2\n368#1:429\n368#1:430,22\n401#1:454\n401#1:455,22\n371#1:452,2\n203#1:477,10\n203#1:487\n203#1:489\n203#1:490\n203#1:488\n*E\n"})
public final class AsciiMathConverter
implements AutoCloseable {
    @NotNull
    public static final AsciiMathConverter INSTANCE;
    @NotNull
    private static final String ASCII_MATH_XSLT_PATH = "/org/brailleblaster/utd/xslt/MathML2AsciiMath.xsl";
    @NotNull
    private static final String ASCII_MATH_PARSER_JS = "/org/brailleblaster/utd/js/ASCIIMathML.js";
    @NotNull
    private static final String MATHML_NS = "http://www.w3.org/1998/Math/MathML";
    @NotNull
    private static final List<String> MATHML_ATTRS_LIST;
    @NotNull
    private static final GraalJSScriptEngine jsEngine;
    @NotNull
    private static XSLTransform transformer;
    @NotNull
    private static final ASCIIMathParser amParser;

    private AsciiMathConverter() {
    }

    @NotNull
    public final String getBrailleText(@NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return this.getBrailleTextFromNode(node, "");
    }

    /*
     * WARNING - void declaration
     */
    private final String getBrailleTextFromNode(Node node, String s) {
        StringBuilder str = new StringBuilder(s);
        for (Node childNode : NodeUtilsKt.getChildNodes((Node)node)) {
            if (UTDElements.BRL.isA(childNode)) {
                void $this$filterIsInstanceTo$iv$iv;
                void $this$filterIsInstance$iv;
                Iterable iterable = NodeUtilsKt.getChildNodes((Node)childNode);
                StringBuilder stringBuilder = str;
                boolean $i$f$filterIsInstance = false;
                void var8_8 = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof Text)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                stringBuilder.append(CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, AsciiMathConverter::getBrailleTextFromNode$lambda$0, (int)30, null));
            }
            String string = str.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            str = new StringBuilder(this.getBrailleTextFromNode(childNode, string));
        }
        String string = str.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    public void close() {
        jsEngine.close();
    }

    @NotNull
    public final String toAsciiMath(@NotNull Nodes mathml, boolean bbSpaces) {
        Intrinsics.checkNotNullParameter((Object)mathml, (String)"mathml");
        MathTextFinder[] mathTextFinderArray = new MathTextFinder[]{MathTextFinder.NONE};
        return this.toAsciiMath(mathml, bbSpaces, mathTextFinderArray);
    }

    @NotNull
    public final String toAsciiMath(@NotNull Nodes mathml, boolean bbSpaces, boolean includeMathMarkers) {
        Intrinsics.checkNotNullParameter((Object)mathml, (String)"mathml");
        MathTextFinder[] mathTextFinderArray = new MathTextFinder[]{MathTextFinder.NONE};
        return this.toAsciiMath(mathml, bbSpaces, includeMathMarkers, mathTextFinderArray);
    }

    @NotNull
    public final String toAsciiMath(@NotNull Nodes mathml, boolean bbSpaces, MathTextFinder ... finders) {
        Intrinsics.checkNotNullParameter((Object)mathml, (String)"mathml");
        Intrinsics.checkNotNullParameter((Object)finders, (String)"finders");
        return this.toAsciiMath(mathml, bbSpaces, false, Arrays.copyOf(finders, finders.length));
    }

    @NotNull
    public final String toAsciiMath(@NotNull Nodes mathml, boolean bbSpaces, boolean includeMathMarkers, MathTextFinder ... finders) {
        Intrinsics.checkNotNullParameter((Object)mathml, (String)"mathml");
        Intrinsics.checkNotNullParameter((Object)finders, (String)"finders");
        String resultText = CollectionsKt.joinToString$default((Iterable)((Iterable)mathml), (CharSequence)"", null, null, (int)0, null, arg_0 -> AsciiMathConverter.toAsciiMath$lambda$0(finders, includeMathMarkers, arg_0), (int)30, null);
        if (bbSpaces) {
            CharSequence charSequence = resultText;
            Regex regex = new Regex("\\\\ ");
            int n = 0;
            return CollectionsKt.joinToString$default((Iterable)regex.split(charSequence, n), (CharSequence)" ", null, null, (int)0, null, AsciiMathConverter::toAsciiMath$lambda$1, (int)30, null);
        }
        return resultText;
    }

    private final String transformFromMathML(Node n, boolean includeMathMarkers) {
        Nodes resultNodes = null;
        StringBuilder resultString = new StringBuilder();
        String mathMarker = includeMathMarkers ? "`" : "";
        transformer.setParameter("beginMathSymbol", (Object)mathMarker);
        transformer.setParameter("endMathSymbol", (Object)mathMarker);
        try {
            Nodes nodes = transformer.transform(new Nodes(n));
            Intrinsics.checkNotNullExpressionValue((Object)nodes, (String)"transform(...)");
            resultNodes = nodes;
        }
        catch (XSLException e) {
            throw new RuntimeException("Problem transforming document", e);
        }
        int n2 = resultNodes.size();
        for (int i = 0; i < n2; ++i) {
            Node r = resultNodes.get(i);
            if (!(r instanceof Text)) {
                throw new RuntimeException("The result from transforming is not pure ASCIIMath");
            }
            resultString.append(((Text)r).getValue());
        }
        String string = resultString.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final boolean compareMathML(Nodes m1, Nodes m2) {
        Stack<AbstractNodeIterator> nodePath1 = new Stack<AbstractNodeIterator>();
        Stack<AbstractNodeIterator> nodePath2 = new Stack<AbstractNodeIterator>();
        nodePath1.push(new NodesIterator(m1, AsciiMathConverter::compareMathML$lambda$0));
        nodePath2.push(new NodesIterator(m2, AsciiMathConverter::compareMathML$lambda$1));
        while (!nodePath1.isEmpty() && !nodePath2.isEmpty()) {
            AbstractNodeIterator i1 = (AbstractNodeIterator)nodePath1.peek();
            AbstractNodeIterator i2 = (AbstractNodeIterator)nodePath2.peek();
            if (!i1.hasNext() && !i2.hasNext()) {
                nodePath1.pop();
                nodePath2.pop();
                continue;
            }
            if (i1.hasNext() != i2.hasNext()) {
                return false;
            }
            Node n1 = i1.next();
            Node n2 = i2.next();
            if (n1 instanceof nu.xom.Element && n2 instanceof nu.xom.Element) {
                boolean matches = this.compareMathMLElement((nu.xom.Element)n1, (nu.xom.Element)n2);
                if (!matches) {
                    return false;
                }
                nodePath1.push(new ChildNodeIterator(n1, AsciiMathConverter::compareMathML$lambda$2));
                nodePath2.push(new ChildNodeIterator(n2, AsciiMathConverter::compareMathML$lambda$3));
                continue;
            }
            if (n1 instanceof Text && n2 instanceof Text) {
                if (Intrinsics.areEqual((Object)((Text)n1).getValue(), (Object)((Text)n2).getValue())) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private final boolean compareMathMLElement(nu.xom.Element e1, nu.xom.Element e2) {
        if (!(Intrinsics.areEqual((Object)e1.getLocalName(), (Object)e2.getLocalName()) && Intrinsics.areEqual((Object)MATHML_NS, (Object)e1.getNamespaceURI()) && Intrinsics.areEqual((Object)MATHML_NS, (Object)e2.getNamespaceURI()))) {
            return false;
        }
        List<Attribute> attrs1 = this.filterAttributes(e1, AsciiMathConverter::compareMathMLElement$lambda$0);
        List<Attribute> attrs2 = this.filterAttributes(e2, AsciiMathConverter::compareMathMLElement$lambda$1);
        if (attrs1.size() != attrs2.size()) {
            return false;
        }
        int n = ((Collection)attrs1).size();
        for (int i = 0; i < n; ++i) {
            Attribute a1 = attrs1.get(i);
            Attribute a2 = attrs2.get(i);
            if (!Intrinsics.areEqual((Object)a1.getLocalName(), (Object)a2.getLocalName())) {
                return false;
            }
            if (Intrinsics.areEqual((Object)a1.getValue(), (Object)a2.getValue())) continue;
            return false;
        }
        return true;
    }

    private final List<Attribute> filterAttributes(nu.xom.Element elem, Predicate<Attribute> p) {
        List<Attribute> list = IntStream.range(0, elem.getAttributeCount()).mapToObj(arg_0 -> AsciiMathConverter.filterAttributes$lambda$0(elem, arg_0)).filter(p).sorted(Comparator.comparing(arg_0 -> AsciiMathConverter.filterAttributes$lambda$2(AsciiMathConverter::filterAttributes$lambda$1, arg_0))).collect(Collectors.toList());
        Intrinsics.checkNotNullExpressionValue(list, (String)"collect(...)");
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public final Nodes toMathML(@Nullable String asciiMath, boolean bbSpaces, boolean addAltText, boolean stripMathMarkers) {
        String string = asciiMath;
        Intrinsics.checkNotNull((Object)string);
        String $this$trim$iv = string;
        boolean $i$f$trim3 = false;
        Object $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim22 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        String amStr = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
        Object altTextStr = amStr;
        if (bbSpaces) {
            void $this$toTypedArray$iv;
            $this$trim$iv$iv = amStr;
            Regex $i$f$trim22 = new Regex("\\\\ ");
            startIndex$iv$iv = 0;
            $this$trim$iv$iv = $i$f$trim22.split((CharSequence)$this$trim$iv$iv, startIndex$iv$iv);
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            String $i$f$trim3 = Arrays.stream(thisCollection$iv.toArray(new String[0])).map(arg_0 -> AsciiMathConverter.toMathML$lambda$2(AsciiMathConverter::toMathML$lambda$1, arg_0)).collect(Collectors.joining(" "));
            Intrinsics.checkNotNullExpressionValue((Object)$i$f$trim3, (String)"collect(...)");
            amStr = $i$f$trim3;
        }
        if (stripMathMarkers) {
            if (StringsKt.startsWith$default((String)amStr, (String)"`", (boolean)false, (int)2, null)) {
                amStr = StringsKt.take((String)amStr, (int)1);
            } else {
                altTextStr = "`" + (String)altTextStr;
            }
            if (StringsKt.endsWith$default((String)amStr, (String)"`", (boolean)false, (int)2, null)) {
                amStr = StringsKt.dropLast((String)amStr, (int)1);
            } else {
                altTextStr = (String)altTextStr + "`";
            }
        }
        Element n = amParser.parseMath(amStr, false);
        nu.xom.Element e = DOMConverter.convert((Element)n);
        if (addAltText) {
            e.addAttribute(new Attribute("alttext", (String)altTextStr));
        }
        return new Nodes((Node)e);
    }

    public static /* synthetic */ Nodes toMathML$default(AsciiMathConverter asciiMathConverter, String string, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 4) != 0) {
            bl2 = true;
        }
        if ((n & 8) != 0) {
            bl3 = false;
        }
        return asciiMathConverter.toMathML(string, bl, bl2, bl3);
    }

    @NotNull
    public final Element toMathMLHTMLNodes(@NotNull String asciiMath) {
        Intrinsics.checkNotNullParameter((Object)asciiMath, (String)"asciiMath");
        String $this$trim$iv = asciiMath;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        String amStr = StringsKt.removeSurrounding((String)((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString(), (CharSequence)"`", (CharSequence)"`");
        return amParser.parseMath(amStr, false);
    }

    @NotNull
    public final String asciiToBraille(@Nullable String ascii) {
        Nodes nodes = AsciiMathConverter.toMathML$default(this, ascii, true, false, false, 12, null);
        UTDTranslationEngine engine = new UTDTranslationEngine();
        engine.getBrailleSettings().setUseAsciiBraille(true);
        Node node = nodes.get(0);
        Intrinsics.checkNotNullExpressionValue((Object)node, (String)"get(...)");
        Nodes translated = engine.translate(node);
        Node node2 = translated.get(0);
        Intrinsics.checkNotNullExpressionValue((Object)node2, (String)"get(...)");
        return this.getBrailleText(node2);
    }

    @JvmOverloads
    @NotNull
    public final Nodes toMathML(@Nullable String asciiMath, boolean bbSpaces, boolean addAltText) {
        return AsciiMathConverter.toMathML$default(this, asciiMath, bbSpaces, addAltText, false, 8, null);
    }

    @JvmOverloads
    @NotNull
    public final Nodes toMathML(@Nullable String asciiMath, boolean bbSpaces) {
        return AsciiMathConverter.toMathML$default(this, asciiMath, bbSpaces, false, false, 12, null);
    }

    private static final CharSequence getBrailleTextFromNode$lambda$0(Text it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private static final CharSequence toAsciiMath$lambda$0(MathTextFinder[] $finders, boolean $includeMathMarkers, Node n) {
        CharSequence charSequence;
        Object v0;
        block4: {
            void $this$mapNotNullTo$iv$iv;
            MathTextFinder[] $this$mapNotNull$iv = $finders;
            boolean $i$f$mapNotNull = false;
            MathTextFinder[] mathTextFinderArray = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            int n2 = ((void)$this$forEach$iv$iv$iv).length;
            for (int i = 0; i < n2; ++i) {
                String it$iv$iv;
                void element$iv$iv$iv;
                void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                boolean bl = false;
                void it = element$iv$iv;
                boolean bl2 = false;
                if (it.findText(n) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable $this$firstOrNull$iv = (List)destination$iv$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                if (!INSTANCE.compareMathML(new Nodes(n), AsciiMathConverter.toMathML$default(INSTANCE, it, false, false, false, 12, null))) continue;
                v0 = element$iv;
                break block4;
            }
            v0 = null;
        }
        String string = v0;
        if (string != null) {
            charSequence = string;
        } else {
            Intrinsics.checkNotNull((Object)n);
            charSequence = INSTANCE.transformFromMathML(n, $includeMathMarkers);
        }
        return charSequence;
    }

    private static final CharSequence toAsciiMath$lambda$1(String sub) {
        Intrinsics.checkNotNullParameter((Object)sub, (String)"sub");
        return StringsKt.replace$default((String)sub, (String)" ", (String)"\\ ", (boolean)false, (int)4, null);
    }

    private static final boolean compareMathML$lambda$0(Node it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof nu.xom.Element || it instanceof Text;
    }

    private static final boolean compareMathML$lambda$1(Node it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof nu.xom.Element || it instanceof Text;
    }

    private static final boolean compareMathML$lambda$2(Node it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof nu.xom.Element || it instanceof Text;
    }

    private static final boolean compareMathML$lambda$3(Node it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof nu.xom.Element || it instanceof Text;
    }

    private static final boolean compareMathMLElement$lambda$0(Attribute a) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        return Intrinsics.areEqual((Object)"", (Object)a.getNamespaceURI()) && MATHML_ATTRS_LIST.contains(a.getLocalName());
    }

    private static final boolean compareMathMLElement$lambda$1(Attribute a) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        return Intrinsics.areEqual((Object)"", (Object)a.getNamespaceURI()) && MATHML_ATTRS_LIST.contains(a.getLocalName());
    }

    private static final Attribute filterAttributes$lambda$0(nu.xom.Element $elem, int i) {
        return $elem.getAttribute(i);
    }

    private static final String filterAttributes$lambda$1(Attribute obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        return obj.getLocalName();
    }

    private static final String filterAttributes$lambda$2(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final String toMathML$lambda$1(String sub) {
        Intrinsics.checkNotNullParameter((Object)sub, (String)"sub");
        return StringsKt.replace$default((String)sub, (String)" ", (String)"\\ ", (boolean)false, (int)4, null);
    }

    private static final String toMathML$lambda$2(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        InputStream in;
        Object object;
        org.w3c.dom.Document document;
        INSTANCE = new AsciiMathConverter();
        Object[] objectArray = new String[]{"accent", "accentunder", "actiontype", "align", "alignmentscope", "bevelled", "charalign", "close", "columnalign", "columnlines", "columnspacing", "columnspan", "columnwidth", "crossout", "decimalpoint", "denomalign", "depth", "dir", "display", "displaystyle", "edge", "equalcolumns", "equalrows", "fence", "form", "frame", "framespacing", "groupalign", "height", "href", "id", "indentalign", "indentalignfirst", "indentalignlast", "indentshift", "indentshiftfirst", "indentshiftlast", "indenttarget", "infixlinebreakstyle", "largeop", "length", "linebreak", "linebreakmultchar", "linebreakstyle", "lineleading", "linethickness", "location", "longdivstyle", "lspace", "lquote", "mathbackground", "mathcolor", "mathsize", "mathvariant", "maxsize", "minlabelspacing", "minsize", "movablelimits", "notation", "numalign", "open", "overflow", "position", "rowalign", "rowlines", "rowspacing", "rowspan", "rspace", "rquote", "scriptlevel", "scriptminsize", "scriptsizemultiplier", "selection", "separator", "separators", "shift", "side", "src", "stackalign", "stretchy", "subscriptshift", "supscriptshift", "symmetric", "voffset", "width"};
        MATHML_ATTRS_LIST = CollectionsKt.listOf((Object[])objectArray);
        JSNavigator navigator = new JSNavigator("BrailleBlaster UTD");
        JSWindow window = new JSWindow();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            document = db.parse(new InputSource(new StringReader("<html><head/><body/></html>")));
            Intrinsics.checkNotNull((Object)document);
        }
        catch (ParserConfigurationException e1) {
            throw new RuntimeException("Problem creating the DOM for the JavaScript library", e1);
        }
        catch (SAXException e1) {
            throw new RuntimeException("Problem creating the DOM for the JavaScript library", e1);
        }
        catch (IOException e1) {
            throw new RuntimeException("Problem creating the DOM for the JavaScript library", e1);
        }
        org.w3c.dom.Document jsDoc = document;
        Builder builder = new Builder();
        try {
            Closeable e1 = INSTANCE.getClass().getResourceAsStream(ASCII_MATH_XSLT_PATH);
            object = null;
            try {
                in = (InputStream)e1;
                boolean bl = false;
                Document stylesheet = builder.build(in);
                transformer = new XSLTransform(stylesheet);
                in = Unit.INSTANCE;
            }
            catch (Throwable bl) {
                object = bl;
                throw bl;
            }
            finally {
                CloseableKt.closeFinally((Closeable)e1, (Throwable)object);
            }
        }
        catch (XSLException e) {
            throw new RuntimeException("Problem creating the ASCIIMath XSL transformer", e);
        }
        catch (ParsingException e) {
            throw new RuntimeException("Problem parsing the ASCIIMath XSL", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Problem accessing the ASCIIMath XSL", e);
        }
        object = new String[]{"js"};
        GraalJSScriptEngine graalJSScriptEngine = GraalJSScriptEngine.create(null, (Context.Builder)Context.newBuilder((String[])object).allowAllAccess(true).allowExperimentalOptions(true).option("js.nashorn-compat", "true"));
        Intrinsics.checkNotNullExpressionValue((Object)graalJSScriptEngine, (String)"create(...)");
        jsEngine = graalJSScriptEngine;
        jsEngine.put("navigator", (Object)navigator);
        jsEngine.put("document", (Object)jsDoc);
        jsEngine.put("window", (Object)window);
        try {
            InputStream inputStream = INSTANCE.getClass().getResourceAsStream(ASCII_MATH_PARSER_JS);
            if (inputStream == null) {
                object = "Required value was null.";
                throw new IllegalArgumentException(object.toString());
            }
            Closeable e = inputStream;
            object = null;
            try {
                in = (InputStream)e;
                boolean bl = false;
                Object object2 = jsEngine.eval((Reader)new InputStreamReader(in, StandardCharsets.UTF_8));
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)e, (Throwable)object);
            }
        }
        catch (ScriptException e) {
            throw new RuntimeException("Problem running the ASCIIMath parser javascript", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Problem reading the ASCIIMath parser javascript", e);
        }
        Runnable runnable = window.onload;
        if (runnable != null) {
            runnable.run();
        }
        Object o = jsEngine.get("asciimath");
        GraalJSScriptEngine graalJSScriptEngine2 = jsEngine;
        Intrinsics.checkNotNull((Object)graalJSScriptEngine2, (String)"null cannot be cast to non-null type javax.script.Invocable");
        ASCIIMathParser aSCIIMathParser = ((Invocable)graalJSScriptEngine2).getInterface(o, ASCIIMathParser.class);
        Intrinsics.checkNotNullExpressionValue((Object)aSCIIMathParser, (String)"getInterface(...)");
        amParser = aSCIIMathParser;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\bf\u0018\u00002\u00020\u0001J\u001a\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lorg/brailleblaster/utd/asciimath/AsciiMathConverter$ASCIIMathParser;", "", "parseMath", "Lorg/w3c/dom/Element;", "math", "", "latex", "", "utd"})
    public static interface ASCIIMathParser {
        @NotNull
        public Element parseMath(@Nullable String var1, boolean var2);
    }
}

