/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.utd.config;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.brailleblaster.utd.Shortcut;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\nJ\u0010\u0010\u0007\u001a\u00020\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0006J\u0016\u0010\u0007\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJ\u0010\u0010\u000f\u001a\u00020\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0006J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00062\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000e\u001a\u00020\rJ\n\u0010\u0016\u001a\u00020\u0017H\u0096\u0080\u0004J\u0014\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u0096\u0082\u0004J\n\u0010\u001b\u001a\u00020\rH\u0096\u0080\u0004R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001c"}, d2={"Lorg/brailleblaster/utd/config/ShortcutDefinitions;", "", "<init>", "()V", "_shortcuts", "", "Lorg/brailleblaster/utd/Shortcut;", "addShortcut", "", "shortcutInput", "", "shortcut", "id", "", "keyCombination", "removeShortcut", "shortcuts", "", "getShortcuts", "()Ljava/util/List;", "getShortcutById", "getShortcutByKeyCombination", "hashCode", "", "equals", "", "other", "toString", "utd"})
@SourceDebugExtension(value={"SMAP\nShortcutDefinitions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShortcutDefinitions.kt\norg/brailleblaster/utd/config/ShortcutDefinitions\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,90:1\n296#2,2:91\n296#2,2:93\n*S KotlinDebug\n*F\n+ 1 ShortcutDefinitions.kt\norg/brailleblaster/utd/config/ShortcutDefinitions\n*L\n68#1:91,2\n76#1:93,2\n*E\n"})
public final class ShortcutDefinitions {
    @NotNull
    private final List<Shortcut> _shortcuts = new ArrayList();

    public final void addShortcut(@NotNull Iterable<Shortcut> shortcutInput) {
        Intrinsics.checkNotNullParameter(shortcutInput, (String)"shortcutInput");
        for (Shortcut curShortcut : shortcutInput) {
            this.addShortcut(curShortcut);
        }
    }

    public final void addShortcut(@Nullable Shortcut shortcut) {
        if (shortcut == null) {
            throw new NullPointerException("shortcut");
        }
        if (StringsKt.isBlank((CharSequence)shortcut.getId())) {
            throw new RuntimeException("Shortcut " + shortcut + " cannot have a blank id");
        }
        Shortcut existingShortcut = this.getShortcutById(shortcut.getId());
        if (existingShortcut != null) {
            throw new RuntimeException("Shortcut " + shortcut + " is a duplicate of existing shortcut " + existingShortcut);
        }
        this._shortcuts.add(shortcut);
    }

    @NotNull
    public final Shortcut addShortcut(@NotNull String id, @NotNull String keyCombination) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)keyCombination, (String)"keyCombination");
        if (StringsKt.isBlank((CharSequence)id)) {
            throw new RuntimeException("Shortcut id cannot be blank.");
        }
        if (StringsKt.isBlank((CharSequence)keyCombination)) {
            throw new RuntimeException("Key combination cannot be blank.");
        }
        Shortcut existingShortcut = this.getShortcutById(id);
        if (existingShortcut != null) {
            throw new RuntimeException("Shortcut " + id + " is a duplicate of existing shortcut " + existingShortcut);
        }
        Shortcut newShortcut = new Shortcut(id, keyCombination);
        this._shortcuts.add(newShortcut);
        return newShortcut;
    }

    public final void removeShortcut(@Nullable Shortcut shortcut) {
        if (shortcut == null) {
            throw new NullPointerException("shortcut");
        }
        if (!this._shortcuts.contains(shortcut)) {
            throw new RuntimeException("Shortcut " + shortcut + " is not contained in definitions!");
        }
        this._shortcuts.remove(shortcut);
    }

    @NotNull
    public final List<Shortcut> getShortcuts() {
        return CollectionsKt.toList((Iterable)this._shortcuts);
    }

    @Nullable
    public final Shortcut getShortcutById(@NotNull String id) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Iterable $this$firstOrNull$iv = this._shortcuts;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Shortcut it = (Shortcut)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)id)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Nullable
    public final Shortcut getShortcutByKeyCombination(@NotNull String keyCombination) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)keyCombination, (String)"keyCombination");
            Iterable $this$firstOrNull$iv = this._shortcuts;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Shortcut it = (Shortcut)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getKeyCombination(), (Object)keyCombination)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public boolean equals(@Nullable Object other) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)other, (String[])new String[0]);
    }

    @NotNull
    public String toString() {
        String string = ToStringBuilder.reflectionToString((Object)this);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"reflectionToString(...)");
        return string;
    }
}

