/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.utd.config;

import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.annotation.XmlAccessOrder;
import jakarta.xml.bind.annotation.XmlAccessorOrder;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.brailleblaster.utd.Style;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement
@XmlAccessorOrder(value=XmlAccessOrder.ALPHABETICAL)
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 .2\u00020\u0001:\u0001.B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0010\u001a\u00020\u00112\u000e\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u0013J\u0010\u0010\u0014\u001a\u00020\u00112\b\u0010\u0015\u001a\u0004\u0018\u00010\u000fJ\u0010\u0010\u0016\u001a\u00020\u00112\b\u0010\u0015\u001a\u0004\u0018\u00010\u000fJ\u0006\u0010\u0017\u001a\u00020\u0011J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u000f2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eJ\u000e\u0010\"\u001a\u00020\u00112\u0006\u0010#\u001a\u00020\u0000J\n\u0010$\u001a\u00020\u0007H\u0096\u0080\u0004J\u0014\u0010%\u001a\u00020\u00052\b\u0010#\u001a\u0004\u0018\u00010\u0001H\u0096\u0082\u0004J\n\u0010&\u001a\u00020\u001eH\u0096\u0080\u0004J\u001a\u0010'\u001a\u00020\u00112\b\u0010(\u001a\u0004\u0018\u00010)2\b\u0010*\u001a\u0004\u0018\u00010\u0001J\u0010\u0010+\u001a\u00020\u00112\b\u0010,\u001a\u0004\u0018\u00010-R\u0012\u0010\u0004\u001a\u00020\u00058\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@CX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0013\u0010\u001f\u001a\u0004\u0018\u00010\u000f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u00a8\u0006/"}, d2={"Lorg/brailleblaster/utd/config/StyleDefinitions;", "", "<init>", "()V", "versionSet", "", "value", "", "version", "getVersion", "()I", "setVersion", "(I)V", "_styles", "", "Lorg/brailleblaster/utd/Style;", "addStyles", "", "stylesInput", "", "addStyle", "style", "removeStyle", "clear", "styles", "", "getStyles", "()Ljava/util/List;", "getStyleByName", "name", "", "defaultStyle", "getDefaultStyle", "()Lorg/brailleblaster/utd/Style;", "updateFrom", "other", "hashCode", "equals", "toString", "afterUnmarshal", "u", "Ljakarta/xml/bind/Unmarshaller;", "parent", "beforeMarshal", "m", "Ljakarta/xml/bind/Marshaller;", "Companion", "utd"})
@SourceDebugExtension(value={"SMAP\nStyleDefinitions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StyleDefinitions.kt\norg/brailleblaster/utd/config/StyleDefinitions\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,160:1\n296#2,2:161\n*S KotlinDebug\n*F\n+ 1 StyleDefinitions.kt\norg/brailleblaster/utd/config/StyleDefinitions\n*L\n87#1:161,2\n*E\n"})
public final class StyleDefinitions {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @XmlTransient
    private boolean versionSet;
    private int version = 1;
    @XmlElement(name="style")
    @NotNull
    private final List<Style> _styles = new ArrayList();
    @NotNull
    public static final String DEFAULT_STYLE = "DEFAULT";
    @XmlTransient
    @NotNull
    private static final Logger log;

    public final int getVersion() {
        return this.version;
    }

    @XmlAttribute
    private final void setVersion(int value) {
        this.version = value;
        this.versionSet = true;
    }

    public final void addStyles(@NotNull Iterable<? extends Style> stylesInput) {
        Intrinsics.checkNotNullParameter(stylesInput, (String)"stylesInput");
        stylesInput.forEach(arg_0 -> StyleDefinitions.addStyles$lambda$0(this, arg_0));
    }

    public final void addStyle(@Nullable Style style) {
        if (style == null) {
            throw new NullPointerException("style");
        }
        String string = style.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (StringsKt.isBlank((CharSequence)string)) {
            throw new RuntimeException("Style " + style + " cannot have a blank name");
        }
        Style baseStyle = style.getBaseStyle();
        if (baseStyle != null && !this._styles.contains(baseStyle) && !Intrinsics.areEqual((Object)baseStyle, (Object)this.getDefaultStyle())) {
            String string2 = "Base style %s is not in style definitions for style %s";
            Object[] objectArray = new Object[]{baseStyle.getName(), style};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
            throw new RuntimeException(string3);
        }
        Style existingStyle = this.getStyleByName(style.getName());
        if (existingStyle != null) {
            throw new RuntimeException("Style " + style + " is a duplicate of existing style " + existingStyle);
        }
        this._styles.add(style);
    }

    public final void removeStyle(@Nullable Style style) {
        if (style == null) {
            throw new NullPointerException("style");
        }
        if (!this._styles.contains(style)) {
            throw new RuntimeException("Style " + style + " is not contained in definitions!");
        }
        this._styles.remove(style);
    }

    public final void clear() {
        this._styles.clear();
    }

    @NotNull
    public final List<Style> getStyles() {
        return CollectionsKt.toList((Iterable)this._styles);
    }

    @Nullable
    public final Style getStyleByName(@Nullable String name) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = this._styles;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Style it = (Style)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Nullable
    public final Style getDefaultStyle() {
        return this.getStyleByName(DEFAULT_STYLE);
    }

    public final void updateFrom(@NotNull StyleDefinitions other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        this._styles.addAll((Collection<Style>)other.getStyles());
        this.setVersion(other.version);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public boolean equals(@Nullable Object other) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)other, (String[])new String[0]);
    }

    @NotNull
    public String toString() {
        String string = ToStringBuilder.reflectionToString((Object)this);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"reflectionToString(...)");
        return string;
    }

    public final void afterUnmarshal(@Nullable Unmarshaller u, @Nullable Object parent) {
        if (!this.versionSet) {
            log.debug("Old style definitions file, setting version to 0");
            this.setVersion(0);
        }
        if (this.version < 1) {
            for (Style style : this._styles) {
                if (style == this.getDefaultStyle()) continue;
                if (style.getBaseStyleName() != null) {
                    Style baseStyle;
                    if (this.getStyleByName(style.getBaseStyleName()) == null) {
                        throw new IllegalArgumentException("Can't find base style " + style.getBaseStyleName() + " for style " + style.getName());
                    }
                    style.setBaseStyle(baseStyle);
                    continue;
                }
                if (style.getBaseStyle() != null) continue;
                style.setBaseStyle(this.getDefaultStyle());
            }
        }
    }

    public final void beforeMarshal(@Nullable Marshaller m) {
        for (Style curStyle : this._styles) {
            Style baseStyle = curStyle.getBaseStyle();
            if (baseStyle == null) continue;
            curStyle.setBaseStyleName(baseStyle.getName());
        }
    }

    private static final void addStyles$lambda$0(StyleDefinitions this$0, Style style) {
        this$0.addStyle(style);
    }

    static {
        Logger logger = LoggerFactory.getLogger(StyleDefinitions.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        log = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/brailleblaster/utd/config/StyleDefinitions$Companion;", "", "<init>", "()V", "DEFAULT_STYLE", "", "log", "Lorg/slf4j/Logger;", "utd"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

