/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.utd.config;

import com.google.common.base.CaseFormat;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamResult;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.brailleblaster.utd.ActionMap;
import org.brailleblaster.utd.BrailleSettings;
import org.brailleblaster.utd.IActionMap;
import org.brailleblaster.utd.IStyleMap;
import org.brailleblaster.utd.PageSettings;
import org.brailleblaster.utd.Shortcut;
import org.brailleblaster.utd.Style;
import org.brailleblaster.utd.StyleMap;
import org.brailleblaster.utd.UTDTranslationEngine;
import org.brailleblaster.utd.config.ShortcutDefinitions;
import org.brailleblaster.utd.config.StyleDefinitions;
import org.brailleblaster.utd.exceptions.UTDException;
import org.brailleblaster.utd.internal.ActionMapAdapter;
import org.brailleblaster.utd.internal.AdaptedActionMap;
import org.brailleblaster.utd.internal.AdaptedStyleMap;
import org.brailleblaster.utd.internal.ComparableStyleAdapter;
import org.brailleblaster.utd.internal.InterfaceAdapter;
import org.brailleblaster.utd.internal.JAXBUtils;
import org.brailleblaster.utd.internal.StyleMapAdapter;
import org.brailleblaster.utd.internal.StyleOptionsFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00c8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\bH\u0007J\u001e\u0010#\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\bJ\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020!H\u0007J\u0016\u0010'\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020!2\u0006\u0010(\u001a\u00020%J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020!H\u0007J\u0018\u0010,\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020!2\u0006\u0010-\u001a\u00020*H\u0007J\u0012\u0010.\u001a\u0004\u0018\u00010/2\u0006\u00100\u001a\u00020!H\u0007J\u0018\u00101\u001a\u00020\u001d2\u0006\u00100\u001a\u00020!2\u0006\u00102\u001a\u000203H\u0007J\u001c\u00104\u001a\u0004\u0018\u0001052\u0006\u00106\u001a\u00020!2\b\u00107\u001a\u0004\u0018\u000108H\u0007J\u0018\u00109\u001a\u00020\u001d2\u0006\u00106\u001a\u00020!2\u0006\u0010:\u001a\u00020;H\u0007J\u0016\u0010<\u001a\u00020\u001d2\u0006\u00106\u001a\u00020!2\u0006\u0010:\u001a\u00020;J1\u0010=\u001a\u0002H>\"\u0004\b\u0000\u0010>2\u0006\u0010?\u001a\u00020!2\u000e\u0010@\u001a\n\u0012\u0004\u0012\u0002H>\u0018\u00010A2\u0006\u0010B\u001a\u00020\u0014\u00a2\u0006\u0002\u0010CJG\u0010=\u001a\u0002H>\"\u0004\b\u0000\u0010>2\u0006\u0010?\u001a\u00020!2\u000e\u0010@\u001a\n\u0012\u0004\u0012\u0002H>\u0018\u00010A2\u0006\u0010B\u001a\u00020\u00142\u0014\u0010D\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030F0E\u00a2\u0006\u0002\u0010GJ)\u0010H\u001a\u00020\u001d\"\u0004\b\u0000\u0010>2\u0006\u0010I\u001a\u00020!2\u0006\u0010J\u001a\u0002H>2\u0006\u0010B\u001a\u00020\u0014\u00a2\u0006\u0002\u0010KJ\u0010\u0010L\u001a\u0002082\u0006\u0010M\u001a\u00020!H\u0007J\u0018\u0010N\u001a\u00020\u001d2\u0006\u0010M\u001a\u00020!2\u0006\u00107\u001a\u000208H\u0007J\u000e\u0010O\u001a\u00020P2\u0006\u0010Q\u001a\u00020!J \u0010R\u001a\u00020S2\u0006\u0010T\u001a\u00020U2\u0006\u0010V\u001a\u00020W2\u0006\u0010X\u001a\u00020PH\u0002J\u0016\u0010Y\u001a\u00020\u001d2\u0006\u0010Q\u001a\u00020!2\u0006\u0010X\u001a\u00020PJ(\u0010Z\u001a\u00020[2\u0006\u0010\\\u001a\u00020\b2\u0006\u0010]\u001a\u00020S2\u0006\u0010^\u001a\u00020_2\u0006\u0010X\u001a\u00020PH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\r0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u001d\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\r0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000bR\u001c\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\t0\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006`"}, d2={"Lorg/brailleblaster/utd/config/UTDConfig;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "STYLE_FIELDS", "", "", "Ljava/lang/reflect/Field;", "getSTYLE_FIELDS", "()Ljava/util/Map;", "STYLE_FIELD_SETTERS", "Ljava/lang/reflect/Method;", "getSTYLE_FIELD_SETTERS", "STYLE_FIELD_GETTERS", "getSTYLE_FIELD_GETTERS", "STYLE_OPTION_FIELDS", "Lorg/brailleblaster/utd/Style$StyleOption;", "JAXB_CONTEXT_SETTINGS", "Ljakarta/xml/bind/JAXBContext;", "JAXB_CONTEXT_ACTIONMAP", "JAXB_CONTEXT_STYLE_MAP", "JAXB_CONTEXT_STYLE_DEFINITIONS", "JAXB_XML_FACTORY", "Ljavax/xml/stream/XMLInputFactory;", "SHORTCUT_ID_TAG", "SHORTCUT_KEY_COMBINATION_TAG", "loadMappings", "", "engine", "Lorg/brailleblaster/utd/UTDTranslationEngine;", "mappingsDir", "Ljava/io/File;", "mappingsPrefix", "saveMappings", "loadPageSettings", "Lorg/brailleblaster/utd/PageSettings;", "pageSettingsFile", "savePageSettings", "pageSettings", "loadBrailleSettings", "Lorg/brailleblaster/utd/BrailleSettings;", "brailleSettingsFile", "saveBrailleSettings", "brailleSettings", "loadActions", "Lorg/brailleblaster/utd/ActionMap;", "actionsFile", "saveActions", "actionMap", "Lorg/brailleblaster/utd/IActionMap;", "loadStyle", "Lorg/brailleblaster/utd/StyleMap;", "styleFile", "styleDefs", "Lorg/brailleblaster/utd/config/StyleDefinitions;", "saveStyle", "styleMap", "Lorg/brailleblaster/utd/IStyleMap;", "saveStyleWithDefs", "loadJAXB", "V", "inputFile", "valueClass", "Ljava/lang/Class;", "jaxbContext", "(Ljava/io/File;Ljava/lang/Class;Ljakarta/xml/bind/JAXBContext;)Ljava/lang/Object;", "adapterInstances", "", "Ljakarta/xml/bind/annotation/adapters/XmlAdapter;", "(Ljava/io/File;Ljava/lang/Class;Ljakarta/xml/bind/JAXBContext;Ljava/util/List;)Ljava/lang/Object;", "saveJAXB", "outputFile", "value", "(Ljava/io/File;Ljava/lang/Object;Ljakarta/xml/bind/JAXBContext;)V", "loadStyleDefinitions", "styleDefsFile", "saveStyleDefinitions", "loadShortcutDefinitions", "Lorg/brailleblaster/utd/config/ShortcutDefinitions;", "shortcutDefsFile", "loadShortcut", "Lorg/brailleblaster/utd/Shortcut;", "shortcutRoot", "Lorg/w3c/dom/Node;", "shortcutIndex", "", "shortcutDefs", "saveShortcutDefinitions", "saveShortcut", "Lorg/w3c/dom/Element;", "rootName", "curShortcut", "document", "Lorg/w3c/dom/Document;", "utd"})
@SourceDebugExtension(value={"SMAP\nUTDConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UTDConfig.kt\norg/brailleblaster/utd/config/UTDConfig\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,444:1\n1#2:445\n*E\n"})
public final class UTDConfig {
    @NotNull
    public static final UTDConfig INSTANCE = new UTDConfig();
    @NotNull
    private static final Logger log;
    @NotNull
    private static final Map<String, Field> STYLE_FIELDS;
    @NotNull
    private static final Map<Field, Method> STYLE_FIELD_SETTERS;
    @NotNull
    private static final Map<Field, Method> STYLE_FIELD_GETTERS;
    @JvmField
    @NotNull
    public static final Map<Style.StyleOption, Field> STYLE_OPTION_FIELDS;
    @Nullable
    private static JAXBContext JAXB_CONTEXT_SETTINGS;
    @Nullable
    private static JAXBContext JAXB_CONTEXT_ACTIONMAP;
    @Nullable
    private static JAXBContext JAXB_CONTEXT_STYLE_MAP;
    @Nullable
    private static JAXBContext JAXB_CONTEXT_STYLE_DEFINITIONS;
    @Nullable
    private static XMLInputFactory JAXB_XML_FACTORY;
    @NotNull
    private static final String SHORTCUT_ID_TAG = "id";
    @NotNull
    private static final String SHORTCUT_KEY_COMBINATION_TAG = "key-combination";

    private UTDConfig() {
    }

    @NotNull
    public final Map<String, Field> getSTYLE_FIELDS() {
        return STYLE_FIELDS;
    }

    @NotNull
    public final Map<Field, Method> getSTYLE_FIELD_SETTERS() {
        return STYLE_FIELD_SETTERS;
    }

    @NotNull
    public final Map<Field, Method> getSTYLE_FIELD_GETTERS() {
        return STYLE_FIELD_GETTERS;
    }

    @JvmStatic
    public static final void loadMappings(@NotNull UTDTranslationEngine engine, @NotNull File mappingsDir, @NotNull String mappingsPrefix) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        Intrinsics.checkNotNullParameter((Object)mappingsDir, (String)"mappingsDir");
        Intrinsics.checkNotNullParameter((Object)mappingsPrefix, (String)"mappingsPrefix");
        if (!mappingsDir.isDirectory()) {
            boolean $i$a$-require-UTDConfig$loadMappings$32 = false;
            String $i$a$-require-UTDConfig$loadMappings$32 = mappingsDir + " for mappings is not a directory";
            throw new IllegalArgumentException($i$a$-require-UTDConfig$loadMappings$32.toString());
        }
        if (!(!StringsKt.isBlank((CharSequence)mappingsPrefix))) {
            boolean bl = false;
            String string = "Mapping file prefix cannot be blank";
            throw new IllegalArgumentException(string.toString());
        }
        StyleMap styleMap = UTDConfig.loadStyle(new File(mappingsDir, mappingsPrefix + ".styleMap.xml"), engine.getStyleDefinitions());
        Intrinsics.checkNotNull((Object)styleMap);
        engine.setStyleMap(styleMap);
        ActionMap actionMap = UTDConfig.loadActions(new File(mappingsDir, mappingsPrefix + ".actionMap.xml"));
        Intrinsics.checkNotNull((Object)actionMap);
        engine.setActionMap(actionMap);
    }

    public final void saveMappings(@NotNull UTDTranslationEngine engine, @NotNull File mappingsDir, @NotNull String mappingsPrefix) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        Intrinsics.checkNotNullParameter((Object)mappingsDir, (String)"mappingsDir");
        Intrinsics.checkNotNullParameter((Object)mappingsPrefix, (String)"mappingsPrefix");
        if (!mappingsDir.isDirectory()) {
            boolean $i$a$-require-UTDConfig$saveMappings$32 = false;
            String $i$a$-require-UTDConfig$saveMappings$32 = mappingsDir + " for mappings is not a directory";
            throw new IllegalArgumentException($i$a$-require-UTDConfig$saveMappings$32.toString());
        }
        if (!(!StringsKt.isBlank((CharSequence)mappingsPrefix))) {
            boolean bl = false;
            String string = "Mapping file prefix cannot be blank";
            throw new IllegalArgumentException(string.toString());
        }
        UTDConfig.saveStyle(new File(mappingsDir, mappingsPrefix + ".styleMap.xml"), engine.getStyleMap());
        UTDConfig.saveActions(new File(mappingsDir, mappingsPrefix + ".actionMap.xml"), engine.getActionMap());
    }

    @JvmStatic
    @NotNull
    public static final PageSettings loadPageSettings(@NotNull File pageSettingsFile) {
        Intrinsics.checkNotNullParameter((Object)pageSettingsFile, (String)"pageSettingsFile");
        log.debug("Loading Page Settings from file {}", (Object)pageSettingsFile);
        JAXBContext jAXBContext = JAXB_CONTEXT_SETTINGS;
        Intrinsics.checkNotNull((Object)jAXBContext);
        return INSTANCE.loadJAXB(pageSettingsFile, PageSettings.class, jAXBContext);
    }

    public final void savePageSettings(@NotNull File pageSettingsFile, @NotNull PageSettings pageSettings) {
        Intrinsics.checkNotNullParameter((Object)pageSettingsFile, (String)"pageSettingsFile");
        Intrinsics.checkNotNullParameter((Object)pageSettings, (String)"pageSettings");
        log.debug("Writing Page Settings to file {}", (Object)pageSettingsFile);
        JAXBContext jAXBContext = JAXB_CONTEXT_SETTINGS;
        Intrinsics.checkNotNull((Object)jAXBContext);
        this.saveJAXB(pageSettingsFile, pageSettings, jAXBContext);
    }

    @JvmStatic
    @NotNull
    public static final BrailleSettings loadBrailleSettings(@NotNull File brailleSettingsFile) {
        Intrinsics.checkNotNullParameter((Object)brailleSettingsFile, (String)"brailleSettingsFile");
        log.debug("Loading Braille Settings from file {}", (Object)brailleSettingsFile);
        JAXBContext jAXBContext = JAXB_CONTEXT_SETTINGS;
        Intrinsics.checkNotNull((Object)jAXBContext);
        return INSTANCE.loadJAXB(brailleSettingsFile, BrailleSettings.class, jAXBContext);
    }

    @JvmStatic
    public static final void saveBrailleSettings(@NotNull File brailleSettingsFile, @NotNull BrailleSettings brailleSettings) {
        Intrinsics.checkNotNullParameter((Object)brailleSettingsFile, (String)"brailleSettingsFile");
        Intrinsics.checkNotNullParameter((Object)brailleSettings, (String)"brailleSettings");
        log.debug("Writing Braille Settings to file {}", (Object)brailleSettingsFile);
        JAXBContext jAXBContext = JAXB_CONTEXT_SETTINGS;
        Intrinsics.checkNotNull((Object)jAXBContext);
        INSTANCE.saveJAXB(brailleSettingsFile, brailleSettings, jAXBContext);
    }

    @JvmStatic
    @Nullable
    public static final ActionMap loadActions(@NotNull File actionsFile) {
        Intrinsics.checkNotNullParameter((Object)actionsFile, (String)"actionsFile");
        log.debug("Loading ActionMap from file {}", (Object)actionsFile);
        ActionMapAdapter adapter = new ActionMapAdapter();
        JAXBContext jAXBContext = JAXB_CONTEXT_ACTIONMAP;
        Intrinsics.checkNotNull((Object)jAXBContext);
        return adapter.unmarshal(INSTANCE.loadJAXB(actionsFile, AdaptedActionMap.class, jAXBContext));
    }

    @JvmStatic
    public static final void saveActions(@NotNull File actionsFile, @NotNull IActionMap actionMap) {
        Intrinsics.checkNotNullParameter((Object)actionsFile, (String)"actionsFile");
        Intrinsics.checkNotNullParameter((Object)actionMap, (String)"actionMap");
        log.debug("Writing ActionMap to file {} - overwriting {}", (Object)actionsFile, (Object)actionsFile.exists());
        if (!(actionMap instanceof ActionMap)) {
            boolean bl = false;
            String string = "Only supports ActionMap, given " + actionMap + " " + actionMap.getClass();
            throw new IllegalArgumentException(string.toString());
        }
        ActionMapAdapter adapter = new ActionMapAdapter();
        AdaptedActionMap adaptedActionMap = adapter.marshal((ActionMap)actionMap);
        JAXBContext jAXBContext = JAXB_CONTEXT_ACTIONMAP;
        Intrinsics.checkNotNull((Object)jAXBContext);
        INSTANCE.saveJAXB(actionsFile, adaptedActionMap, jAXBContext);
    }

    @JvmStatic
    @Nullable
    public static final StyleMap loadStyle(@NotNull File styleFile, @Nullable StyleDefinitions styleDefs) {
        Intrinsics.checkNotNullParameter((Object)styleFile, (String)"styleFile");
        log.debug("Loading StyleMap from file {}", (Object)styleFile);
        StyleMapAdapter adapter = new StyleMapAdapter(styleDefs);
        List adapters = new ArrayList();
        adapters.add(new ComparableStyleAdapter(styleDefs));
        JAXBContext jAXBContext = JAXB_CONTEXT_STYLE_MAP;
        Intrinsics.checkNotNull((Object)jAXBContext);
        return adapter.unmarshal(INSTANCE.loadJAXB(styleFile, AdaptedStyleMap.class, jAXBContext, adapters));
    }

    @JvmStatic
    public static final void saveStyle(@NotNull File styleFile, @NotNull IStyleMap styleMap) {
        Intrinsics.checkNotNullParameter((Object)styleFile, (String)"styleFile");
        Intrinsics.checkNotNullParameter((Object)styleMap, (String)"styleMap");
        log.debug("Writing StyleMap to file {} - overwriting {}", (Object)styleFile, (Object)styleFile.exists());
        if (!(styleMap instanceof StyleMap)) {
            boolean bl = false;
            String string = "Only supports StyleMap, given " + styleMap + " " + styleMap.getClass();
            throw new IllegalArgumentException(string.toString());
        }
        StyleMapAdapter adapter = new StyleMapAdapter(false);
        AdaptedStyleMap adaptedStyleMap = adapter.marshal((StyleMap)styleMap);
        JAXBContext jAXBContext = JAXB_CONTEXT_STYLE_MAP;
        Intrinsics.checkNotNull((Object)jAXBContext);
        INSTANCE.saveJAXB(styleFile, adaptedStyleMap, jAXBContext);
    }

    public final void saveStyleWithDefs(@NotNull File styleFile, @NotNull IStyleMap styleMap) {
        Intrinsics.checkNotNullParameter((Object)styleFile, (String)"styleFile");
        Intrinsics.checkNotNullParameter((Object)styleMap, (String)"styleMap");
        log.debug("Writing StyleMap with definitions to file {} - overwriting {}", (Object)styleFile, (Object)styleFile.exists());
        if (!(styleMap instanceof StyleMap)) {
            boolean bl = false;
            String string = "Only supports StyleMap, given " + styleMap + " " + styleMap.getClass();
            throw new IllegalArgumentException(string.toString());
        }
        StyleMapAdapter adapter = new StyleMapAdapter(true);
        AdaptedStyleMap adaptedStyleMap = adapter.marshal((StyleMap)styleMap);
        JAXBContext jAXBContext = JAXB_CONTEXT_STYLE_MAP;
        Intrinsics.checkNotNull((Object)jAXBContext);
        this.saveJAXB(styleFile, adaptedStyleMap, jAXBContext);
    }

    public final <V> V loadJAXB(@NotNull File inputFile, @Nullable Class<V> valueClass, @NotNull JAXBContext jaxbContext) {
        Intrinsics.checkNotNullParameter((Object)inputFile, (String)"inputFile");
        Intrinsics.checkNotNullParameter((Object)jaxbContext, (String)"jaxbContext");
        return this.loadJAXB(inputFile, valueClass, jaxbContext, new ArrayList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public final <V> V loadJAXB(@NotNull File inputFile, @Nullable Class<V> valueClass, @NotNull JAXBContext jaxbContext, @NotNull List<? extends XmlAdapter<?, ?>> adapterInstances) {
        Object object;
        Throwable throwable;
        Closeable closeable;
        XMLStreamReader inputXml;
        block13: {
            Intrinsics.checkNotNullParameter((Object)inputFile, (String)"inputFile");
            Intrinsics.checkNotNullParameter((Object)jaxbContext, (String)"jaxbContext");
            Intrinsics.checkNotNullParameter(adapterInstances, (String)"adapterInstances");
            inputXml = null;
            BOMInputStream bOMInputStream = ((BOMInputStream.Builder)BOMInputStream.builder().setInputStream((InputStream)new FileInputStream(inputFile))).get();
            Intrinsics.checkNotNullExpressionValue((Object)bOMInputStream, (String)"get(...)");
            closeable = (InputStream)bOMInputStream;
            int n = 8192;
            closeable = closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n);
            throwable = null;
            BufferedInputStream input = (BufferedInputStream)closeable;
            boolean bl = false;
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            for (XmlAdapter<?, ?> adapter : adapterInstances) {
                unmarshaller.setAdapter(adapter);
            }
            InterfaceAdapter interfaceAdapter = new InterfaceAdapter(adapterInstances);
            unmarshaller.setAdapter((XmlAdapter)interfaceAdapter);
            unmarshaller.setEventHandler(JAXBUtils.FAIL_ON_EXCEPTIONS_HANDLER);
            XMLInputFactory xMLInputFactory = JAXB_XML_FACTORY;
            Intrinsics.checkNotNull((Object)xMLInputFactory);
            inputXml = xMLInputFactory.createXMLStreamReader(input);
            JAXBElement result = unmarshaller.unmarshal(inputXml, valueClass);
            Object object2 = result.getValue();
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            object = object2;
            if (inputXml == null) break block13;
            inputXml.close();
        }
        return (V)object;
        {
            catch (Throwable throwable2) {
                try {
                    try {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            CloseableKt.closeFinally((Closeable)closeable, throwable);
                            throw throwable3;
                        }
                    }
                    catch (Exception e) {
                        throw new UTDException("Cannot load settings from file " + inputFile, e);
                    }
                }
                catch (Throwable throwable4) {
                    if (inputXml != null) {
                        try {
                            ((XMLStreamReader)inputXml).close();
                        }
                        catch (XMLStreamException ex) {
                            log.warn("Could not close XML stream", (Throwable)ex);
                        }
                    }
                    throw throwable4;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <V> void saveJAXB(@NotNull File outputFile, V value, @NotNull JAXBContext jaxbContext) {
        Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
        Intrinsics.checkNotNullParameter((Object)jaxbContext, (String)"jaxbContext");
        try {
            Closeable closeable = new BufferedOutputStream(new FileOutputStream(outputFile));
            Throwable throwable = null;
            try {
                BufferedOutputStream output = (BufferedOutputStream)closeable;
                boolean bl = false;
                Marshaller marshaller = jaxbContext.createMarshaller();
                marshaller.setEventHandler(JAXBUtils.FAIL_ON_EXCEPTIONS_HANDLER);
                marshaller.setProperty("jaxb.formatted.output", (Object)true);
                marshaller.marshal(value, (OutputStream)output);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            throw new UTDException("Cannot save settings to file " + outputFile, e);
        }
    }

    @JvmStatic
    @NotNull
    public static final StyleDefinitions loadStyleDefinitions(@NotNull File styleDefsFile) {
        Intrinsics.checkNotNullParameter((Object)styleDefsFile, (String)"styleDefsFile");
        log.debug("Loading StyleDefinitions from file {}", (Object)styleDefsFile.getAbsolutePath());
        if (!styleDefsFile.exists()) {
            throw new RuntimeException("Style definitions file at " + styleDefsFile + " does not exist " + styleDefsFile.getAbsolutePath());
        }
        StyleDefinitions result = new StyleDefinitions();
        List adapters = CollectionsKt.listOf((Object)((Object)new ComparableStyleAdapter(result)));
        JAXBContext jAXBContext = JAXB_CONTEXT_STYLE_DEFINITIONS;
        Intrinsics.checkNotNull((Object)jAXBContext);
        StyleDefinitions tmpStyleDefs = INSTANCE.loadJAXB(styleDefsFile, StyleDefinitions.class, jAXBContext, adapters);
        result.updateFrom(tmpStyleDefs);
        return result;
    }

    @JvmStatic
    public static final void saveStyleDefinitions(@NotNull File styleDefsFile, @NotNull StyleDefinitions styleDefs) {
        Intrinsics.checkNotNullParameter((Object)styleDefsFile, (String)"styleDefsFile");
        Intrinsics.checkNotNullParameter((Object)styleDefs, (String)"styleDefs");
        log.debug("Writing Style Definitions to file {} - overwriting {}", (Object)styleDefsFile, (Object)styleDefsFile.exists());
        JAXBContext jAXBContext = JAXB_CONTEXT_STYLE_DEFINITIONS;
        Intrinsics.checkNotNull((Object)jAXBContext);
        INSTANCE.saveJAXB(styleDefsFile, styleDefs, jAXBContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final ShortcutDefinitions loadShortcutDefinitions(@NotNull File shortcutDefsFile) {
        Intrinsics.checkNotNullParameter((Object)shortcutDefsFile, (String)"shortcutDefsFile");
        log.debug("Loading Shortcut Definitions from file {}", (Object)shortcutDefsFile.getAbsolutePath());
        if (!shortcutDefsFile.exists()) {
            throw new RuntimeException("Shortcut definitions file at " + shortcutDefsFile + " does not exist " + shortcutDefsFile.getAbsolutePath());
        }
        try {
            Closeable closeable = new FileInputStream(shortcutDefsFile);
            Throwable throwable = null;
            try {
                FileInputStream input = (FileInputStream)closeable;
                boolean bl = false;
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.parse(input);
                Element root = document.getDocumentElement();
                root.normalize();
                ShortcutDefinitions defs = new ShortcutDefinitions();
                NodeList rootChildren = root.getChildNodes();
                int n = rootChildren.getLength();
                for (int i = 0; i < n; ++i) {
                    Node shortcutRoot = rootChildren.item(i);
                    String shortcutRootName = shortcutRoot.getNodeName();
                    if (shortcutRoot.getNodeType() != 1) continue;
                    if (Intrinsics.areEqual((Object)shortcutRootName, (Object)"shortcut")) {
                        Intrinsics.checkNotNull((Object)shortcutRoot);
                        defs.addShortcut(INSTANCE.loadShortcut(shortcutRoot, i, defs));
                        continue;
                    }
                    throw new RuntimeException("Unknown field " + shortcutRootName + " at shortcut index " + i);
                }
                ShortcutDefinitions shortcutDefinitions = defs;
                return shortcutDefinitions;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            Throwable throwable;
            if (e instanceof InvocationTargetException) {
                Throwable throwable3 = ((InvocationTargetException)e).getCause();
                throwable = throwable3;
                Intrinsics.checkNotNull((Object)throwable3);
            } else {
                throwable = e;
            }
            Throwable cleanCause = throwable;
            throw new UTDException("Could not load ShortcutDefinitions from file " + shortcutDefsFile, cleanCause);
        }
    }

    private final Shortcut loadShortcut(Node shortcutRoot, int shortcutIndex, ShortcutDefinitions shortcutDefs) {
        String id = "";
        String keyCombo = "";
        NodeList shortcutRootChildren = shortcutRoot.getChildNodes();
        int n = shortcutRootChildren.getLength();
        for (int j = 0; j < n; ++j) {
            Node shortcutElement = shortcutRootChildren.item(j);
            String shortcutElementName = shortcutElement.getNodeName();
            if (shortcutElement.getNodeType() != 1) continue;
            String elementValue = shortcutElement.getTextContent();
            if (Intrinsics.areEqual((Object)shortcutElementName, (Object)SHORTCUT_ID_TAG)) {
                id = elementValue;
                continue;
            }
            if (!Intrinsics.areEqual((Object)shortcutElementName, (Object)SHORTCUT_KEY_COMBINATION_TAG)) continue;
            keyCombo = elementValue;
        }
        String string = id;
        Intrinsics.checkNotNull((Object)string);
        String string2 = keyCombo;
        Intrinsics.checkNotNull((Object)string2);
        return new Shortcut(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void saveShortcutDefinitions(@NotNull File shortcutDefsFile, @NotNull ShortcutDefinitions shortcutDefs) {
        Intrinsics.checkNotNullParameter((Object)shortcutDefsFile, (String)"shortcutDefsFile");
        Intrinsics.checkNotNullParameter((Object)shortcutDefs, (String)"shortcutDefs");
        log.debug("Writing Shortcut Definitions to file {} - overwriting {}", (Object)shortcutDefsFile, (Object)shortcutDefsFile.exists());
        try {
            Closeable closeable = new FileOutputStream(shortcutDefsFile);
            Throwable throwable = null;
            try {
                FileOutputStream output = (FileOutputStream)closeable;
                boolean bl = false;
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.newDocument();
                Element root = document.createElement("ShortcutDefinitions");
                for (Shortcut curShortcut : shortcutDefs.getShortcuts()) {
                    Intrinsics.checkNotNull((Object)document);
                    root.appendChild(INSTANCE.saveShortcut("shortcut", curShortcut, document, shortcutDefs));
                }
                document.appendChild(root);
                JAXBUtils.toXML(root, new StreamResult(output));
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            throw new UTDException("Could not save Shortcut Definitions to file " + shortcutDefsFile, e);
        }
    }

    private final Element saveShortcut(String rootName, Shortcut curShortcut, Document document, ShortcutDefinitions shortcutDefs) {
        Element shortcutRoot = document.createElement(rootName);
        Element idElement = document.createElement(SHORTCUT_ID_TAG);
        idElement.setTextContent(curShortcut.getId());
        shortcutRoot.appendChild(idElement);
        Element keyCombinationElement = document.createElement(SHORTCUT_KEY_COMBINATION_TAG);
        keyCombinationElement.setTextContent(curShortcut.getKeyCombination());
        shortcutRoot.appendChild(keyCombinationElement);
        Intrinsics.checkNotNull((Object)shortcutRoot);
        return shortcutRoot;
    }

    static {
        Logger logger = LoggerFactory.getLogger(UTDConfig.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        log = logger;
        Field[] fieldsDecl = Style.class.getDeclaredFields();
        Map styleFields = new LinkedHashMap();
        Map styleSetters = new LinkedHashMap();
        Map styleGetters = new LinkedHashMap();
        Map styleOptionFields = new LinkedHashMap();
        Intrinsics.checkNotNull((Object)fieldsDecl);
        for (Field curField : fieldsDecl) {
            String name = curField.getName();
            if (Modifier.isStatic(curField.getModifiers())) continue;
            curField.setAccessible(true);
            styleFields.put(name, curField);
            try {
                String getterName = "get" + StringUtils.capitalize((String)name);
                Method getter = MethodUtils.getAccessibleMethod(Style.class, (String)getterName, (Class[])new Class[0]);
                String getterNameIs = "is" + StringUtils.capitalize((String)name);
                if (getter == null) {
                    getter = MethodUtils.getAccessibleMethod(Style.class, (String)getterNameIs, (Class[])new Class[0]);
                }
                if (getter == null) {
                    Intrinsics.checkNotNull((Object)name);
                    if (StringsKt.startsWith$default((String)name, (String)"is", (boolean)false, (int)2, null)) {
                        getter = MethodUtils.getAccessibleMethod(Style.class, (String)name, (Class[])new Class[0]);
                    }
                }
                if (getter == null) {
                    throw new NoSuchMethodException("Cannot find method " + getterName + "() or " + getterNameIs + "() or " + name + "() in " + Style.class);
                }
                styleGetters.put(curField, getter);
                Class<?> fieldClass = getter.getReturnType();
                String setterName = "set" + StringUtils.capitalize((String)name);
                Class[] classArray = new Class[]{fieldClass};
                Method setter = Style.class.getDeclaredMethod(setterName, classArray);
                styleSetters.put(curField, setter);
                XmlElementRef xmlRef = curField.getAnnotation(XmlElementRef.class);
                if (xmlRef == null) continue;
                try {
                    String string = CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, xmlRef.name());
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"to(...)");
                    Style.StyleOption fieldStyleOption = Style.StyleOption.valueOf(string);
                    styleOptionFields.put(fieldStyleOption, curField);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception ex) {
                throw new RuntimeException("Unable to find methods for field " + name, ex);
            }
        }
        STYLE_FIELDS = MapsKt.toMap((Map)styleFields);
        STYLE_FIELD_SETTERS = MapsKt.toMap((Map)styleSetters);
        STYLE_FIELD_GETTERS = MapsKt.toMap((Map)styleGetters);
        STYLE_OPTION_FIELDS = MapsKt.toMap((Map)styleOptionFields);
        try {
            AnnotatedElement[] annotatedElementArray = new Class[]{PageSettings.class, BrailleSettings.class};
            JAXB_CONTEXT_SETTINGS = JAXBContext.newInstance((Class[])annotatedElementArray);
            annotatedElementArray = new Class[]{AdaptedActionMap.class};
            JAXB_CONTEXT_ACTIONMAP = JAXBContext.newInstance((Class[])annotatedElementArray);
            annotatedElementArray = new Class[]{AdaptedStyleMap.class, StyleOptionsFactory.class};
            JAXB_CONTEXT_STYLE_MAP = JAXBContext.newInstance((Class[])annotatedElementArray);
            annotatedElementArray = new Class[]{StyleDefinitions.class, StyleOptionsFactory.class};
            JAXB_CONTEXT_STYLE_DEFINITIONS = JAXBContext.newInstance((Class[])annotatedElementArray);
            JAXB_XML_FACTORY = XMLInputFactory.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to init JAXBContext", e);
        }
    }
}

