/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.utd.exceptions;

import java.io.File;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import org.brailleblaster.utd.internal.xml.XMLHandler;
import org.brailleblaster.utils.MoreFileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0004\b\u0016\u0018\u0000 \u000b2\u00060\u0001j\u0002`\u0002:\u0001\u000bB'\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\n\u00a8\u0006\f"}, d2={"Lorg/brailleblaster/utd/exceptions/NodeException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "message", "", "node", "Lnu/xom/Node;", "cause", "", "<init>", "(Ljava/lang/String;Lnu/xom/Node;Ljava/lang/Throwable;)V", "Companion", "utd"})
public class NodeException
extends RuntimeException {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String SAVE_TO_DISK_ENABLED_PROPERTY = "nodeexception.save";
    @NotNull
    public static final String SAVE_TO_DISK_FOLDER_PROPERTY = "nodeexception.folder";
    private static final int MAX_NODE_TOXML_CHARACTERS = 200;
    @NotNull
    public static final String ATTRIBUTE_NAME = "NodeExceptionID";
    @NotNull
    public static final String FILENAME_PREFIX = "node_exception";

    @JvmOverloads
    public NodeException(@NotNull String message, @Nullable Node node, @Nullable Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        super(NodeException.Companion.handleInput(message, node), cause);
    }

    public /* synthetic */ NodeException(String string, Node node, Throwable throwable, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            throwable = null;
        }
        this(string, node, throwable);
    }

    @JvmOverloads
    public NodeException(@NotNull String message, @Nullable Node node) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this(message, node, null, 4, null);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/brailleblaster/utd/exceptions/NodeException$Companion;", "", "<init>", "()V", "SAVE_TO_DISK_ENABLED_PROPERTY", "", "SAVE_TO_DISK_FOLDER_PROPERTY", "MAX_NODE_TOXML_CHARACTERS", "", "ATTRIBUTE_NAME", "FILENAME_PREFIX", "handleInput", "origMessage", "node", "Lnu/xom/Node;", "utd"})
    @SourceDebugExtension(value={"SMAP\nNodeException.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NodeException.kt\norg/brailleblaster/utd/exceptions/NodeException$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,129:1\n1#2:130\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final String handleInput(String origMessage, Node node) {
            File dest;
            Object message = origMessage;
            Node node2 = node;
            if (node2 == null) {
                return (String)message + " [null]";
            }
            if (node2 instanceof Element) {
                String string = ((Element)node).toXML();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toXML(...)");
                String toXML = StringsKt.take((String)string, (int)200) + "...[excess toXML trimmed]";
                message = (String)message + " " + toXML;
            } else {
                message = (String)message + " " + node;
            }
            if (node.getDocument() == null) {
                message = (String)message + " (node not attached to document)";
                return message;
            }
            String string = System.getProperty(NodeException.SAVE_TO_DISK_ENABLED_PROPERTY, "true");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
            if (!StringsKt.toBooleanStrict((String)string)) {
                message = (String)message + " (save to disk disabled)";
                return message;
            }
            String string2 = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            String callbackID = string2;
            callbackID = StringsKt.substringBefore$default((String)callbackID, (char)'-', null, (int)2, null);
            Attribute callbackAttrib = new Attribute(NodeException.ATTRIBUTE_NAME, callbackID);
            Element parentElement = null;
            if (node instanceof ParentNode) {
                parentElement = XMLHandler.Companion.parentToElement((ParentNode)node);
                parentElement.addAttribute(callbackAttrib);
                message = (String)message + " (search for string " + callbackID + " on element";
            } else {
                ParentNode parent = node.getParent();
                Intrinsics.checkNotNull((Object)parent);
                parentElement = XMLHandler.Companion.parentToElement(parent);
                parentElement.addAttribute(callbackAttrib);
                message = (String)message + " (search for string " + callbackID + " on parent, child index " + parent.indexOf(node);
            }
            Document doc = node.getDocument();
            Object filenameBase = NodeException.FILENAME_PREFIX;
            String origURI = doc.getBaseURI();
            Intrinsics.checkNotNull((Object)origURI);
            if (!StringsKt.isBlank((CharSequence)origURI)) {
                URI correctedUri = StringsKt.startsWith$default((String)origURI, (String)"jar-utd-encoded://", (boolean)false, (int)2, null) ? new URI(URLDecoder.decode(StringsKt.removePrefix((String)origURI, (CharSequence)"jar-utd-encoded://"), StandardCharsets.UTF_8)) : URI.create(origURI);
                Path path = Paths.get(correctedUri).getFileName();
                if (path == null) {
                    String string3 = "No path elements in the URI %s";
                    Object[] objectArray = new Object[]{origURI};
                    String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
                    throw new RuntimeException(string4);
                }
                Path fileName = path;
                String uri = ((Object)fileName).toString();
                int extensionIndex = 0;
                if (!StringsKt.isBlank((CharSequence)uri)) {
                    int n;
                    int it = n = StringsKt.lastIndexOf$default((CharSequence)uri, (char)'.', (int)0, (boolean)false, (int)6, null);
                    boolean bl = false;
                    extensionIndex = it;
                    if (n != -1) {
                        uri = StringsKt.take((String)uri, (int)extensionIndex);
                        filenameBase = (String)filenameBase + "_" + uri;
                    }
                }
            }
            File outputFile = (dest = new File(System.getProperty(NodeException.SAVE_TO_DISK_FOLDER_PROPERTY, "."))).isFile() ? dest : MoreFileUtils.newFileIncrimented((File)dest, (String)filenameBase, (String)".xml");
            XMLHandler.Formatted formatted = new XMLHandler.Formatted();
            Intrinsics.checkNotNull((Object)doc);
            formatted.save(doc, outputFile);
            message = (String)message + " in file " + outputFile.getAbsolutePath() + " )";
            return message;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

