/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.utd.formatters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import nu.xom.Text;
import org.brailleblaster.utd.FormatSelector;
import org.brailleblaster.utd.IStyle;
import org.brailleblaster.utd.IStyleMap;
import org.brailleblaster.utd.PageBuilder;
import org.brailleblaster.utd.StyleStack;
import org.brailleblaster.utd.exceptions.BadPoetryException;
import org.brailleblaster.utd.formatters.Formatter;
import org.brailleblaster.utd.formatters.LiteraryFormatter;
import org.brailleblaster.utd.properties.Align;
import org.brailleblaster.utd.properties.NumberLinePosition;
import org.brailleblaster.utd.properties.UTDElements;
import org.brailleblaster.utd.utils.PageBuilderHelper;
import org.brailleblaster.utd.utils.UTDHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0014\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JR\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\f\u00102\u001a\b\u0012\u0004\u0012\u00020-032\u0006\u00104\u001a\u0002052\u000e\u00106\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u0005J4\u0010+\u001a\b\u0012\u0004\u0012\u00020-032\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\f\u00102\u001a\b\u0012\u0004\u0012\u00020-0,2\u0006\u00104\u001a\u000205H\u0016J2\u00107\u001a\b\u0012\u0004\u0012\u00020-032\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\f\u00102\u001a\b\u0012\u0004\u0012\u00020-032\u0006\u00104\u001a\u000205J\u0010\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020/H\u0002J<\u0010;\u001a\b\u0012\u0004\u0012\u00020-032\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\f\u00102\u001a\b\u0012\u0004\u0012\u00020-032\u0006\u00104\u001a\u0002052\u0006\u0010<\u001a\u00020\u001fH\u0002J<\u0010=\u001a\b\u0012\u0004\u0012\u00020-032\u0006\u0010:\u001a\u00020\u00062\u0006\u0010>\u001a\u00020\u00102\u0006\u00100\u001a\u0002012\f\u00102\u001a\b\u0012\u0004\u0012\u00020-032\u0006\u00104\u001a\u000205H\u0002J\u0016\u0010?\u001a\u0002092\u0006\u0010@\u001a\u00020\u00102\u0006\u0010A\u001a\u00020\u0010J&\u0010B\u001a\u00020-2\f\u0010C\u001a\b\u0012\u0004\u0012\u00020-0,2\u0006\u0010D\u001a\u00020\u00102\u0006\u0010E\u001a\u00020-H\u0002J.\u0010F\u001a\u00020-2\f\u00102\u001a\b\u0012\u0004\u0012\u00020-032\u0006\u0010E\u001a\u00020-2\u0006\u00100\u001a\u0002012\u0006\u00104\u001a\u000205H\u0002J&\u0010G\u001a\u00020-2\u0006\u0010E\u001a\u00020-2\f\u00102\u001a\b\u0012\u0004\u0012\u00020-0,2\u0006\u00100\u001a\u000201H\u0002J0\u0010G\u001a\u00020-2\u0006\u0010E\u001a\u00020-2\b\u0010H\u001a\u0004\u0018\u00010\u00062\f\u00102\u001a\b\u0012\u0004\u0012\u00020-0,2\u0006\u00100\u001a\u000201H\u0002J.\u0010I\u001a\u00020-2\u0006\u0010:\u001a\u00020\u00062\u0006\u00100\u001a\u0002012\f\u00102\u001a\b\u0012\u0004\u0012\u00020-032\u0006\u0010J\u001a\u000205H\u0002J.\u0010K\u001a\u0002092\f\u00102\u001a\b\u0012\u0004\u0012\u00020-0,2\u0006\u0010H\u001a\u00020\u00062\u0006\u0010E\u001a\u00020-2\u0006\u00100\u001a\u000201H\u0002J\u0018\u0010L\u001a\u0002092\u0006\u0010H\u001a\u00020\u00062\u0006\u0010E\u001a\u00020-H\u0002R\"\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\"\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\b\"\u0004\b\u000e\u0010\nR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0014R\u001a\u0010\u0018\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0012\"\u0004\b\u001a\u0010\u0014R\u001a\u0010\u001b\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0012\"\u0004\b\u001d\u0010\u0014R\u001a\u0010\u001e\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010 \"\u0004\b!\u0010\"R\u001c\u0010#\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006M"}, d2={"Lorg/brailleblaster/utd/formatters/NumberedLineFormatter;", "Lorg/brailleblaster/utd/formatters/Formatter;", "<init>", "()V", "lines", "", "Lnu/xom/Element;", "getLines", "()Ljava/util/List;", "setLines", "(Ljava/util/List;)V", "lineDetails", "", "getLineDetails", "setLineDetails", "padding", "", "getPadding", "()I", "setPadding", "(I)V", "yBegin", "getYBegin", "setYBegin", "xBegin", "getXBegin", "setXBegin", "pendingLinePos", "getPendingLinePos", "setPendingLinePos", "isPending", "", "()Z", "setPending", "(Z)V", "parentLinenum", "getParentLinenum", "()Lnu/xom/Element;", "setParentLinenum", "(Lnu/xom/Element;)V", "log", "Lorg/slf4j/Logger;", "skipPoetry", "format", "", "Lorg/brailleblaster/utd/PageBuilder;", "node", "Lnu/xom/Node;", "style", "Lorg/brailleblaster/utd/IStyle;", "pageBuilders", "", "formatSelector", "Lorg/brailleblaster/utd/FormatSelector;", "lineNumbers", "formatGroup", "handleWrappedLines", "", "element", "formatImpl", "isNewLine", "formatRemainingAsLiterary", "fromIndex", "setXY", "x", "y", "getLatestPB", "results", "origSize", "pageBuilder", "readdBrl", "handleNewPage", "brl", "checkImagePlaceholder", "formatter", "handleBadPoetry", "removeBrlOnlyFromPage", "utd"})
public final class NumberedLineFormatter
extends Formatter {
    @Nullable
    private List<Element> lines;
    @Nullable
    private List<int[]> lineDetails;
    private int padding;
    private int yBegin;
    private int xBegin;
    private int pendingLinePos;
    private boolean isPending;
    @Nullable
    private Element parentLinenum;
    @NotNull
    private final Logger log;
    private boolean skipPoetry;

    public NumberedLineFormatter() {
        Logger logger = LoggerFactory.getLogger(NumberedLineFormatter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.log = logger;
    }

    @Nullable
    public final List<Element> getLines() {
        return this.lines;
    }

    public final void setLines(@Nullable List<Element> list) {
        this.lines = list;
    }

    @Nullable
    public final List<int[]> getLineDetails() {
        return this.lineDetails;
    }

    public final void setLineDetails(@Nullable List<int[]> list) {
        this.lineDetails = list;
    }

    public final int getPadding() {
        return this.padding;
    }

    public final void setPadding(int n) {
        this.padding = n;
    }

    public final int getYBegin() {
        return this.yBegin;
    }

    public final void setYBegin(int n) {
        this.yBegin = n;
    }

    public final int getXBegin() {
        return this.xBegin;
    }

    public final void setXBegin(int n) {
        this.xBegin = n;
    }

    public final int getPendingLinePos() {
        return this.pendingLinePos;
    }

    public final void setPendingLinePos(int n) {
        this.pendingLinePos = n;
    }

    public final boolean isPending() {
        return this.isPending;
    }

    public final void setPending(boolean bl) {
        this.isPending = bl;
    }

    @Nullable
    public final Element getParentLinenum() {
        return this.parentLinenum;
    }

    public final void setParentLinenum(@Nullable Element element) {
        this.parentLinenum = element;
    }

    @NotNull
    public final Set<PageBuilder> format(@NotNull Node node, @NotNull IStyle style, @NotNull Set<PageBuilder> pageBuilders, @NotNull FormatSelector formatSelector, @Nullable List<Element> lineNumbers, @Nullable List<int[]> lineDetails) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter(pageBuilders, (String)"pageBuilders");
        Intrinsics.checkNotNullParameter((Object)formatSelector, (String)"formatSelector");
        this.lines = lineNumbers;
        this.lineDetails = lineDetails;
        ((PageBuilder)CollectionsKt.last((Iterable)pageBuilders)).setPoemEnabled(true);
        return this.formatImpl(node, style, pageBuilders, formatSelector, false);
    }

    @Override
    @NotNull
    public Set<PageBuilder> format(@NotNull Node node, @NotNull IStyle style, @NotNull Set<PageBuilder> pageBuilders, @NotNull FormatSelector formatSelector) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter(pageBuilders, (String)"pageBuilders");
        Intrinsics.checkNotNullParameter((Object)formatSelector, (String)"formatSelector");
        PageBuilder pageBuilder = (PageBuilder)CollectionsKt.last((Iterable)pageBuilders);
        boolean startOfBlockState = pageBuilder.isStartOfBlock();
        pageBuilder.setStartOfBlock(true);
        this.lines = new ArrayList();
        this.lineDetails = new ArrayList();
        this.parentLinenum = null;
        this.yBegin = -1;
        this.xBegin = -1;
        this.padding = 2;
        this.pendingLinePos = -1;
        this.isPending = false;
        Set<PageBuilder> results = this.formatGroup(node, style, CollectionsKt.toMutableSet((Iterable)pageBuilders), formatSelector);
        PageBuilder lastPB = (PageBuilder)CollectionsKt.last((Iterable)results);
        lastPB.setStartOfBlock(startOfBlockState);
        List<Element> list = this.lines;
        if (list != null) {
            list.clear();
        }
        this.lines = null;
        return results;
    }

    @NotNull
    public final Set<PageBuilder> formatGroup(@NotNull Node node, @NotNull IStyle style, @NotNull Set<PageBuilder> pageBuilders, @NotNull FormatSelector formatSelector) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter(pageBuilders, (String)"pageBuilders");
        Intrinsics.checkNotNullParameter((Object)formatSelector, (String)"formatSelector");
        Set<PageBuilder> results = pageBuilders;
        if (!(node instanceof Element)) {
            return results;
        }
        PageBuilder pageBuilder = (PageBuilder)CollectionsKt.last((Iterable)results);
        int size = pageBuilders.size();
        pageBuilders.add(this.checkImagePlaceholder((Element)node, style, pageBuilders, formatSelector));
        if (pageBuilders.size() > size) {
            pageBuilder = this.handleNewPage(pageBuilder, pageBuilders, style);
        }
        int origPad = pageBuilder.getPadding();
        Align align = style.getAlign();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)align), (String)"getAlign(...)");
        pageBuilder.setAlignment(align);
        Integer linesBefore = style.getLinesBefore(node, formatSelector.styleMap.getNamespaces());
        if (linesBefore != null) {
            pageBuilder.setMaxLines(linesBefore);
        } else {
            pageBuilder.addAtLeastLinesBefore(style.getLinesBefore());
        }
        pageBuilder.setStartOfBlock(true);
        pageBuilders.add(pageBuilder);
        String string = style instanceof StyleStack ? ((IStyle)Objects.requireNonNull(((StyleStack)style).peek())).getName() : style.getName();
        Intrinsics.checkNotNull((Object)string);
        String styleName = string;
        if (!Intrinsics.areEqual((Object)styleName, (Object)"Poetic Stanza")) {
            results = this.formatImpl(node, style, pageBuilders, formatSelector, true);
            pageBuilder = (PageBuilder)CollectionsKt.last((Iterable)results);
            pageBuilder.setStartOfBlock(true);
            return results;
        }
        int n = ((Element)node).getChildCount();
        for (int i = 0; i < n; ++i) {
            IStyleMap styleMap = formatSelector.styleMap;
            Node node2 = ((Element)node).getChild(i);
            Intrinsics.checkNotNullExpressionValue((Object)node2, (String)"getChild(...)");
            IStyle curStyle = (IStyle)styleMap.findValueOrDefault(node2);
            if (style instanceof StyleStack) {
                ((StyleStack)style).push(curStyle);
            }
            if (((Element)node).getChild(i) instanceof Element) {
                Node node3 = ((Element)node).getChild(i);
                Intrinsics.checkNotNull((Object)node3, (String)"null cannot be cast to non-null type nu.xom.Element");
                if (((Element)node3).getAttribute("class") != null) {
                    Node node4 = ((Element)node).getChild(i);
                    Intrinsics.checkNotNull((Object)node4, (String)"null cannot be cast to non-null type nu.xom.Element");
                    if (Intrinsics.areEqual((Object)((Element)node4).getAttributeValue("class"), (Object)"dontsplit")) {
                        Node node5 = ((Element)node).getChild(i);
                        Intrinsics.checkNotNullExpressionValue((Object)node5, (String)"getChild(...)");
                        this.formatGroup(node5, style, pageBuilders, formatSelector);
                        continue;
                    }
                }
                size = pageBuilders.size();
                Node node6 = ((Element)node).getChild(i);
                Intrinsics.checkNotNull((Object)node6, (String)"null cannot be cast to non-null type nu.xom.Element");
                pageBuilders.add(this.checkImagePlaceholder((Element)node6, style, pageBuilders, formatSelector));
                if (pageBuilders.size() > size) {
                    pageBuilder = this.handleNewPage(pageBuilder, pageBuilders, style);
                }
            }
            Node node7 = ((Element)node).getChild(i);
            Intrinsics.checkNotNullExpressionValue((Object)node7, (String)"getChild(...)");
            this.handleWrappedLines(node7);
            int projectedPosition = pageBuilder.getY() + pageBuilder.getPendingLinesBefore();
            size = pageBuilders.size();
            Node node8 = ((Element)node).getChild(i);
            Intrinsics.checkNotNullExpressionValue((Object)node8, (String)"getChild(...)");
            results.addAll((Collection<PageBuilder>)this.formatImpl(node8, style, pageBuilders, formatSelector, true));
            if (results.size() > size) {
                pageBuilder = (PageBuilder)CollectionsKt.last((Iterable)results);
                projectedPosition = pageBuilder.getY();
            }
            pageBuilder.setStartOfBlock(true);
            if (pageBuilder.getLineNumber() != null && projectedPosition < pageBuilder.getLinesPerPage()) {
                pageBuilder.setLineNumberPos(projectedPosition);
                Element element = pageBuilder.getLineNumber();
                Intrinsics.checkNotNull((Object)element);
                pageBuilder.setLineNumberLength(element.getAttributeValue("lineNumber").length());
                pageBuilder.insertLineNumber();
            }
            if (!(style instanceof StyleStack)) continue;
            ((StyleStack)style).pop();
        }
        pageBuilder.setPadding(origPad);
        pageBuilder.setRightIndent(0);
        return results;
    }

    private final void handleWrappedLines(Node element) {
        List<Element> assBrls = UTDHelper.getDescendantBrlFast(element);
        if (assBrls.size() > 1) {
            int n = assBrls.size() - 1;
            for (int j = 0; j < n; ++j) {
                List<Element> list = this.lines;
                Intrinsics.checkNotNull(list);
                for (Element line : list) {
                    if (Intrinsics.areEqual((Object)line, (Object)assBrls.get(j))) {
                        line.addAttribute(new Attribute("continued", "true"));
                    }
                    if (!Intrinsics.areEqual((Object)line, (Object)assBrls.get(assBrls.size() - 1))) continue;
                    line.addAttribute(new Attribute("continued", "last"));
                }
                assBrls.get(j).addAttribute(new Attribute("continued", "true"));
            }
            assBrls.get(assBrls.size() - 1).addAttribute(new Attribute("continued", "last"));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Set<PageBuilder> formatImpl(Node node, IStyle style, Set<PageBuilder> pageBuilders, FormatSelector formatSelector, boolean isNewLine) {
        boolean isEmphasis;
        PageBuilder pageBuilder = (PageBuilder)CollectionsKt.last((Iterable)pageBuilders);
        if (!(node instanceof Element)) {
            return pageBuilders;
        }
        boolean isLineNum = ((Element)node).getAttribute("linenum") != null;
        ((Element)node).addAttribute(new Attribute("utd-style", "Poetry Line"));
        Align align = style.getAlign();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)align), (String)"getAlign(...)");
        pageBuilder.setAlignment(align);
        boolean bl = isEmphasis = ((Element)node).getAttribute("type", "http://brailleblaster.org/ns/utd") != null && Intrinsics.areEqual((Object)((Element)node).getAttributeValue("type", "http://brailleblaster.org/ns/utd"), (Object)"EMPHASIS");
        if (isNewLine && !isEmphasis) {
            Integer linesBefore = style.getLinesBefore(node, formatSelector.styleMap.getNamespaces());
            if (linesBefore != null) {
                pageBuilder.setMaxLines(linesBefore);
            } else {
                pageBuilder.addAtLeastLinesBefore(style.getLinesBefore());
            }
        }
        pageBuilder.setStartOfBlock(true);
        if (this.yBegin == -1 || this.xBegin == -1) {
            this.setXY(pageBuilder.getX(), pageBuilder.getY());
        }
        int i = 0;
        while (true) {
            block38: {
                block34: {
                    Element brl;
                    block36: {
                        block39: {
                            int numLength;
                            block40: {
                                block37: {
                                    block35: {
                                        if (i >= ((Element)node).getChildCount()) {
                                            return pageBuilders;
                                        }
                                        if (this.skipPoetry) {
                                            return this.formatRemainingAsLiterary((Element)node, i, style, pageBuilders, formatSelector);
                                        }
                                        if (!(((Element)node).getChild(i) instanceof Text)) break block34;
                                        brl = UTDHelper.getAssociatedBrlElement((ParentNode)node, i);
                                        pageBuilder.setPoemEnabled(true);
                                        if (brl == null) {
                                            ++i;
                                            continue;
                                        }
                                        Integer firstLineIndent = style.getFirstLineIndent();
                                        if (firstLineIndent == null) {
                                            firstLineIndent = 0;
                                        }
                                        pageBuilder.setFirstLineIndent(firstLineIndent);
                                        Integer leftIndent = style.getIndent();
                                        if (leftIndent == null) {
                                            leftIndent = 0;
                                        }
                                        pageBuilder.setLeftIndent(leftIndent);
                                        pageBuilder.setStartOfBlock(true);
                                        List<Element> list = this.lines;
                                        Intrinsics.checkNotNull(list);
                                        list.add(brl);
                                        List<int[]> list2 = this.lineDetails;
                                        Intrinsics.checkNotNull(list2);
                                        int[] nArray = new int[]{pageBuilder.getPendingLinesBefore(), firstLineIndent, leftIndent};
                                        list2.add(nArray);
                                        if (isLineNum) break block35;
                                        Element element = this.parentLinenum;
                                        if ((element != null ? element.getAttribute("linenum") : null) == null) break block36;
                                    }
                                    pageBuilder.setSkipNumberLines(NumberLinePosition.BOTH);
                                    pageBuilder.setContinueSkip(true);
                                    pageBuilder.setPadding(this.padding);
                                    numLength = 0;
                                    Element element = this.parentLinenum;
                                    if ((element != null ? element.getAttribute("linenum") : null) != null) {
                                        Element element2 = this.parentLinenum;
                                        Intrinsics.checkNotNull((Object)element2);
                                        numLength = element2.getAttributeValue("linenum").length();
                                        Element element3 = this.parentLinenum;
                                        Intrinsics.checkNotNull((Object)element3);
                                        brl.addAttribute(new Attribute("lineNumber", element3.getAttributeValue("linenum")));
                                        this.parentLinenum = null;
                                    } else {
                                        numLength = ((Element)node).getAttributeValue("linenum").length();
                                        brl.addAttribute(new Attribute("lineNumber", ((Element)node).getAttributeValue("linenum")));
                                    }
                                    if (numLength <= pageBuilder.getLineNumberLength() || numLength <= (pageBuilder.getPoemRightIndent() + this.padding) * -1) break block37;
                                    pageBuilder.setSkipNumberLines(NumberLinePosition.BOTH);
                                    pageBuilder.setContinueSkip(true);
                                    pageBuilder.setPoemRightIndent((numLength + this.padding) * -1);
                                    pageBuilder.setRightIndent(pageBuilder.getPoemRightIndent());
                                    List<Element> list = this.lines;
                                    Intrinsics.checkNotNull(list);
                                    for (Element line : list) {
                                        if (PageBuilderHelper.isSkipLinesNode((Node)line)) continue;
                                        for (PageBuilder builder : pageBuilders) {
                                            builder.removeBrl(line);
                                        }
                                    }
                                    pageBuilder.setX(this.xBegin);
                                    pageBuilder.setY(this.yBegin);
                                    pageBuilder.setLineNumberLength(numLength);
                                    pageBuilder = this.readdBrl(pageBuilders, pageBuilder, style, formatSelector);
                                    break block38;
                                }
                                if (brl.getAttribute("lineNumber") == null) break block39;
                                pageBuilder.setLineNumber(brl);
                                if (brl.getAttribute("continued") == null) break block40;
                                if (Intrinsics.areEqual((Object)brl.getAttributeValue("continued"), (Object)"true") && this.pendingLinePos != -1) {
                                    this.pendingLinePos = pageBuilder.getY();
                                    break block39;
                                } else if (Intrinsics.areEqual((Object)brl.getAttributeValue("continued"), (Object)"last") && this.pendingLinePos != -1) {
                                    pageBuilder.setLineNumberPos(this.pendingLinePos);
                                    pageBuilder.setLineNumberLength(numLength);
                                    pageBuilder.insertLineNumber();
                                    this.isPending = false;
                                    this.pendingLinePos = -1;
                                }
                                break block39;
                            }
                            if (pageBuilder.getY() + pageBuilder.getPendingLinesBefore() < pageBuilder.getLinesPerPage()) {
                                pageBuilder.setLineNumberPos(pageBuilder.getY() + pageBuilder.getPendingLinesBefore());
                                pageBuilder.setLineNumberLength(numLength);
                                pageBuilder.insertLineNumber();
                            }
                        }
                        pageBuilder.setRightIndent(pageBuilder.getPoemRightIndent());
                        int size = pageBuilders.size();
                        pageBuilders.addAll(PageBuilder.addBrl$default(pageBuilder, brl, null, 2, null));
                        if (pageBuilders.size() > size) {
                            try {
                                this.handleBadPoetry(pageBuilders, brl, pageBuilder, style);
                            }
                            catch (BadPoetryException badPoetryException) {
                                pageBuilder.removeBrl(brl);
                                pageBuilder = (PageBuilder)CollectionsKt.last((Iterable)pageBuilders);
                                pageBuilder.removeBrl(brl);
                                pageBuilder.setRightIndent(0);
                                this.skipPoetry = true;
                                return this.formatRemainingAsLiterary((Element)node, i - 1, style, pageBuilders, formatSelector);
                            }
                            pageBuilder = this.handleNewPage(pageBuilder, brl, pageBuilders, style);
                            --i;
                        }
                        break block38;
                    }
                    boolean isPageIndicator = PageBuilderHelper.isPageIndicator(brl);
                    if (isPageIndicator) {
                        int size = pageBuilders.size();
                        pageBuilders.addAll((Collection<PageBuilder>)PageBuilderHelper.handlePageIndicator(pageBuilder, brl, style, formatSelector));
                        pageBuilder = this.getLatestPB(pageBuilders, size, pageBuilder);
                    }
                    pageBuilder.setRightIndent(pageBuilder.getPoemRightIndent());
                    int size = pageBuilders.size();
                    int oldLinesBefore = pageBuilder.getPendingLinesBefore();
                    if (!isPageIndicator) {
                        pageBuilders.addAll((Collection<PageBuilder>)pageBuilder.addBrlFromChild(brl, 0));
                    }
                    if (pageBuilders.size() > size) {
                        try {
                            this.handleBadPoetry(pageBuilders, brl, pageBuilder, style);
                        }
                        catch (BadPoetryException badPoetryException) {
                            pageBuilder.removeBrl(brl);
                            pageBuilder = (PageBuilder)CollectionsKt.last((Iterable)pageBuilders);
                            pageBuilder.removeBrl(brl);
                            pageBuilder.setRightIndent(0);
                            this.skipPoetry = true;
                            return this.formatRemainingAsLiterary((Element)node, i - 1, style, pageBuilders, formatSelector);
                        }
                        pageBuilder = this.handleNewPage(pageBuilder, brl, pageBuilders, style);
                        pageBuilder.addAtLeastLinesBefore(oldLinesBefore);
                        --i;
                    }
                    break block38;
                }
                if (((Element)node).getChild(i) instanceof Element) {
                    Node node2 = ((Element)node).getChild(i);
                    Intrinsics.checkNotNull((Object)node2, (String)"null cannot be cast to non-null type nu.xom.Element");
                    if (((Element)node2).getAttribute("class") != null) {
                        Node node3 = ((Element)node).getChild(i);
                        Intrinsics.checkNotNull((Object)node3, (String)"null cannot be cast to non-null type nu.xom.Element");
                        if (Intrinsics.areEqual((Object)((Element)node3).getAttributeValue("class"), (Object)"dontsplit")) {
                            Node node4 = ((Element)node).getChild(i);
                            Intrinsics.checkNotNullExpressionValue((Object)node4, (String)"getChild(...)");
                            this.formatGroup(node4, style, pageBuilders, formatSelector);
                            ++i;
                            continue;
                        }
                    }
                    int size = pageBuilders.size();
                    Node node5 = ((Element)node).getChild(i);
                    Intrinsics.checkNotNull((Object)node5, (String)"null cannot be cast to non-null type nu.xom.Element");
                    pageBuilders.add(this.checkImagePlaceholder((Element)node5, style, pageBuilders, formatSelector));
                    if (pageBuilders.size() > size) {
                        pageBuilder = this.handleNewPage(pageBuilder, pageBuilders, style);
                    }
                    IStyleMap styleMap = formatSelector.styleMap;
                    Node node6 = ((Element)node).getChild(i);
                    Intrinsics.checkNotNullExpressionValue((Object)node6, (String)"getChild(...)");
                    IStyle curStyle = (IStyle)styleMap.findValueOrDefault(node6);
                    if (!UTDElements.BRL.isA(((Element)node).getChild(i))) {
                        if (isLineNum) {
                            this.parentLinenum = (Element)node;
                        }
                        Intrinsics.checkNotNull((Object)style, (String)"null cannot be cast to non-null type org.brailleblaster.utd.StyleStack");
                        ((StyleStack)style).push(curStyle);
                        Node node7 = ((Element)node).getChild(i);
                        Intrinsics.checkNotNullExpressionValue((Object)node7, (String)"getChild(...)");
                        pageBuilders.addAll((Collection<PageBuilder>)this.format(node7, style, pageBuilders, formatSelector, this.lines, this.lineDetails));
                        if (pageBuilders.size() > 1) {
                            pageBuilder = (PageBuilder)CollectionsKt.last((Iterable)pageBuilders);
                            pageBuilder.setStartOfBlock(true);
                        }
                        ((StyleStack)style).pop();
                        this.parentLinenum = null;
                    }
                }
            }
            ++i;
        }
    }

    private final Set<PageBuilder> formatRemainingAsLiterary(Element element, int fromIndex, IStyle style, Set<PageBuilder> pageBuilders, FormatSelector formatSelector) {
        Set<PageBuilder> pages = pageBuilders;
        Formatter formatter = new LiteraryFormatter();
        int n = element.getChildCount();
        for (int i = Math.max(fromIndex, 0); i < n; ++i) {
            Node node = element.getChild(i);
            Intrinsics.checkNotNullExpressionValue((Object)node, (String)"getChild(...)");
            pages = formatter.format(node, style, pages, formatSelector);
        }
        return pages;
    }

    public final void setXY(int x, int y) {
        this.xBegin = x;
        this.yBegin = y;
    }

    private final PageBuilder getLatestPB(Set<PageBuilder> results, int origSize, PageBuilder pageBuilder) {
        if (results.size() > origSize) {
            List<Element> list = this.lines;
            Intrinsics.checkNotNull(list);
            list.clear();
            List<int[]> list2 = this.lineDetails;
            Intrinsics.checkNotNull(list2);
            list2.clear();
            return (PageBuilder)CollectionsKt.last((Iterable)results);
        }
        return pageBuilder;
    }

    private final PageBuilder readdBrl(Set<PageBuilder> pageBuilders, PageBuilder pageBuilder, IStyle style, FormatSelector formatSelector) {
        PageBuilder pageBuilder2 = pageBuilder;
        int j = 0;
        while (true) {
            List<Element> list = this.lines;
            Intrinsics.checkNotNull(list);
            if (j >= list.size()) break;
            List<Element> list2 = this.lines;
            Intrinsics.checkNotNull(list2);
            if (PageBuilderHelper.isSkipLinesNode((Node)list2.get(j))) {
                List<Element> list3 = this.lines;
                Intrinsics.checkNotNull(list3);
                pageBuilders.add(this.checkImagePlaceholder(list3.get(j), style, pageBuilders, formatSelector));
                if (pageBuilders.size() > 1) {
                    pageBuilder2 = this.handleNewPage(pageBuilder2, pageBuilders, style);
                }
                ++j;
                continue;
            }
            int size = pageBuilders.size();
            List<int[]> list4 = this.lineDetails;
            Intrinsics.checkNotNull(list4);
            pageBuilder2.addAtLeastLinesBefore(list4.get(j)[0]);
            List<int[]> list5 = this.lineDetails;
            Intrinsics.checkNotNull(list5);
            pageBuilder2.setFirstLineIndent(list5.get(j)[1]);
            List<int[]> list6 = this.lineDetails;
            Intrinsics.checkNotNull(list6);
            pageBuilder2.setLeftIndent(list6.get(j)[2]);
            pageBuilder2.setStartOfBlock(true);
            pageBuilders.addAll((Collection<PageBuilder>)pageBuilder2.processSpacing());
            if (pageBuilders.size() > size) {
                List<Element> lineNums = pageBuilder2.getLineNums();
                for (Element element : lineNums) {
                    pageBuilder2.removeFormattingElement(element);
                }
                int oldRI = pageBuilder2.getPoemRightIndent();
                pageBuilder2 = (PageBuilder)CollectionsKt.last((Iterable)pageBuilders);
                pageBuilder2.setStartOfBlock(true);
                pageBuilder2.setPoemRightIndent(oldRI);
                List<int[]> list7 = this.lineDetails;
                Intrinsics.checkNotNull(list7);
                pageBuilder2.setFirstLineIndent(list7.get(j)[1]);
                List<int[]> list8 = this.lineDetails;
                Intrinsics.checkNotNull(list8);
                pageBuilder2.setLeftIndent(list8.get(j)[2]);
                List<int[]> list9 = this.lineDetails;
                Intrinsics.checkNotNull(list9);
                if (list9.get(j)[0] > 1) {
                    pageBuilder2.addAtLeastLinesBefore(1);
                }
                this.setXY(0, pageBuilder2.getY());
            }
            boolean topOfPage = false;
            if (pageBuilder2.getY() == 0 && pageBuilder2.isSkipTop()) {
                pageBuilder2.moveY(pageBuilder2.getLineSpacing(), true);
                topOfPage = true;
            }
            pageBuilder2.setRightIndent(pageBuilder2.getPoemRightIndent());
            List<Element> lineNums = pageBuilder2.getLineNums();
            List<Element> list10 = this.lines;
            Intrinsics.checkNotNull(list10);
            if (list10.get(j).getAttribute("lineNumber") != null) {
                for (Element lineNum2 : lineNums) {
                    String string = lineNum2.getValue();
                    List<Element> list11 = this.lines;
                    Intrinsics.checkNotNull(list11);
                    if (!Intrinsics.areEqual((Object)string, (Object)list11.get(j).getAttributeValue("lineNumber"))) continue;
                    pageBuilder2.removeFormattingElement(lineNum2);
                }
                List<Element> list12 = this.lines;
                Intrinsics.checkNotNull(list12);
                if (list12.get(j).getAttribute("continued") != null) {
                    this.pendingLinePos = pageBuilder2.getY() + pageBuilder2.getPendingLinesBefore();
                    this.isPending = true;
                }
                List<Element> list13 = this.lines;
                Intrinsics.checkNotNull(list13);
                pageBuilder2.setLineNumber(list13.get(j));
                pageBuilder2.setLineNumberPos(pageBuilder2.getY() + pageBuilder2.getPendingLinesBefore());
            }
            size = pageBuilders.size();
            List<Element> list14 = this.lines;
            Intrinsics.checkNotNull(list14);
            boolean bl = PageBuilderHelper.isPageIndicator(list14.get(j));
            if (bl) {
                List<Element> list15 = this.lines;
                Intrinsics.checkNotNull(list15);
                pageBuilders.addAll((Collection<PageBuilder>)PageBuilderHelper.handlePageIndicator(pageBuilder2, list15.get(j), style, formatSelector));
                pageBuilder2 = this.getLatestPB(pageBuilders, size, pageBuilder2);
            } else {
                List<Element> list16 = this.lines;
                Intrinsics.checkNotNull(list16);
                pageBuilders.addAll(PageBuilder.addBrl$default(pageBuilder2, list16.get(j), null, 2, null));
            }
            List<Element> list17 = this.lines;
            Intrinsics.checkNotNull(list17);
            if (list17.get(j).getAttribute("continued") != null) {
                List<Element> list18 = this.lines;
                Intrinsics.checkNotNull(list18);
                if (Intrinsics.areEqual((Object)list18.get(j).getAttributeValue("continued"), (Object)"last") && this.pendingLinePos != -1) {
                    pageBuilder2.setLineNumberPos(this.pendingLinePos);
                    this.isPending = false;
                    this.pendingLinePos = -1;
                }
            }
            if (!this.isPending) {
                pageBuilder2.insertLineNumber();
            }
            if (pageBuilders.size() > size) {
                if (topOfPage) {
                    this.log.warn("Potential formatting issue on print page {}", (Object)pageBuilder2.getPrintPageNumber());
                    ++j;
                    continue;
                }
                List<Element> list19 = this.lines;
                Intrinsics.checkNotNull(list19);
                Element brlCopy = list19.get(j);
                Element lastBrlOnly = null;
                lineNums = pageBuilder2.getLineNums();
                if (!((Collection)lineNums).isEmpty()) {
                    lastBrlOnly = (Element)CollectionsKt.last(pageBuilder2.getLineNums());
                }
                while (j > 0) {
                    List<Element> list20 = this.lines;
                    Intrinsics.checkNotNull(list20);
                    list20.remove(0);
                    List<int[]> list21 = this.lineDetails;
                    Intrinsics.checkNotNull(list21);
                    list21.remove(0);
                    --j;
                }
                pageBuilder2.removeBrl(brlCopy);
                if (lastBrlOnly != null) {
                    pageBuilder2.removeFormattingElement(lastBrlOnly);
                }
                int oldRI = pageBuilder2.getPoemRightIndent();
                pageBuilder2 = (PageBuilder)CollectionsKt.last((Iterable)pageBuilders);
                pageBuilder2.setStartOfBlock(true);
                pageBuilder2.removeBrl(brlCopy);
                if (lastBrlOnly != null) {
                    pageBuilder2.removeFormattingElement(lastBrlOnly);
                }
                pageBuilder2.setPoemRightIndent(oldRI);
                pageBuilder2.setRightIndent(pageBuilder2.getPoemRightIndent());
                List<int[]> list22 = this.lineDetails;
                Intrinsics.checkNotNull(list22);
                pageBuilder2.setFirstLineIndent(list22.get(j)[1]);
                List<int[]> list23 = this.lineDetails;
                Intrinsics.checkNotNull(list23);
                pageBuilder2.setLeftIndent(list23.get(j)[2]);
                this.setXY(0, pageBuilder2.getY());
                List<Element> list24 = this.lines;
                Intrinsics.checkNotNull(list24);
                if (list24.get(j).getAttribute("continued") != null) {
                    List<Element> list25 = this.lines;
                    Intrinsics.checkNotNull(list25);
                    if (Intrinsics.areEqual((Object)list25.get(j).getAttributeValue("continued"), (Object)"last") && this.pendingLinePos != -1) {
                        pageBuilder2.setLineNumberPos(this.pendingLinePos);
                        this.isPending = false;
                        this.pendingLinePos = -1;
                    }
                }
                if (!this.isPending) {
                    pageBuilder2.insertLineNumber();
                }
                j = -1;
            }
            ++j;
        }
        return pageBuilder2;
    }

    private final PageBuilder handleNewPage(PageBuilder pageBuilder, Set<PageBuilder> pageBuilders, IStyle style) {
        return this.handleNewPage(pageBuilder, null, pageBuilders, style);
    }

    private final PageBuilder handleNewPage(PageBuilder pageBuilder, Element brl, Set<PageBuilder> pageBuilders, IStyle style) {
        PageBuilder pageBuilder2 = pageBuilder;
        List<Element> list = this.lines;
        Intrinsics.checkNotNull(list);
        list.clear();
        List<int[]> list2 = this.lineDetails;
        Intrinsics.checkNotNull(list2);
        list2.clear();
        if (brl != null) {
            pageBuilder2.removeBrl(brl);
            this.removeBrlOnlyFromPage(brl, pageBuilder2);
        }
        int oldRI = pageBuilder2.getPoemRightIndent();
        NumberLinePosition oldSkip = pageBuilder2.getSkipNumberLines();
        pageBuilder2 = (PageBuilder)CollectionsKt.last((Iterable)pageBuilders);
        pageBuilder2.setPoemRightIndent(oldRI);
        pageBuilder2.setRightIndent(pageBuilder2.getPoemRightIndent());
        pageBuilder2.setFirstLineIndent(style.getFirstLineIndent());
        Integer leftIndent = style.getIndent();
        if (leftIndent == null) {
            leftIndent = 0;
        }
        pageBuilder2.setLeftIndent(leftIndent);
        if (brl != null) {
            pageBuilder2.removeBrl(brl);
        }
        this.setXY(0, pageBuilder2.getY());
        pageBuilder2.setSkipNumberLines(oldSkip);
        return pageBuilder2;
    }

    private final PageBuilder checkImagePlaceholder(Element element, IStyle style, Set<PageBuilder> pageBuilders, FormatSelector formatter) {
        Set<PageBuilder> pageBuilders2 = pageBuilders;
        if (PageBuilderHelper.isSkipLinesNode((Node)element)) {
            List<Element> list = this.lines;
            Intrinsics.checkNotNull(list);
            boolean add = list.stream().noneMatch(arg_0 -> NumberedLineFormatter.checkImagePlaceholder$lambda$1(arg_0 -> NumberedLineFormatter.checkImagePlaceholder$lambda$0(element, arg_0), arg_0));
            if (add) {
                List<Element> list2 = this.lines;
                Intrinsics.checkNotNull(list2);
                list2.add(element);
                List<int[]> list3 = this.lineDetails;
                Intrinsics.checkNotNull(list3);
                int[] nArray = new int[]{0, 0, 0};
                list3.add(nArray);
            }
            pageBuilders2 = PageBuilderHelper.INSTANCE.applySkipLinesNode(element, style, pageBuilders2, formatter);
            PageBuilder pageBuilder = (PageBuilder)CollectionsKt.last((Iterable)pageBuilders2);
            pageBuilders2.addAll((Collection<PageBuilder>)pageBuilder.processSpacing());
        }
        return (PageBuilder)CollectionsKt.last((Iterable)pageBuilders2);
    }

    private final void handleBadPoetry(Set<PageBuilder> pageBuilders, Element brl, PageBuilder pageBuilder, IStyle style) throws BadPoetryException {
        PageBuilder testPB = pageBuilder;
        int oldRI = testPB.getPoemRightIndent();
        int lines = testPB.getPendingLinesBefore();
        NumberLinePosition oldSkip = pageBuilder.getSkipNumberLines();
        testPB = (PageBuilder)CollectionsKt.last((Iterable)pageBuilders);
        testPB.removeBrl(brl);
        if (testPB.isBlankPageWithPageNumbers()) {
            testPB.setPoemRightIndent(oldRI);
            testPB.setRightIndent(testPB.getPoemRightIndent());
            testPB.setFirstLineIndent(style.getFirstLineIndent());
            Integer leftIndent = style.getIndent();
            if (leftIndent == null) {
                leftIndent = 0;
            }
            testPB.setLeftIndent(leftIndent);
            testPB.setY(testPB.findLastBlankLine() > 0 ? testPB.findLastBlankLine() - 1 : testPB.findLastBlankLine());
            this.setXY(0, testPB.getY());
            testPB.setSkipNumberLines(oldSkip);
            testPB.addAtLeastLinesBefore(lines);
            if (PageBuilder.addBrl$default(testPB, brl, null, 2, null).size() > 1) {
                throw new BadPoetryException();
            }
        }
    }

    private final void removeBrlOnlyFromPage(Element brl, PageBuilder pageBuilder) {
        ParentNode parentNode = brl.getParent();
        Intrinsics.checkNotNull((Object)parentNode, (String)"null cannot be cast to non-null type nu.xom.Element");
        Element parent = (Element)parentNode;
        List<Element> lineNums = pageBuilder.getLineNums();
        for (Element lineNum : lineNums) {
            if (parent.getAttribute("linenum") == null || !Intrinsics.areEqual((Object)parent.getAttributeValue("linenum"), (Object)lineNum.getValue())) continue;
            pageBuilder.removeFormattingElement(lineNum);
        }
    }

    private static final boolean checkImagePlaceholder$lambda$0(Element $element, Element line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        return Intrinsics.areEqual((Object)line, (Object)$element);
    }

    private static final boolean checkImagePlaceholder$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

