/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.utd.formatters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import nu.xom.Text;
import org.brailleblaster.utd.FormatSelector;
import org.brailleblaster.utd.IStyle;
import org.brailleblaster.utd.IStyleMap;
import org.brailleblaster.utd.PageBuilder;
import org.brailleblaster.utd.StyleStack;
import org.brailleblaster.utd.formatters.Formatter;
import org.brailleblaster.utd.properties.Align;
import org.brailleblaster.utd.properties.UTDElements;
import org.brailleblaster.utd.utils.PageBuilderHelper;
import org.brailleblaster.utd.utils.UTDHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u000b\u0018\u0000 >2\u00020\u0001:\u0001>B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JR\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020#0)2\u0006\u0010*\u001a\u00020+2\u000e\u0010,\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u0005J4\u0010!\u001a\b\u0012\u0004\u0012\u00020#0)2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010*\u001a\u00020+H\u0016J4\u0010-\u001a\b\u0012\u0004\u0012\u00020#0)2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020#0)2\u0006\u0010*\u001a\u00020+H\u0002J4\u0010.\u001a\b\u0012\u0004\u0012\u00020#0)2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020#0)2\u0006\u0010*\u001a\u00020+H\u0002J6\u0010/\u001a\u00020#2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020#0)2\u0006\u00100\u001a\u00020#2\u0006\u0010&\u001a\u00020'2\u0006\u0010*\u001a\u00020+2\u0006\u00101\u001a\u00020\u000eH\u0002J\u0016\u00102\u001a\u00020#2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020#0\"H\u0002J\u0018\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u000e2\u0006\u00106\u001a\u00020\u000eH\u0002J\u0010\u00107\u001a\u00020\u00192\u0006\u00108\u001a\u00020\u0006H\u0002J&\u00109\u001a\u00020#2\f\u0010:\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010;\u001a\u00020\u000e2\u0006\u0010<\u001a\u00020#H\u0002J\u0018\u0010=\u001a\u00020'2\u0006\u0010*\u001a\u00020+2\u0006\u0010$\u001a\u00020%H\u0002R\"\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0010\"\u0004\b \u0010\u0012\u00a8\u0006?"}, d2={"Lorg/brailleblaster/utd/formatters/NumberedProseFormatter;", "Lorg/brailleblaster/utd/formatters/Formatter;", "<init>", "()V", "lines", "", "Lnu/xom/Element;", "getLines", "()Ljava/util/List;", "setLines", "(Ljava/util/List;)V", "lineDetails", "", "padding", "", "getPadding", "()I", "setPadding", "(I)V", "yBegin", "xBegin", "currLineNum", "", "firstAdd", "spaced", "", "getSpaced", "()Z", "setSpaced", "(Z)V", "spaces", "getSpaces", "setSpaces", "format", "", "Lorg/brailleblaster/utd/PageBuilder;", "node", "Lnu/xom/Node;", "style", "Lorg/brailleblaster/utd/IStyle;", "pageBuilders", "", "formatSelector", "Lorg/brailleblaster/utd/FormatSelector;", "lineNumbers", "formatDiv", "formatImpl", "readd", "pb", "rightIndent", "remove", "setXY", "", "x", "y", "isLineNum", "element", "getLatestPB", "results", "origSize", "pageBuilder", "findStyle", "Companion", "utd"})
public final class NumberedProseFormatter
extends Formatter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private List<Element> lines;
    @Nullable
    private List<int[]> lineDetails;
    private int padding;
    private int yBegin;
    private int xBegin;
    @Nullable
    private String currLineNum;
    private int firstAdd;
    private boolean spaced;
    private int spaces;

    @Nullable
    public final List<Element> getLines() {
        return this.lines;
    }

    public final void setLines(@Nullable List<Element> list) {
        this.lines = list;
    }

    public final int getPadding() {
        return this.padding;
    }

    public final void setPadding(int n) {
        this.padding = n;
    }

    public final boolean getSpaced() {
        return this.spaced;
    }

    public final void setSpaced(boolean bl) {
        this.spaced = bl;
    }

    public final int getSpaces() {
        return this.spaces;
    }

    public final void setSpaces(int n) {
        this.spaces = n;
    }

    @NotNull
    public final Set<PageBuilder> format(@NotNull Node node, @NotNull IStyle style, @NotNull Set<PageBuilder> pageBuilders, @NotNull FormatSelector formatSelector, @Nullable List<Element> lineNumbers, @Nullable List<int[]> lineDetails) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter(pageBuilders, (String)"pageBuilders");
        Intrinsics.checkNotNullParameter((Object)formatSelector, (String)"formatSelector");
        this.lines = lineNumbers;
        this.lineDetails = lineDetails;
        return this.formatImpl(node, style, pageBuilders, formatSelector);
    }

    @Override
    @NotNull
    public Set<PageBuilder> format(@NotNull Node node, @NotNull IStyle style, @NotNull Set<PageBuilder> pageBuilders, @NotNull FormatSelector formatSelector) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter(pageBuilders, (String)"pageBuilders");
        Intrinsics.checkNotNullParameter((Object)formatSelector, (String)"formatSelector");
        PageBuilder pageBuilder = (PageBuilder)CollectionsKt.last((Iterable)pageBuilders);
        boolean startOfBlockState = pageBuilder.isStartOfBlock();
        pageBuilder.setStartOfBlock(true);
        this.lines = new ArrayList();
        this.lineDetails = new ArrayList();
        this.yBegin = -1;
        this.xBegin = -1;
        this.padding = 2;
        this.firstAdd = -1;
        this.currLineNum = "";
        this.spaced = false;
        this.spaces = 0;
        Set<PageBuilder> results = this.formatDiv(node, style, CollectionsKt.toMutableSet((Iterable)pageBuilders), formatSelector);
        PageBuilder lastPB = (PageBuilder)CollectionsKt.last((Iterable)results);
        lastPB.setStartOfBlock(startOfBlockState);
        return results;
    }

    private final Set<PageBuilder> formatDiv(Node node, IStyle style, Set<PageBuilder> pageBuilders, FormatSelector formatSelector) {
        Set<PageBuilder> results = pageBuilders;
        if (!(node instanceof Element)) {
            return results;
        }
        int n = ((Element)node).getChildCount();
        for (int i = 0; i < n; ++i) {
            PageBuilder pageBuilder = (PageBuilder)CollectionsKt.last((Iterable)pageBuilders);
            pageBuilder.setStartOfBlock(true);
            IStyleMap styleMap = formatSelector.styleMap;
            Node node2 = ((Element)node).getChild(i);
            Intrinsics.checkNotNullExpressionValue((Object)node2, (String)"getChild(...)");
            IStyle curStyle = (IStyle)styleMap.findValueOrDefault(node2);
            Intrinsics.checkNotNull((Object)style, (String)"null cannot be cast to non-null type org.brailleblaster.utd.StyleStack");
            ((StyleStack)style).push(curStyle);
            Node node3 = ((Element)node).getChild(i);
            Intrinsics.checkNotNullExpressionValue((Object)node3, (String)"getChild(...)");
            results = this.formatImpl(node3, style, pageBuilders, formatSelector);
            ((StyleStack)style).pop();
        }
        return results;
    }

    private final Set<PageBuilder> formatImpl(Node node, IStyle style, Set<PageBuilder> pageBuilders, FormatSelector formatSelector) {
        PageBuilder pageBuilder = (PageBuilder)CollectionsKt.last((Iterable)pageBuilders);
        if (!(node instanceof Element)) {
            return pageBuilders;
        }
        pageBuilder.setSkipNumberLines(style.getSkipNumberLines());
        pageBuilder.setContinueSkip(true);
        Align align = style.getAlign();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)align), (String)"getAlign(...)");
        pageBuilder.setAlignment(align);
        Integer linesBefore = style.getLinesBefore(node, formatSelector.styleMap.getNamespaces());
        if (linesBefore != null) {
            pageBuilder.setMaxLines(linesBefore);
        } else {
            pageBuilder.addAtLeastLinesBefore(style.getLinesBefore());
        }
        int size = pageBuilders.size();
        int firstLineIndent = org.brailleblaster.utd.formatters.NumberedProseFormatter$Companion.safeUnbox$default(Companion, style.getFirstLineIndent(), 0, 2, null);
        pageBuilder.setFirstLineIndent(firstLineIndent);
        int leftIndent = NumberedProseFormatter.Companion.safeUnbox(style.getIndent(), 0);
        pageBuilder.setLeftIndent(leftIndent);
        pageBuilders.addAll((Collection<PageBuilder>)pageBuilder.processSpacing());
        if (pageBuilders.size() > 1) {
            pageBuilder = this.getLatestPB(pageBuilders, size, pageBuilder);
            pageBuilder.setSkipNumberLines(style.getSkipNumberLines());
            pageBuilder.setContinueSkip(true);
        }
        if (this.yBegin == -1 || this.xBegin == -1) {
            this.setXY(firstLineIndent, pageBuilder.getY());
        }
        int n = ((Element)node).getChildCount();
        for (int i = 0; i < n; ++i) {
            if (((Element)node).getChild(i) instanceof Text) {
                Element brl;
                boolean isPageIndicator;
                if (UTDHelper.getAssociatedBrlElement((ParentNode)node, i) == null) continue;
                if (pageBuilder.getX() == pageBuilder.getCellsPerLine() + pageBuilder.getRightIndent()) {
                    pageBuilder.setPendingSpaces(1);
                    pageBuilders.addAll((Collection<PageBuilder>)pageBuilder.processSpacing());
                    if (pageBuilders.size() > 1) {
                        List<Element> list = this.lines;
                        Intrinsics.checkNotNull(list);
                        list.clear();
                        List<int[]> list2 = this.lineDetails;
                        Intrinsics.checkNotNull(list2);
                        list2.clear();
                        pageBuilder = (PageBuilder)CollectionsKt.last((Iterable)pageBuilders);
                        pageBuilder.setSkipNumberLines(style.getSkipNumberLines());
                        pageBuilder.setContinueSkip(true);
                    }
                }
                if (isPageIndicator = PageBuilderHelper.isPageIndicator(brl)) {
                    size = pageBuilders.size();
                    pageBuilders.addAll((Collection<PageBuilder>)PageBuilderHelper.handlePageIndicator(pageBuilder, brl, style, formatSelector));
                    pageBuilder = this.getLatestPB(pageBuilders, size, pageBuilder);
                    pageBuilder.setSkipNumberLines(style.getSkipNumberLines());
                    pageBuilder.setContinueSkip(true);
                    continue;
                }
                int spaceCount = 0;
                if (this.spaced && pageBuilder.getPendingLinesBefore() < 1 && !pageBuilder.checkBlankBefore()) {
                    int totalSpaces = 3 - this.spaces;
                    PageBuilder pageBuilder2 = pageBuilder;
                    pageBuilder2.setX(pageBuilder2.getX() + totalSpaces);
                    this.spaced = false;
                    spaceCount = this.spaces;
                } else if (this.spaced) {
                    this.spaced = false;
                    this.spaces = 0;
                }
                List<Element> list = this.lines;
                Intrinsics.checkNotNull(list);
                list.add(brl);
                List<int[]> list3 = this.lineDetails;
                Intrinsics.checkNotNull(list3);
                int[] totalSpaces = new int[]{0, pageBuilder.getPendingLinesBefore(), spaceCount, pageBuilder.isStartOfBlock() ? 1 : 0};
                list3.add(totalSpaces);
                pageBuilders.addAll(PageBuilder.addBrl$default(pageBuilder, brl, null, 2, null));
                if (pageBuilders.size() <= 1) continue;
                List<Element> list4 = this.lines;
                Intrinsics.checkNotNull(list4);
                list4.clear();
                List<int[]> list5 = this.lineDetails;
                Intrinsics.checkNotNull(list5);
                list5.clear();
                pageBuilder = (PageBuilder)CollectionsKt.last((Iterable)pageBuilders);
                pageBuilder.setSkipNumberLines(style.getSkipNumberLines());
                pageBuilder.setContinueSkip(true);
                this.setXY(leftIndent, pageBuilder.getY());
                continue;
            }
            if (!(((Element)node).getChild(i) instanceof Element)) continue;
            IStyleMap styleMap = formatSelector.styleMap;
            Node node2 = ((Element)node).getChild(i);
            Intrinsics.checkNotNullExpressionValue((Object)node2, (String)"getChild(...)");
            IStyle curStyle = (IStyle)styleMap.findValueOrDefault(node2);
            Intrinsics.checkNotNull((Object)style, (String)"null cannot be cast to non-null type org.brailleblaster.utd.StyleStack");
            ((StyleStack)style).push(curStyle);
            Node node3 = ((Element)node).getChild(i);
            Intrinsics.checkNotNull((Object)node3, (String)"null cannot be cast to non-null type nu.xom.Element");
            if (this.isLineNum((Element)node3)) {
                Object object;
                Node node4 = ((Element)node).getChild(i);
                Intrinsics.checkNotNull((Object)node4, (String)"null cannot be cast to non-null type nu.xom.Element");
                Element lineNum = (Element)node4;
                String newLineNum = lineNum.getAttributeValue("linenum");
                boolean yDown = false;
                if (!pageBuilder.setLineNumberPos(pageBuilder.getY())) {
                    if (pageBuilder.getY() + 1 == pageBuilder.getLinesPerPage()) {
                        pageBuilder.addAtLeastPages(1);
                        pageBuilder = (PageBuilder)CollectionsKt.last((Iterable)pageBuilder.processSpacing());
                        pageBuilder.setLineNumberPos(1);
                    } else {
                        object = pageBuilder;
                        ((PageBuilder)object).setY(((PageBuilder)object).getY() + 1);
                        pageBuilder.setLineNumberPos(pageBuilder.getLineNumberPos() + 1);
                        yDown = true;
                    }
                    pageBuilder.setX(leftIndent);
                }
                if (pageBuilder.getX() + 3 < pageBuilder.getCellsPerLine() + pageBuilder.getRightIndent() && pageBuilder.getX() > pageBuilder.getLeftIndent() && this.firstAdd < 1) {
                    if (lineNum.getAttribute("space") != null) {
                        String string = lineNum.getAttributeValue("space");
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAttributeValue(...)");
                        this.spaces = Integer.parseInt(string);
                    }
                    this.spaced = true;
                } else if (this.firstAdd < 1) {
                    this.spaces = 0;
                    this.spaced = false;
                    if (!yDown) {
                        pageBuilder.setLineNumberPos(pageBuilder.getY() + pageBuilder.getLineSpacing());
                    }
                }
                if (this.firstAdd == -1) {
                    this.firstAdd = 1;
                } else if (this.firstAdd == 1) {
                    this.firstAdd = 0;
                }
                List<Element> list = this.lines;
                Intrinsics.checkNotNull(list);
                Intrinsics.checkNotNull((Object)newLineNum);
                list.add(pageBuilder.insertLineNumber(newLineNum));
                List<int[]> list6 = this.lineDetails;
                Intrinsics.checkNotNull(list6);
                object = new int[4];
                object[0] = pageBuilder.getLineNumberPos();
                object[1] = pageBuilder.getPendingLinesBefore();
                String string = lineNum.getAttributeValue("space");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAttributeValue(...)");
                object[2] = Integer.parseInt(string);
                object[3] = pageBuilder.isStartOfBlock();
                list6.add((int[])object);
                pageBuilders.add(pageBuilder);
                int rightIndent = (newLineNum.length() + this.padding) * -1;
                int n2 = newLineNum.length();
                String string2 = this.currLineNum;
                Intrinsics.checkNotNull((Object)string2);
                if (n2 > string2.length()) {
                    pageBuilder = this.remove(pageBuilders);
                    pageBuilder = this.readd(pageBuilders, pageBuilder, style, formatSelector, rightIndent);
                    this.currLineNum = newLineNum;
                }
            } else if (!UTDElements.BRL.isA(((Element)node).getChild(i))) {
                size = pageBuilders.size();
                Node node5 = ((Element)node).getChild(i);
                Intrinsics.checkNotNullExpressionValue((Object)node5, (String)"getChild(...)");
                pageBuilders.addAll((Collection<PageBuilder>)this.format(node5, style, pageBuilders, formatSelector, this.lines, this.lineDetails));
                if (pageBuilders.size() > size) {
                    pageBuilder = (PageBuilder)CollectionsKt.last((Iterable)pageBuilders);
                    pageBuilder.setSkipNumberLines(((StyleStack)style).getSkipNumberLines());
                    pageBuilder.setContinueSkip(true);
                }
            }
            ((StyleStack)style).pop();
        }
        return pageBuilders;
    }

    private final PageBuilder readd(Set<PageBuilder> pageBuilders, PageBuilder pb, IStyle style, FormatSelector formatSelector, int rightIndent) {
        PageBuilder pageBuilder = pb;
        pageBuilder.setRightIndent(rightIndent);
        pageBuilder.setX(this.xBegin);
        pageBuilder.setY(this.yBegin);
        List<Element> list = this.lines;
        Intrinsics.checkNotNull(list);
        int n = ((Collection)list).size();
        for (int i = 0; i < n; ++i) {
            if (pageBuilder.getX() != pageBuilder.getLeftIndent() && i < 1) {
                this.spaced = true;
            }
            List<Element> list2 = this.lines;
            Intrinsics.checkNotNull(list2);
            if (UTDElements.BRL.isA((Node)list2.get(i))) {
                if (i - 1 >= 0) {
                    List<Element> list3 = this.lines;
                    Intrinsics.checkNotNull(list3);
                    if (UTDElements.BRL.isA((Node)list3.get(i - 1))) {
                        this.spaced = false;
                    }
                }
                List<Element> list4 = this.lines;
                Intrinsics.checkNotNull(list4);
                Node node = UTDHelper.getAssociatedNode(list4.get(i));
                Intrinsics.checkNotNull((Object)node);
                ParentNode parentNode = node.getParent();
                Intrinsics.checkNotNullExpressionValue((Object)parentNode, (String)"getParent(...)");
                IStyle curStyle = this.findStyle(formatSelector, (Node)parentNode);
                List<int[]> list5 = this.lineDetails;
                Intrinsics.checkNotNull(list5);
                if (list5.get(i)[3] == 1 && !pageBuilder.isEmptyFormattingLine()) {
                    pageBuilder.addAtLeastLinesBefore(curStyle.getLinesBefore());
                    pageBuilder.setStartOfBlock(true);
                    pageBuilder.setFirstLineIndent(curStyle.getFirstLineIndent());
                    pageBuilder.setLeftIndent(NumberedProseFormatter.Companion.safeUnbox(curStyle.getIndent(), 0));
                    if (pageBuilders.size() > 1) {
                        List<Element> list6 = this.lines;
                        Intrinsics.checkNotNull(list6);
                        list6.clear();
                        List<int[]> list7 = this.lineDetails;
                        Intrinsics.checkNotNull(list7);
                        list7.clear();
                        pageBuilder = (PageBuilder)CollectionsKt.last((Iterable)pageBuilders);
                        pageBuilder.setSkipNumberLines(style.getSkipNumberLines());
                        pageBuilder.setContinueSkip(true);
                    }
                }
                if (this.spaced && pageBuilder.getPendingLinesBefore() < 1 && i > 1 && !pageBuilder.checkBlankBefore()) {
                    int totalSpaces = 3 - this.spaces;
                    PageBuilder pageBuilder2 = pageBuilder;
                    pageBuilder2.setX(pageBuilder2.getX() + totalSpaces);
                    this.spaced = false;
                }
                List<Element> list8 = this.lines;
                Intrinsics.checkNotNull(list8);
                pageBuilders.addAll(PageBuilder.addBrl$default(pageBuilder, list8.get(i), null, 2, null));
                if (pageBuilders.size() <= 1) continue;
                pageBuilder = (PageBuilder)CollectionsKt.last((Iterable)pageBuilders);
                pageBuilder.setSkipNumberLines(style.getSkipNumberLines());
                pageBuilder.setContinueSkip(true);
                continue;
            }
            List<Element> list9 = this.lines;
            Intrinsics.checkNotNull(list9);
            if (!UTDElements.BRLONLY.isA((Node)list9.get(i))) continue;
            boolean yDown = false;
            if (!pageBuilder.setLineNumberPos(pageBuilder.getY()) && this.firstAdd > -1) {
                PageBuilder pageBuilder3 = pageBuilder;
                pageBuilder3.setY(pageBuilder3.getY() + 1);
                pageBuilder.setX(NumberedProseFormatter.Companion.safeUnbox(style.getIndent(), 0));
                pageBuilder.setLineNumberPos(pageBuilder.getLineNumberPos() + pageBuilder.getLineSpacing());
                yDown = true;
            }
            if (pageBuilder.getX() + 3 < pageBuilder.getCellsPerLine() + pageBuilder.getRightIndent()) {
                List<int[]> list10 = this.lineDetails;
                Intrinsics.checkNotNull(list10);
                this.spaces = list10.get(i)[2];
                this.spaced = true;
            } else if (i > 0) {
                this.spaces = 0;
                if (!yDown) {
                    pageBuilder.setLineNumberPos(pageBuilder.getLineNumberPos() + pageBuilder.getLineSpacing());
                }
            }
            List<Element> list11 = this.lines;
            Intrinsics.checkNotNull(list11);
            String string = list11.get(i).getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
            pageBuilder.insertLineNumber(string);
        }
        return pageBuilder;
    }

    private final PageBuilder remove(Set<PageBuilder> pageBuilders) {
        List<Element> list = this.lines;
        Intrinsics.checkNotNull(list);
        for (Element line : list) {
            if (PageBuilderHelper.isSkipLinesNode((Node)line)) continue;
            Iterator<PageBuilder> iter = pageBuilders.iterator();
            while (iter.hasNext()) {
                Object object;
                if (UTDElements.BRL.isA((Node)line)) {
                    object = iter.next().removeBrl(line);
                    continue;
                }
                if (UTDElements.BRLONLY.isA((Node)line)) {
                    PageBuilder pb = iter.next();
                    pb.removeFormattingElement(line);
                    object = pb.setLineNumberPos(-1);
                    continue;
                }
                object = iter.next();
            }
        }
        return (PageBuilder)CollectionsKt.last((Iterable)pageBuilders);
    }

    private final void setXY(int x, int y) {
        this.xBegin = x;
        this.yBegin = y;
    }

    private final boolean isLineNum(Element element) {
        return element.getAttribute("class") != null && Intrinsics.areEqual((Object)element.getAttributeValue("class"), (Object)"linenum");
    }

    private final PageBuilder getLatestPB(Set<PageBuilder> results, int origSize, PageBuilder pageBuilder) {
        if (results.size() > origSize) {
            List<Element> list = this.lines;
            Intrinsics.checkNotNull(list);
            list.clear();
            List<int[]> list2 = this.lineDetails;
            Intrinsics.checkNotNull(list2);
            list2.clear();
            return (PageBuilder)CollectionsKt.last((Iterable)results);
        }
        return pageBuilder;
    }

    private final IStyle findStyle(FormatSelector formatSelector, Node node) {
        IStyleMap styleMap = formatSelector.styleMap;
        IStyle curStyle = (IStyle)styleMap.findValueOrDefault(node);
        if (Intrinsics.areEqual((Object)curStyle.getName(), (Object)"DEFAULT")) {
            ParentNode parentNode = node.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)parentNode, (String)"getParent(...)");
            return this.findStyle(formatSelector, (Node)parentNode);
        }
        return curStyle;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J!\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lorg/brailleblaster/utd/formatters/NumberedProseFormatter$Companion;", "", "<init>", "()V", "safeUnbox", "", "leftIndentBoxed", "defaultValue", "(Ljava/lang/Integer;I)I", "utd"})
    public static final class Companion {
        private Companion() {
        }

        private final int safeUnbox(Integer leftIndentBoxed, int defaultValue) {
            Integer n = leftIndentBoxed;
            return n != null ? n : defaultValue;
        }

        static /* synthetic */ int safeUnbox$default(Companion companion, Integer n, int n2, int n3, Object object) {
            if ((n3 & 2) != 0) {
                n2 = 0;
            }
            return companion.safeUnbox(n, n2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

