/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.utd.formatters;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Node;
import org.brailleblaster.libembosser.spi.BrlCell;
import org.brailleblaster.utd.FormatSelector;
import org.brailleblaster.utd.IStyle;
import org.brailleblaster.utd.IStyleMap;
import org.brailleblaster.utd.ITranslationEngine;
import org.brailleblaster.utd.PageBuilder;
import org.brailleblaster.utd.Style;
import org.brailleblaster.utd.StyleStack;
import org.brailleblaster.utd.formatters.LiteraryFormatter;
import org.brailleblaster.utd.properties.Align;
import org.brailleblaster.utd.properties.PageNumberPosition;
import org.brailleblaster.utd.properties.PageNumberType;
import org.brailleblaster.utd.utils.PageBuilderHelper;
import org.brailleblaster.utd.utils.UTDHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000  2\u00020\u0001:\u0001 B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J4\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00122\u0006\u0010\b\u001a\u00020\tH\u0016JD\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u001e\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00122\u0006\u0010\u001f\u001a\u00020\u0015H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/brailleblaster/utd/formatters/TPageFormatter;", "Lorg/brailleblaster/utd/formatters/LiteraryFormatter;", "<init>", "()V", "engine", "Lorg/brailleblaster/utd/ITranslationEngine;", "cellType", "Lorg/brailleblaster/libembosser/spi/BrlCell;", "formatSelector", "Lorg/brailleblaster/utd/FormatSelector;", "style", "Lorg/brailleblaster/utd/IStyle;", "format", "", "Lorg/brailleblaster/utd/PageBuilder;", "node", "Lnu/xom/Node;", "pageBuilders", "", "processTitlePage", "element", "Lnu/xom/Element;", "extraLines", "", "remainder", "numOfSections", "splitLastLine", "", "removeBrlFromPB", "", "set", "parent", "Companion", "utd"})
public final class TPageFormatter
extends LiteraryFormatter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private ITranslationEngine engine;
    @Nullable
    private BrlCell cellType;
    @Nullable
    private FormatSelector formatSelector;
    @Nullable
    private IStyle style;
    @NotNull
    private static final Attribute CENTERED_ATTR = new Attribute("utd:centered", "http://brailleblaster.org/ns/utd", "true");

    @Override
    @NotNull
    public Set<PageBuilder> format(@NotNull Node node, @NotNull IStyle style, @NotNull Set<PageBuilder> pageBuilders, @NotNull FormatSelector formatSelector) {
        PageNumberType newPageType;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter(pageBuilders, (String)"pageBuilders");
        Intrinsics.checkNotNullParameter((Object)formatSelector, (String)"formatSelector");
        Set<PageBuilder> mutPageBuilders = CollectionsKt.toMutableSet((Iterable)pageBuilders);
        PageBuilder pageBuilder = (PageBuilder)CollectionsKt.last((Iterable)mutPageBuilders);
        if (!(node instanceof Element) || ((Element)node).getChildElements().size() == 0) {
            return mutPageBuilders;
        }
        pageBuilder.setCurrBrl((Element)node);
        PageNumberType origPageType = pageBuilder.getPageNumberType();
        PageNumberType pageNumberType = newPageType = pageBuilder.getPageNumberTypeFromMetaData() != null ? pageBuilder.getPageNumberTypeFromMetaData() : PageNumberType.T_PAGE;
        if (pageBuilder.getPageNumberType() != newPageType) {
            PageNumberType pageNumberType2 = newPageType;
            Intrinsics.checkNotNull((Object)((Object)pageNumberType2));
            PageBuilderHelper.setPageNumberType(pageBuilder, pageNumberType2, formatSelector);
        }
        mutPageBuilders.addAll((Collection)pageBuilder.processSpacing());
        pageBuilder = (PageBuilder)CollectionsKt.last((Iterable)mutPageBuilders);
        boolean startOfBlockState = pageBuilder.isStartOfBlock();
        pageBuilder.setStartOfBlock(true);
        ITranslationEngine iTranslationEngine = this.engine = formatSelector.engine;
        Intrinsics.checkNotNull((Object)iTranslationEngine);
        this.cellType = iTranslationEngine.getBrailleSettings().getCellType();
        this.formatSelector = formatSelector;
        this.style = style;
        IStyleMap styleMap = formatSelector.styleMap;
        mutPageBuilders.addAll((Collection)this.preFormat(node, pageBuilder, style, styleMap));
        Element titlePage = ((Element)node).getChildElements().get(0);
        List secondaryPages = new LinkedList();
        int n = ((Element)node).getChildElements().size();
        for (int i = 1; i < n; ++i) {
            Element element = ((Element)node).getChildElements().get(i);
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"get(...)");
            if (!UTDHelper.containsBrl((Node)element)) continue;
            Element element2 = ((Element)node).getChildElements().get(i);
            Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"get(...)");
            secondaryPages.add(element2);
        }
        pageBuilder = (PageBuilder)CollectionsKt.last((Iterable)mutPageBuilders);
        pageBuilder.setY(0);
        boolean insertPages = false;
        if (titlePage != null && titlePage.getChildCount() > 0) {
            insertPages = true;
            boolean centered = Intrinsics.areEqual((Object)CENTERED_ATTR.getValue(), (Object)titlePage.getAttributeValue(CENTERED_ATTR.getLocalName(), "http://brailleblaster.org/ns/utd"));
            if (centered) {
                Style centeredStyle = new Style();
                centeredStyle.setAlign(Align.CENTERED);
                if (style instanceof StyleStack) {
                    ((StyleStack)style).push(centeredStyle);
                }
            }
            mutPageBuilders = this.processTitlePage(titlePage, mutPageBuilders, 0, 0, -1, false);
            pageBuilder = (PageBuilder)CollectionsKt.last((Iterable)mutPageBuilders);
            if (centered && style instanceof StyleStack) {
                ((StyleStack)style).pop();
            }
        }
        pageBuilder = (PageBuilder)CollectionsKt.last((Iterable)mutPageBuilders);
        for (Element page : secondaryPages) {
            if (insertPages) {
                pageBuilder.addAtLeastPages(1);
                mutPageBuilders.addAll((Collection<PageBuilder>)pageBuilder.processSpacing());
            }
            mutPageBuilders.addAll((Collection<PageBuilder>)super.format((Node)page, style, mutPageBuilders, formatSelector));
            pageBuilder = (PageBuilder)CollectionsKt.last((Iterable)mutPageBuilders);
        }
        pageBuilder.addAtLeastPages(1);
        mutPageBuilders.addAll((Collection)this.postFormat(node, pageBuilder, style, styleMap));
        mutPageBuilders.addAll((Collection<PageBuilder>)((PageBuilder)CollectionsKt.last((Iterable)mutPageBuilders)).processSpacing());
        PageBuilder lastPB = (PageBuilder)CollectionsKt.last((Iterable)mutPageBuilders);
        lastPB.setStartOfBlock(startOfBlockState);
        lastPB.setAddedPageNumbers(false);
        lastPB.setAfterTPage(true);
        PageBuilderHelper.setPageNumberType(lastPB, origPageType, formatSelector);
        return mutPageBuilders;
    }

    private final Set<PageBuilder> processTitlePage(Element element, Set<PageBuilder> pageBuilders, int extraLines, int remainder, int numOfSections, boolean splitLastLine) {
        Set<PageBuilder> pageBuilders2 = pageBuilders;
        int extraLines2 = extraLines;
        int remainder2 = remainder;
        PageBuilder pageBuilder = (PageBuilder)CollectionsKt.last((Iterable)pageBuilders2);
        int curPages = pageBuilders2.size();
        int divCount = numOfSections;
        boolean firstPass = false;
        int startRemainder = numOfSections - remainder2;
        int curRemainder = remainder2;
        if (divCount == -1) {
            divCount = 0;
            firstPass = true;
        }
        int n = element.getChildElements().size();
        for (int i = 0; i < n; ++i) {
            Element element2 = element.getChildElements().get(i);
            Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"get(...)");
            if (!UTDHelper.containsBrl((Node)element2)) continue;
            if (i != 0) {
                if (firstPass) {
                    ++divCount;
                    pageBuilder.addAtLeastLinesBefore(1);
                } else {
                    boolean applyRemainder = curRemainder > 0 && i >= startRemainder;
                    pageBuilder.addAtLeastLinesBefore(1 + extraLines2 + (applyRemainder ? 1 : 0));
                    if (applyRemainder) {
                        curRemainder = (int)Math.max((double)(curRemainder - 1), 0.0);
                    }
                }
            }
            Element curSection = element.getChildElements().get(i);
            int n2 = curSection.getChildElements().size();
            for (int block = 0; block < n2; ++block) {
                boolean onLastBlock;
                FormatSelector.Companion.setEnableWriteUTD(false);
                StyleStack styleStack = (StyleStack)this.style;
                Intrinsics.checkNotNull((Object)styleStack);
                FormatSelector formatSelector = this.formatSelector;
                Intrinsics.checkNotNull((Object)formatSelector);
                IStyleMap iStyleMap = formatSelector.styleMap;
                Element element3 = curSection.getChildElements().get(block);
                Intrinsics.checkNotNullExpressionValue((Object)element3, (String)"get(...)");
                styleStack.push(iStyleMap.findValueOrDefault((Node)element3));
                boolean bl = onLastBlock = i == element.getChildElements().size() - 1 && block == curSection.getChildElements().size() - 1;
                if (splitLastLine && onLastBlock) {
                    FormatSelector formatSelector2 = this.formatSelector;
                    Intrinsics.checkNotNull((Object)formatSelector2);
                    PageNumberPosition braillePosition = PageBuilderHelper.getBraillePageNumberAt(formatSelector2.engine.getPageSettings(), pageBuilder.getBraillePageNumber().getPageNumber());
                    FormatSelector formatSelector3 = this.formatSelector;
                    Intrinsics.checkNotNull((Object)formatSelector3);
                    PageNumberPosition printPosition = PageBuilderHelper.getPrintPageNumberAt(formatSelector3.engine.getPageSettings(), pageBuilder.getBraillePageNumber().getPageNumber());
                    int pageNumberSize = 0;
                    if (((CharSequence)pageBuilder.getBraillePageNum()).length() > 0 && (braillePosition == PageNumberPosition.BOTTOM_LEFT || braillePosition == PageNumberPosition.BOTTOM_RIGHT)) {
                        pageNumberSize += pageBuilder.getBraillePageNum().length() + pageBuilder.getPadding();
                    }
                    if (((CharSequence)pageBuilder.getPrintPageNumber()).length() > 0 && (printPosition == PageNumberPosition.BOTTOM_LEFT || printPosition == PageNumberPosition.BOTTOM_RIGHT)) {
                        pageNumberSize += pageBuilder.getPrintPageNumber().length() + pageBuilder.getPadding();
                    }
                    Style lineLengthStyle = new Style();
                    lineLengthStyle.setLineLength(-1 * pageNumberSize);
                    StyleStack styleStack2 = (StyleStack)this.style;
                    Intrinsics.checkNotNull((Object)styleStack2);
                    styleStack2.push(lineLengthStyle);
                }
                pageBuilder.setStartOfBlock(true);
                Element element4 = curSection.getChildElements().get(block);
                Intrinsics.checkNotNullExpressionValue((Object)element4, (String)"get(...)");
                Node node = (Node)element4;
                IStyle iStyle = this.style;
                Intrinsics.checkNotNull((Object)iStyle);
                FormatSelector formatSelector4 = this.formatSelector;
                Intrinsics.checkNotNull((Object)formatSelector4);
                pageBuilders2 = super.format(node, iStyle, pageBuilders2, formatSelector4);
                StyleStack styleStack3 = (StyleStack)this.style;
                Intrinsics.checkNotNull((Object)styleStack3);
                styleStack3.pop();
                if (splitLastLine && onLastBlock) {
                    StyleStack styleStack4 = (StyleStack)this.style;
                    Intrinsics.checkNotNull((Object)styleStack4);
                    styleStack4.pop();
                }
                FormatSelector.Companion.setEnableWriteUTD(true);
                pageBuilder = (PageBuilder)CollectionsKt.last((Iterable)pageBuilders2);
            }
        }
        if (divCount == 0) {
            return pageBuilders2;
        }
        if (pageBuilders2.size() > curPages) {
            if (extraLines2 == 0 && remainder2 == 0) {
                return pageBuilders2;
            }
            if (remainder2 > 0) {
                --remainder2;
            } else {
                --extraLines2;
                remainder2 = divCount - 1;
            }
            this.removeBrlFromPB(pageBuilders2, element);
            pageBuilders2.remove(CollectionsKt.last((Iterable)pageBuilders2));
            pageBuilder = (PageBuilder)CollectionsKt.last((Iterable)pageBuilders2);
            pageBuilder.setY(0);
            pageBuilder.setX(0);
            return this.processTitlePage(element, pageBuilders2, extraLines2, remainder2, divCount, true);
        }
        int endingY = pageBuilder.getY();
        BrlCell brlCell = this.cellType;
        Intrinsics.checkNotNull((Object)brlCell);
        ITranslationEngine iTranslationEngine = this.engine;
        Intrinsics.checkNotNull((Object)iTranslationEngine);
        int finalLine = brlCell.getLinesForHeight(new BigDecimal(String.valueOf(iTranslationEngine.getPageSettings().getDrawableHeight())));
        if (firstPass && endingY != finalLine && extraLines2 == 0 && curRemainder == 0) {
            int diff = finalLine - endingY - 1;
            if (diff == 0) {
                return pageBuilders2;
            }
            this.removeBrlFromPB(pageBuilders2, element);
            pageBuilder.setY(0);
            pageBuilder.setX(0);
            pageBuilders2 = this.processTitlePage(element, pageBuilders2, diff / divCount, diff % divCount, divCount, false);
        }
        return pageBuilders2;
    }

    private final void removeBrlFromPB(Set<PageBuilder> set, Element parent) {
        List<Element> brls = UTDHelper.getDescendantBrlFast((Node)parent);
        for (Element brl : brls) {
            for (PageBuilder pb : set) {
                pb.removeBrl(brl);
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/brailleblaster/utd/formatters/TPageFormatter$Companion;", "", "<init>", "()V", "CENTERED_ATTR", "Lnu/xom/Attribute;", "getCENTERED_ATTR", "()Lnu/xom/Attribute;", "utd"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Attribute getCENTERED_ATTR() {
            return CENTERED_ATTR;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

