/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.utd.internal.xml;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.xml.parsers.ParserConfigurationException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.StringsKt;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Nodes;
import nu.xom.ParentNode;
import nu.xom.ParsingException;
import nu.xom.Serializer;
import nu.xom.Text;
import nu.xom.ValidityException;
import nu.xom.XPathContext;
import org.apache.commons.io.input.BOMInputStream;
import org.brailleblaster.utd.exceptions.NodeException;
import org.brailleblaster.utd.internal.xml.XMLHandlerKt;
import org.brailleblaster.utd.utils.LocalEntityResolver;
import org.brailleblaster.utils.xom.NodeUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.helpers.MessageFormatter;
import org.xml.sax.SAXException;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00172\u00020\u0001:\u0002\u0016\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tJ\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\u0004\u001a\u00020\u00052\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u000bJ\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0014\u00a8\u0006\u0018"}, d2={"Lorg/brailleblaster/utd/internal/xml/XMLHandler;", "", "<init>", "()V", "load", "Lnu/xom/Document;", "xmlPathInput", "Ljava/nio/file/Path;", "baseUri", "", "xmlFileInput", "Ljava/io/File;", "input", "Ljava/io/Reader;", "save", "", "doc", "xmlFileOutput", "output", "Ljava/io/OutputStream;", "newSerializer", "Lnu/xom/Serializer;", "Formatted", "Companion", "utd"})
public class XMLHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Field FIELD_XPATHCONTEXT_NAMESPACES;

    @NotNull
    public final Document load(@NotNull Path xmlPathInput) {
        Intrinsics.checkNotNullParameter((Object)xmlPathInput, (String)"xmlPathInput");
        String string = xmlPathInput.toUri().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        Object baseUri = string;
        if (StringsKt.startsWith$default((String)baseUri, (String)"jar:", (boolean)false, (int)2, null)) {
            baseUri = "jar-utd-encoded://" + URLEncoder.encode((String)baseUri, StandardCharsets.UTF_8);
        }
        return this.load(xmlPathInput, (String)baseUri);
    }

    @NotNull
    public final Document load(@NotNull Path xmlPathInput, @Nullable String baseUri) {
        Intrinsics.checkNotNullParameter((Object)xmlPathInput, (String)"xmlPathInput");
        try {
            Builder builder = LocalEntityResolver.Companion.createXomBuilder(false);
            Document document = builder.build((InputStream)((BOMInputStream.Builder)BOMInputStream.builder().setInputStream(Files.newInputStream(xmlPathInput, new OpenOption[0]))).get(), baseUri);
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"build(...)");
            return document;
        }
        catch (ValidityException e) {
            throw new RuntimeException("The document failed to validate in " + xmlPathInput, e);
        }
        catch (ParsingException e) {
            throw new RuntimeException("The document XML is malformed in " + xmlPathInput, e);
        }
        catch (IOException e) {
            throw new RuntimeException("Problem reading file " + xmlPathInput, e);
        }
        catch (SAXException e) {
            throw new RuntimeException("Problem creating the XML parser, may be Apache Xerces is not installed", e);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Problem creating the XML parser, may be Apache Xerces is not installed", e);
        }
    }

    @NotNull
    public final Document load(@NotNull File xmlFileInput) {
        Intrinsics.checkNotNullParameter((Object)xmlFileInput, (String)"xmlFileInput");
        File xmlFile = xmlFileInput.getAbsoluteFile();
        if (!xmlFile.exists()) {
            throw new RuntimeException("XML File " + xmlFile + " does not exist");
        }
        Path path = xmlFile.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        return this.load(path);
    }

    @NotNull
    public final Document load(@Nullable Reader input) {
        try {
            Builder builder = LocalEntityResolver.Companion.createXomBuilder(false);
            Document document = builder.build(input);
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"build(...)");
            return document;
        }
        catch (ValidityException e) {
            throw new RuntimeException("The document failed to validate", e);
        }
        catch (ParsingException e) {
            throw new RuntimeException("The document XML is malformed", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Problem reading file", e);
        }
        catch (SAXException e) {
            throw new RuntimeException("Problem creating the XML parser, may be Apache Xerces is not installed", e);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Problem creating the XML parser, may be Apache Xerces is not installed", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save(@NotNull Document doc, @NotNull File xmlFileOutput) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Intrinsics.checkNotNullParameter((Object)xmlFileOutput, (String)"xmlFileOutput");
        File xmlFile = xmlFileOutput.getAbsoluteFile();
        boolean overwriting = xmlFile.exists();
        try {
            Closeable closeable = new FileOutputStream(xmlFileOutput);
            Throwable throwable = null;
            try {
                FileOutputStream output = (FileOutputStream)closeable;
                boolean bl = false;
                this.save(doc, output);
                XMLHandlerKt.access$getLog$p().debug("Wrote UTD output to {}, overwriting {}", (Object)xmlFileOutput.getCanonicalPath(), (Object)overwriting);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to save file to " + xmlFileOutput.getAbsolutePath(), e);
        }
    }

    public final void save(@NotNull Document doc, @NotNull OutputStream output) throws IOException {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Serializer serializer = this.newSerializer(output);
        serializer.write(doc);
    }

    @NotNull
    protected Serializer newSerializer(@NotNull OutputStream output) throws IOException {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        return new Serializer(output, "UTF-8");
    }

    @JvmStatic
    @NotNull
    public static final List<Element> queryElements(@NotNull Node node, @NotNull String xpathPattern, Object ... xpathArgs) {
        return Companion.queryElements(node, xpathPattern, xpathArgs);
    }

    @JvmStatic
    @NotNull
    public static final Nodes query(@NotNull Node node, @NotNull String xpathPattern, Object ... xpathArgs) {
        return Companion.query(node, xpathPattern, xpathArgs);
    }

    @JvmStatic
    @NotNull
    public static final String toXMLSimple(@NotNull Node node) {
        return Companion.toXMLSimple(node);
    }

    @JvmStatic
    @Nullable
    public static final String toXMLPrettyPrint(@NotNull ParentNode node) {
        return Companion.toXMLPrettyPrint(node);
    }

    @JvmStatic
    @Nullable
    public static final Element nodeToElementOrParentOrDocRoot(@NotNull Node node) {
        return Companion.nodeToElementOrParentOrDocRoot(node);
    }

    @JvmStatic
    @Nullable
    public static final Node nextSiblingNode(@NotNull Node node) {
        return Companion.nextSiblingNode(node);
    }

    @JvmStatic
    @Nullable
    public static final Node previousSiblingNode(@NotNull Node node) {
        return Companion.previousSiblingNode(node);
    }

    static {
        try {
            Field field = XPathContext.class.getDeclaredField("namespaces");
            Intrinsics.checkNotNullExpressionValue((Object)field, (String)"getDeclaredField(...)");
            FIELD_XPATHCONTEXT_NAMESPACES = field;
            FIELD_XPATHCONTEXT_NAMESPACES.setAccessible(true);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to init fields", ex);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0013\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ;\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0016\u0010\u0010\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0011\"\u0004\u0018\u00010\u0001H\u0007\u00a2\u0006\u0002\u0010\u0012J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\tJ\u000e\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\tJ5\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0016\u0010\u0010\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0011\"\u0004\u0018\u00010\u0001H\u0007\u00a2\u0006\u0002\u0010\u001bJ\u000e\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\tJ\u0010\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\f\u001a\u00020 H\u0007J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\b\u001a\u00020 H\u0002J\u000e\u0010#\u001a\u00020\t2\u0006\u0010$\u001a\u00020 J\u0012\u0010%\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0016\u0010&\u001a\u00020\t2\u0006\u0010'\u001a\u00020 2\u0006\u0010(\u001a\u00020\u000fJ\u001e\u0010)\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\r2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\t0+J\u001e\u0010,\u001a\u0004\u0018\u00010\r2\u0006\u0010\f\u001a\u00020\r2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\r0+J\u001c\u0010-\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\t0+J\u001c\u0010.\u001a\u00020/2\u0006\u0010\f\u001a\u00020\r2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\t0+J\u001c\u00101\u001a\u00020/2\u0006\u0010\f\u001a\u00020\r2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\t0+J\u0016\u00102\u001a\b\u0012\u0004\u0012\u00020\t032\b\u0010\u001d\u001a\u0004\u0018\u00010\rJ\u0016\u00104\u001a\b\u0012\u0004\u0012\u00020\t0\u000b2\b\u0010\u001d\u001a\u0004\u0018\u00010\tJ\u0014\u00105\u001a\u00020\t2\f\u00106\u001a\b\u0012\u0004\u0012\u00020\t0\u000bJ\u001e\u00107\u001a\u0004\u0018\u00010\t2\u0006\u00108\u001a\u00020\t2\f\u00109\u001a\b\u0012\u0004\u0012\u00020\t0+J\u001e\u0010:\u001a\u0004\u0018\u00010\r2\u0006\u0010;\u001a\u00020\r2\f\u00109\u001a\b\u0012\u0004\u0012\u00020\r0+J\u0018\u0010<\u001a\u00020\u00142\u0006\u0010=\u001a\u00020\t2\b\u0010>\u001a\u0004\u0018\u00010\u000fJ\u0012\u0010?\u001a\u0004\u0018\u00010\r2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0012\u0010@\u001a\u0004\u0018\u00010\r2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010A\u001a\u0004\u0018\u00010\r2\u0006\u0010\f\u001a\u00020\rJ\u001e\u0010B\u001a\u0004\u0018\u00010\r2\u0006\u0010C\u001a\u00020\r2\f\u0010D\u001a\b\u0012\u0004\u0012\u00020\r0+J \u0010E\u001a\u0004\u0018\u00010\r2\b\u0010C\u001a\u0004\u0018\u00010\r2\f\u0010D\u001a\b\u0012\u0004\u0012\u00020\r0+R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lorg/brailleblaster/utd/internal/xml/XMLHandler$Companion;", "", "<init>", "()V", "FIELD_XPATHCONTEXT_NAMESPACES", "Ljava/lang/reflect/Field;", "findFirstText", "Lnu/xom/Text;", "someElement", "Lnu/xom/Element;", "queryElements", "", "node", "Lnu/xom/Node;", "xpathPattern", "", "xpathArgs", "", "(Lnu/xom/Node;Ljava/lang/String;[Ljava/lang/Object;)Ljava/util/List;", "wrapNodeWithElement", "", "nodeToWrap", "wrapper", "unwrapElement", "elem", "query", "Lnu/xom/Nodes;", "(Lnu/xom/Node;Ljava/lang/String;[Ljava/lang/Object;)Lnu/xom/Nodes;", "toXMLStartTag", "element", "toXMLSimple", "toXMLPrettyPrint", "Lnu/xom/ParentNode;", "toXPathContext", "Lnu/xom/XPathContext;", "parentToElement", "someParentNode", "nodeToElementOrParentOrDocRoot", "newElement", "someDOMElement", "localName", "ancestorVisitorElement", "onAncestor", "Ljava/util/function/Predicate;", "ancestorVisitor", "ancestorVisitorFatal", "ancestorElementNot", "", "matcher", "ancestorElementIs", "ancestor", "", "ancestorOrSelf", "findCommonParent", "elements", "childrenRecursiveVisitor", "curElem", "onElement", "childrenRecursiveNodeVisitor", "curNode", "setNamespaceRecursive", "root", "namespaceURI", "nextSiblingNode", "previousSiblingNode", "followingNode", "followingVisitor", "startNode", "onNode", "followingWithSelfVisitor", "utd"})
    @SourceDebugExtension(value={"SMAP\nXMLHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XMLHandler.kt\norg/brailleblaster/utd/internal/xml/XMLHandler$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,626:1\n812#2,12:627\n296#2,2:639\n812#2,12:641\n1#3:653\n*S KotlinDebug\n*F\n+ 1 XMLHandler.kt\norg/brailleblaster/utd/internal/xml/XMLHandler$Companion\n*L\n176#1:627,12\n177#1:639,2\n182#1:641,12\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Text findFirstText(@NotNull Element someElement) {
            Object v2;
            block3: {
                void $this$filterIsInstanceTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)someElement, (String)"someElement");
                Iterable $this$filterIsInstance$iv = (Iterable)this.query((Node)someElement, "descendant::text()[not(ancestor::utd:brl)]", new Object[0]);
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof Text)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$firstOrNull$iv = (List)destination$iv$iv;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Text it = (Text)element$iv;
                    boolean bl = false;
                    String string = it.getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
                    boolean bl2 = !StringsKt.isBlank((CharSequence)string);
                    if (!bl2) continue;
                    v2 = element$iv;
                    break block3;
                }
                v2 = null;
            }
            Text text = v2;
            if (text == null) {
                throw new RuntimeException("Couldn't find text in " + someElement.toXML());
            }
            return text;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final List<Element> queryElements(@NotNull Node node, @NotNull String xpathPattern, Object ... xpathArgs) {
            void $this$filterIsInstanceTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)xpathPattern, (String)"xpathPattern");
            Intrinsics.checkNotNullParameter((Object)xpathArgs, (String)"xpathArgs");
            Iterable $this$filterIsInstance$iv = (Iterable)this.query(node, xpathPattern, Arrays.copyOf(xpathArgs, xpathArgs.length));
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof Element)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        public final void wrapNodeWithElement(@NotNull Node nodeToWrap, @NotNull Element wrapper) {
            Intrinsics.checkNotNullParameter((Object)nodeToWrap, (String)"nodeToWrap");
            Intrinsics.checkNotNullParameter((Object)wrapper, (String)"wrapper");
            nodeToWrap.getParent().replaceChild(nodeToWrap, (Node)wrapper);
            wrapper.appendChild(nodeToWrap);
        }

        public final void unwrapElement(@NotNull Element elem) {
            Intrinsics.checkNotNullParameter((Object)elem, (String)"elem");
            if (elem.getChildCount() > 0) {
                ParentNode elemParent = elem.getParent();
                int parentIndex = elemParent.indexOf((Node)elem);
                while (elem.getChildCount() != 0) {
                    Node curChildNode = elem.getChild(elem.getChildCount() - 1);
                    curChildNode.detach();
                    elemParent.insertChild(curChildNode, parentIndex);
                }
            }
            elem.detach();
        }

        @JvmStatic
        @NotNull
        public final Nodes query(@NotNull Node node, @NotNull String xpathPattern, Object ... xpathArgs) {
            ParentNode nodeAsParent;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)xpathPattern, (String)"xpathPattern");
            Intrinsics.checkNotNullParameter((Object)xpathArgs, (String)"xpathArgs");
            String realXpath = MessageFormatter.arrayFormat((String)xpathPattern, (Object[])xpathArgs).getMessage();
            Node node2 = node;
            XMLHandlerKt.access$getLog$p().trace("Executing XPath {} on {}", (Object)realXpath, (Object)(node2 instanceof Document ? "Document" : (node2 instanceof Element ? this.toXMLStartTag((Element)node) : node.toString())));
            ParentNode parentNode = node instanceof ParentNode ? (ParentNode)node : null;
            if (parentNode == null) {
                parentNode = node.getParent();
            }
            ParentNode parentNode2 = nodeAsParent = parentNode;
            XPathContext context = parentNode2 != null ? this.toXPathContext(parentNode2) : null;
            Nodes nodes = node.query(realXpath, context);
            Intrinsics.checkNotNullExpressionValue((Object)nodes, (String)"query(...)");
            return nodes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final String toXMLStartTag(@NotNull Element element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            String encoding = "UTF-8";
            try {
                Closeable closeable = new ByteArrayOutputStream();
                Throwable throwable = null;
                try {
                    ByteArrayOutputStream bytes = (ByteArrayOutputStream)closeable;
                    boolean bl = false;
                    new Serializer(bytes, encoding){

                        public void writeStartTag(Element element) throws IOException {
                            super.writeStartTag(element);
                        }
                    }.writeStartTag(element);
                    String string = bytes.toString(encoding);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    String string2 = string;
                    return string2;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Encoding not supported, this should not have happened.", e);
            }
        }

        @JvmStatic
        @NotNull
        public final String toXMLSimple(@NotNull Node node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            return node instanceof Element ? this.toXMLStartTag((Element)node) : node.toString();
        }

        @JvmStatic
        @Nullable
        public final String toXMLPrettyPrint(@NotNull ParentNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                Serializer serializer = new Serializer((OutputStream)out, StandardCharsets.UTF_8.name());
                serializer.setIndent(2);
                Document wrapperDoc = null;
                if (node instanceof Document) {
                    wrapperDoc = (Document)node;
                } else {
                    Element nodeCopy = (Element)node.copy();
                    wrapperDoc = new Document(nodeCopy);
                }
                wrapperDoc.getRootElement().addNamespaceDeclaration("utd", "http://brailleblaster.org/ns/utd");
                serializer.write(wrapperDoc);
                return out.toString(StandardCharsets.UTF_8);
            }
            catch (Exception e) {
                throw new NodeException("Unable to pretty print", (Node)node, e);
            }
        }

        private final XPathContext toXPathContext(ParentNode someElement) {
            Element element = this.parentToElement(someElement);
            XPathContext context = XPathContext.makeNamespaceContext((Element)element);
            String bookNS = element.getNamespaceURI();
            Intrinsics.checkNotNull((Object)bookNS);
            if (!StringsKt.isBlank((CharSequence)bookNS)) {
                context.addNamespace("book", bookNS);
            } else {
                try {
                    Object object = FIELD_XPATHCONTEXT_NAMESPACES.get(context);
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String?, kotlin.String?>");
                    Map map = TypeIntrinsics.asMutableMap((Object)object);
                    map.put("book", "");
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to get map", e);
                }
            }
            context.addNamespace("utd", "http://brailleblaster.org/ns/utd");
            context.addNamespace("m", "http://www.w3.org/1998/Math/MathML");
            Intrinsics.checkNotNull((Object)context);
            return context;
        }

        @NotNull
        public final Element parentToElement(@NotNull ParentNode someParentNode) {
            Element element;
            Intrinsics.checkNotNullParameter((Object)someParentNode, (String)"someParentNode");
            if (someParentNode instanceof Document) {
                Element element2 = ((Document)someParentNode).getRootElement();
                element = element2;
                Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"getRootElement(...)");
            } else {
                element = (Element)someParentNode;
            }
            return element;
        }

        @JvmStatic
        @Nullable
        public final Element nodeToElementOrParentOrDocRoot(@NotNull Node node) {
            ParentNode parentNode;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Node node2 = node;
            return node2 instanceof Element ? (Element)node : (node2 instanceof Document ? ((Document)node).getRootElement() : ((parentNode = node.getParent()) instanceof Element ? (Element)parentNode : null));
        }

        @NotNull
        public final Element newElement(@NotNull ParentNode someDOMElement, @NotNull String localName) {
            Intrinsics.checkNotNullParameter((Object)someDOMElement, (String)"someDOMElement");
            Intrinsics.checkNotNullParameter((Object)localName, (String)"localName");
            String nameSpace = this.parentToElement(someDOMElement).getNamespaceURI();
            return new Element(localName, nameSpace);
        }

        @Nullable
        public final Element ancestorVisitorElement(@NotNull Node node, @NotNull Predicate<Element> onAncestor) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter(onAncestor, (String)"onAncestor");
            Node node2 = this.ancestorVisitor(node, arg_0 -> Companion.ancestorVisitorElement$lambda$0(onAncestor, arg_0));
            return node2 instanceof Element ? (Element)node2 : null;
        }

        @Nullable
        public final Node ancestorVisitor(@NotNull Node node, @NotNull Predicate<Node> onAncestor) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter(onAncestor, (String)"onAncestor");
            Document document = node.getDocument();
            if (document == null) {
                throw new RuntimeException("Element is detached from a document element " + node.toXML());
            }
            Document document2 = document;
            if (node == document2) {
                return null;
            }
            if (onAncestor.test(node)) {
                return node;
            }
            ParentNode parentNode = node.getParent();
            if (parentNode == document2) {
                return null;
            }
            if (parentNode == null) {
                throw new RuntimeException("Has document but parent is null? " + node.toXML());
            }
            return this.ancestorVisitor((Node)parentNode, onAncestor);
        }

        @NotNull
        public final Element ancestorVisitorFatal(@NotNull Node node, @NotNull Predicate<Element> onAncestor) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter(onAncestor, (String)"onAncestor");
            Element element = this.ancestorVisitorElement(node, onAncestor);
            if (element == null) {
                throw new NodeException("Unable to match node ", node, null, 4, null);
            }
            Element result = element;
            return result;
        }

        public final boolean ancestorElementNot(@NotNull Node node, @NotNull Predicate<Element> matcher) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter(matcher, (String)"matcher");
            return this.ancestorVisitorElement(node, matcher) == null;
        }

        public final boolean ancestorElementIs(@NotNull Node node, @NotNull Predicate<Element> matcher) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter(matcher, (String)"matcher");
            return this.ancestorVisitorElement(node, matcher) != null;
        }

        @NotNull
        public final List<Element> ancestor(@Nullable Node element) {
            Node node = element;
            return CollectionsKt.toMutableList((Collection)this.ancestorOrSelf((Element)(node != null ? node.getParent() : null)));
        }

        @NotNull
        public final List<Element> ancestorOrSelf(@Nullable Element element) {
            List ancestors = new ArrayList();
            Element curAncestor = element;
            while (curAncestor != null) {
                ancestors.add(curAncestor);
                ParentNode parent = curAncestor.getParent();
                if (parent instanceof Document) break;
                curAncestor = (Element)parent;
            }
            return CollectionsKt.toList((Iterable)ancestors);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Element findCommonParent(@NotNull List<? extends Element> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            if (!(!elements.isEmpty())) {
                boolean bl = false;
                String string = "elements list cannot be empty";
                throw new IllegalArgumentException(string.toString());
            }
            for (Element element : elements) {
                XMLHandlerKt.access$getLog$p().debug("in list {}", (Object)element.toXML());
                if (element.getDocument() != null) continue;
                throw new NodeException("Element #" + elements.indexOf(element) + " isn't attached to document", (Node)element, null, 4, null);
            }
            ParentNode curParent = (ParentNode)elements.get(0);
            if (elements.size() == 1) {
                ParentNode parentNode = curParent;
                Intrinsics.checkNotNull((Object)parentNode, (String)"null cannot be cast to non-null type nu.xom.Element");
                return (Element)parentNode;
            }
            boolean bl = true;
            Document doc = curParent.getDocument();
            while (true) {
                void var3_6;
                Set remainingElements = new HashSet(elements);
                void curCounter = var3_6++;
                Element element = (Element)curParent;
                Intrinsics.checkNotNull((Object)element);
                this.childrenRecursiveVisitor(element, arg_0 -> Companion.findCommonParent$lambda$1(remainingElements, (int)curCounter, arg_0));
                if (remainingElements.isEmpty()) break;
                Intrinsics.checkNotNullExpressionValue((Object)((Element)curParent).getParent(), (String)"getParent(...)");
                if (!Intrinsics.areEqual((Object)curParent, (Object)doc)) continue;
                throw new RuntimeException("Unable to find common parent at iteration " + (int)var3_6);
            }
            return (Element)curParent;
        }

        @Nullable
        public final Element childrenRecursiveVisitor(@NotNull Element curElem, @NotNull Predicate<Element> onElement) {
            Intrinsics.checkNotNullParameter((Object)curElem, (String)"curElem");
            Intrinsics.checkNotNullParameter(onElement, (String)"onElement");
            if (onElement.test(curElem)) {
                return curElem;
            }
            Iterator iterator = curElem.getChildElements().iterator();
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                Element iterableXOMChildren = (Element)iterator2.next();
                Intrinsics.checkNotNull((Object)iterableXOMChildren);
                Element result = this.childrenRecursiveVisitor(iterableXOMChildren, onElement);
                if (result == null) continue;
                return result;
            }
            return null;
        }

        @Nullable
        public final Node childrenRecursiveNodeVisitor(@NotNull Node curNode, @NotNull Predicate<Node> onElement) {
            Intrinsics.checkNotNullParameter((Object)curNode, (String)"curNode");
            Intrinsics.checkNotNullParameter(onElement, (String)"onElement");
            if (onElement.test(curNode)) {
                return curNode;
            }
            for (Node iterableXOMChildren : NodeUtilsKt.getChildNodes((Node)curNode)) {
                Node result = this.childrenRecursiveNodeVisitor(iterableXOMChildren, onElement);
                if (result == null) continue;
                return result;
            }
            return null;
        }

        public final void setNamespaceRecursive(@NotNull Element root, @Nullable String namespaceURI) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            this.childrenRecursiveVisitor(root, arg_0 -> Companion.setNamespaceRecursive$lambda$0(namespaceURI, arg_0));
        }

        @JvmStatic
        @Nullable
        public final Node nextSiblingNode(@NotNull Node node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            ParentNode parentNode = node.getParent();
            if (parentNode == null) {
                throw new NodeException("Node doesn't have parent", node, null, 4, null);
            }
            ParentNode parent = parentNode;
            int index = parent.indexOf(node);
            if (index == parent.getChildCount() - 1) {
                return null;
            }
            return parent.getChild(index + 1);
        }

        @JvmStatic
        @Nullable
        public final Node previousSiblingNode(@NotNull Node node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            ParentNode parentNode = node.getParent();
            if (parentNode == null) {
                throw new NodeException("Node doesn't have parent", node, null, 4, null);
            }
            ParentNode parent = parentNode;
            int index = parent.indexOf(node);
            if (index == 0) {
                return null;
            }
            return parent.getChild(index - 1);
        }

        @Nullable
        public final Node followingNode(@NotNull Node node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (node instanceof Document) {
                return null;
            }
            if (node.getParent() == null) {
                throw new NodeException("Start node doesn't have parent", node, null, 4, null);
            }
            ParentNode parent = node.getParent();
            int index = parent.indexOf(node);
            if (index == parent.getChildCount() - 1) {
                Intrinsics.checkNotNull((Object)parent);
                return this.followingNode((Node)parent);
            }
            return parent.getChild(index + 1);
        }

        @Nullable
        public final Node followingVisitor(@NotNull Node startNode, @NotNull Predicate<Node> onNode) {
            Intrinsics.checkNotNullParameter((Object)startNode, (String)"startNode");
            Intrinsics.checkNotNullParameter(onNode, (String)"onNode");
            return this.followingWithSelfVisitor(this.followingNode(startNode), onNode);
        }

        @Nullable
        public final Node followingWithSelfVisitor(@Nullable Node startNode, @NotNull Predicate<Node> onNode) {
            Intrinsics.checkNotNullParameter(onNode, (String)"onNode");
            Node curNode = startNode;
            while (curNode != null) {
                if (onNode.test(curNode)) {
                    return curNode;
                }
                curNode = curNode.getChildCount() != 0 ? curNode.getChild(0) : this.followingNode(curNode);
            }
            return null;
        }

        private static final boolean ancestorVisitorElement$lambda$0(Predicate $onAncestor, Node n) {
            Intrinsics.checkNotNullParameter((Object)n, (String)"n");
            return n instanceof Element && $onAncestor.test(n);
        }

        private static final boolean findCommonParent$lambda$1(Set $remainingElements, int $curCounter, Element curElem) {
            if ($remainingElements.contains(curElem)) {
                Logger logger = XMLHandlerKt.access$getLog$p();
                Integer n = $curCounter;
                Element element = curElem;
                Intrinsics.checkNotNull((Object)element);
                logger.debug("Found at iteration {} element {}", (Object)n, (Object)element.toXML());
                $remainingElements.remove(curElem);
            }
            return false;
        }

        private static final boolean setNamespaceRecursive$lambda$0(String $namespaceURI, Element curElement) {
            Element element = curElement;
            Intrinsics.checkNotNull((Object)element);
            element.setNamespaceURI($namespaceURI);
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lorg/brailleblaster/utd/internal/xml/XMLHandler$Formatted;", "Lorg/brailleblaster/utd/internal/xml/XMLHandler;", "<init>", "()V", "newSerializer", "Lnu/xom/Serializer;", "output", "Ljava/io/OutputStream;", "utd"})
    public static final class Formatted
    extends XMLHandler {
        @Override
        @NotNull
        protected Serializer newSerializer(@NotNull OutputStream output) throws IOException {
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            Serializer serializer = super.newSerializer(output);
            serializer.setIndent(2);
            return serializer;
        }
    }
}

