/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.utd.matchers;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import nu.xom.Element;
import nu.xom.Node;
import org.brailleblaster.utd.ComparableStyle;
import org.brailleblaster.utd.NamespaceMap;
import org.brailleblaster.utd.internal.ComparableStyleAdapter;
import org.brailleblaster.utd.matchers.INodeMatcher;
import org.brailleblaster.utils.LoggerUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlAccessorType(value=XmlAccessType.FIELD)
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0017\u0018\u0000 !2\u00020\u0001:\u0001!B)\b\u0007\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ,\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00062\u0010\u0010\u0014\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0018\u00010\u0003H\u0002J\"\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00062\u0010\u0010\u0014\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0018\u00010\u0003H\u0002J\u0018\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\n\u0010\u001c\u001a\u00020\u001dH\u0096\u0080\u0004J\u0014\u0010\u001e\u001a\u00020\u00102\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0096\u0082\u0004R$\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR$\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\n\"\u0004\b\u000e\u0010\f\u00a8\u0006\""}, d2={"Lorg/brailleblaster/utd/matchers/ActionAndStyleMatcher;", "Lorg/brailleblaster/utd/matchers/INodeMatcher;", "styles", "", "Lorg/brailleblaster/utd/ComparableStyle;", "actions", "", "<init>", "(Ljava/util/List;Ljava/util/List;)V", "getStyles", "()Ljava/util/List;", "setStyles", "(Ljava/util/List;)V", "getActions", "setActions", "checkAttributeValue", "", "e", "Lnu/xom/Element;", "attributeName", "possibleValues", "checkString", "value", "isMatch", "node", "Lnu/xom/Node;", "namespaces", "Lorg/brailleblaster/utd/NamespaceMap;", "hashCode", "", "equals", "other", "", "Companion", "utd"})
public class ActionAndStyleMatcher
implements INodeMatcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @XmlElement(name="style")
    @XmlJavaTypeAdapter(value=ComparableStyleAdapter.class)
    @NotNull
    private List<ComparableStyle> styles;
    @XmlElement(name="action")
    @NotNull
    private List<String> actions;
    private static final Logger log = LoggerFactory.getLogger(ActionAndStyleMatcher.class);

    @JvmOverloads
    public ActionAndStyleMatcher(@NotNull List<ComparableStyle> styles, @NotNull List<String> actions) {
        Intrinsics.checkNotNullParameter(styles, (String)"styles");
        Intrinsics.checkNotNullParameter(actions, (String)"actions");
        this.styles = styles;
        this.actions = actions;
    }

    public /* synthetic */ ActionAndStyleMatcher(List list, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            list = new ArrayList();
        }
        if ((n & 2) != 0) {
            list2 = new ArrayList();
        }
        this(list, list2);
    }

    @NotNull
    public final List<ComparableStyle> getStyles() {
        return this.styles;
    }

    public final void setStyles(@NotNull List<ComparableStyle> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.styles = list;
    }

    @NotNull
    public final List<String> getActions() {
        return this.actions;
    }

    public final void setActions(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.actions = list;
    }

    private final boolean checkAttributeValue(Element e, String attributeName, List<String> possibleValues) {
        String value = e.getAttributeValue(attributeName);
        List<String> list = possibleValues;
        Intrinsics.checkNotNull(list);
        return list.isEmpty() || value != null && this.checkString(value, possibleValues);
    }

    private final boolean checkString(String value, List<String> possibleValues) {
        List<String> list = possibleValues;
        Intrinsics.checkNotNull(list);
        for (String other : list) {
            log.debug("Checking if {} contains {}", (Object)value, (Object)other);
            CharSequence charSequence = value;
            String string = other;
            Intrinsics.checkNotNull((Object)string);
            if (!StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string, (boolean)false, (int)2, null)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isMatch(@NotNull Node node, @NotNull NamespaceMap namespaces) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)namespaces, (String)"namespaces");
        Logger logger = log;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"log");
        LoggerUtils.debug((Logger)logger, () -> ActionAndStyleMatcher.isMatch$lambda$0(this, node));
        Logger logger2 = log;
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"log");
        LoggerUtils.debug((Logger)logger2, () -> ActionAndStyleMatcher.isMatch$lambda$1(this));
        if (!(node instanceof Element)) {
            Logger logger3 = log;
            Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"log");
            LoggerUtils.debug((Logger)logger3, () -> ActionAndStyleMatcher.isMatch$lambda$2(node));
            return false;
        }
        if (!this.checkAttributeValue((Element)node, "utd-action", this.actions)) {
            Logger logger4 = log;
            Intrinsics.checkNotNullExpressionValue((Object)logger4, (String)"log");
            LoggerUtils.debug((Logger)logger4, () -> ActionAndStyleMatcher.isMatch$lambda$3(node));
            return false;
        }
        if (!((Collection)this.styles).isEmpty()) {
            String nodeStyleName = ((Element)node).getAttributeValue("utd-style");
            if (nodeStyleName == null) {
                Logger logger5 = log;
                Intrinsics.checkNotNullExpressionValue((Object)logger5, (String)"log");
                LoggerUtils.debug((Logger)logger5, () -> ActionAndStyleMatcher.isMatch$lambda$4(node));
                return false;
            }
            for (ComparableStyle compStyle : this.styles) {
                if (!compStyle.isInstanceOfStyle(nodeStyleName)) continue;
                return true;
            }
            return false;
        }
        log.debug("Node {} is a match", (Object)node);
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + ((Object)this.actions).hashCode();
        result = prime * result + ((Object)this.styles).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!Intrinsics.areEqual(this.getClass(), other.getClass())) {
            return false;
        }
        ActionAndStyleMatcher o = (ActionAndStyleMatcher)other;
        if (!Intrinsics.areEqual(this.actions, o.actions)) {
            return false;
        }
        return Intrinsics.areEqual(this.styles, o.styles);
    }

    @JvmOverloads
    public ActionAndStyleMatcher(@NotNull List<ComparableStyle> styles) {
        Intrinsics.checkNotNullParameter(styles, (String)"styles");
        this(styles, null, 2, null);
    }

    @JvmOverloads
    public ActionAndStyleMatcher() {
        this(null, null, 3, null);
    }

    private static final String isMatch$lambda$0(ActionAndStyleMatcher this$0, Node $node) {
        String string = "For matcher %s checking actions and styles of %s";
        Object[] objectArray = new Object[]{this$0, $node.toXML()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    private static final String isMatch$lambda$1(ActionAndStyleMatcher this$0) {
        String string = "Styles are %s";
        Object[] objectArray = new Object[]{this$0.styles};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    private static final String isMatch$lambda$2(Node $node) {
        String string = "Node %s is not an element";
        Object[] objectArray = new Object[]{$node};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    private static final String isMatch$lambda$3(Node $node) {
        String string = "Node %s action does not match";
        Object[] objectArray = new Object[]{$node};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    private static final String isMatch$lambda$4(Node $node) {
        String string = "Node %s does not match";
        Object[] objectArray = new Object[]{$node};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/brailleblaster/utd/matchers/ActionAndStyleMatcher$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "utd"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

