/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.utd.matchers;

import jakarta.xml.bind.annotation.XmlAttribute;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import nu.xom.Text;
import org.brailleblaster.utd.NamespaceMap;
import org.brailleblaster.utd.matchers.INodeMatcher;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\fH\u0002J\u0012\u0010\u0014\u001a\u00020\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0016H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00068F@GX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR$\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00068F@GX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001f\u0010\u001b\"\u0004\b \u0010\u001d\u00a8\u0006!"}, d2={"Lorg/brailleblaster/utd/matchers/EmphasisMatcher;", "Lorg/brailleblaster/utd/matchers/INodeMatcher;", "<init>", "()V", "nodeNameParts", "", "", "headingsList", "headingAncestor", "", "isMatch", "node", "Lnu/xom/Node;", "namespaces", "Lorg/brailleblaster/utd/NamespaceMap;", "spanCheck", "ele", "Lnu/xom/Element;", "checkHeadings", "originalNode", "onlySibling", "countTextChildren", "", "textChildren", "value", "nodeName", "getNodeName", "()Ljava/lang/String;", "setNodeName", "(Ljava/lang/String;)V", "headings", "getHeadings", "setHeadings", "utd"})
@SourceDebugExtension(value={"SMAP\nEmphasisMatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmphasisMatcher.kt\norg/brailleblaster/utd/matchers/EmphasisMatcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,115:1\n1807#2,3:116\n1834#2,4:119\n*S KotlinDebug\n*F\n+ 1 EmphasisMatcher.kt\norg/brailleblaster/utd/matchers/EmphasisMatcher\n*L\n75#1:116,3\n99#1:119,4\n*E\n"})
public final class EmphasisMatcher
implements INodeMatcher {
    @NotNull
    private List<String> nodeNameParts = CollectionsKt.emptyList();
    @NotNull
    private List<String> headingsList = CollectionsKt.emptyList();
    private boolean headingAncestor;

    @Override
    public boolean isMatch(@NotNull Node node, @NotNull NamespaceMap namespaces) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)namespaces, (String)"namespaces");
        this.headingAncestor = false;
        if (node instanceof Element) {
            for (String nodeName : this.nodeNameParts) {
                if (!(Intrinsics.areEqual((Object)nodeName, (Object)"span") ? this.spanCheck((Element)node) : Intrinsics.areEqual((Object)((Element)node).getLocalName(), (Object)nodeName) && Intrinsics.areEqual((Object)((Element)node).getLocalName(), (Object)nodeName))) continue;
                return this.checkHeadings(node);
            }
            bl = false;
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean spanCheck(Element ele) {
        return Intrinsics.areEqual((Object)ele.getLocalName(), (Object)"span") && ele.getAttributeValue("underline") != null;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkHeadings(Node originalNode) {
        for (Node node = originalNode; node != null && !this.headingAncestor; node = (Node)node.getParent()) {
            boolean bl;
            boolean bl2;
            block4: {
                void $this$any$iv;
                if (!(node instanceof Element)) continue;
                String localName = ((Element)node).getLocalName();
                Iterable iterable = this.headingsList;
                EmphasisMatcher emphasisMatcher = this;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)localName, (Object)it)) continue;
                        bl2 = true;
                        break block4;
                    }
                    bl2 = false;
                }
            }
            emphasisMatcher.headingAncestor = bl = bl2;
        }
        return this.headingAncestor && this.onlySibling(originalNode);
    }

    private final boolean onlySibling(Node node) {
        Node node2 = node;
        Intrinsics.checkNotNull((Object)node2);
        ParentNode parentNode = node2.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)parentNode, (String)"getParent(...)");
        Node parent = (Node)parentNode;
        int textChildren = 0;
        int n = parent.getChildCount();
        for (int i = 0; i < n; ++i) {
            Node node3 = parent.getChild(i);
            Intrinsics.checkNotNullExpressionValue((Object)node3, (String)"getChild(...)");
            textChildren += this.countTextChildren(node3, 0);
        }
        return textChildren == 1;
    }

    private final int countTextChildren(Node node, int textChildren) {
        int n;
        Iterable $this$count$iv = (Iterable)RangesKt.until((int)0, (int)node.getChildCount());
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            Iterator iterator = $this$count$iv.iterator();
            while (iterator.hasNext()) {
                int element$iv;
                int it = element$iv = ((IntIterator)iterator).nextInt();
                boolean bl = false;
                if (!(node.getChild(it) instanceof Text) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        return n + textChildren;
    }

    @NotNull
    public final String getNodeName() {
        return CollectionsKt.joinToString$default((Iterable)this.nodeNameParts, (CharSequence)"|", null, null, (int)0, null, null, (int)62, null);
    }

    @XmlAttribute
    public final void setNodeName(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        char[] cArray = new char[]{'|'};
        this.nodeNameParts = StringsKt.split$default((CharSequence)value, (char[])cArray, (boolean)false, (int)0, (int)6, null);
    }

    @NotNull
    public final String getHeadings() {
        return CollectionsKt.joinToString$default((Iterable)this.headingsList, (CharSequence)"|", null, null, (int)0, null, null, (int)62, null);
    }

    @XmlAttribute
    public final void setHeadings(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        char[] cArray = new char[]{'|'};
        this.headingsList = StringsKt.split$default((CharSequence)value, (char[])cArray, (boolean)false, (int)0, (int)6, null);
    }
}

