/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.utd.matchers;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import nu.xom.Comment;
import nu.xom.Document;
import nu.xom.Node;
import nu.xom.ParentNode;
import nu.xom.ProcessingInstruction;
import nu.xom.Text;
import org.brailleblaster.utd.NamespaceMap;
import org.brailleblaster.utd.matchers.DelegatingMatcher;
import org.brailleblaster.utd.matchers.INodeMatcher;
import org.brailleblaster.utd.properties.UTDElements;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001b\u001cB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\n\u0010\u0016\u001a\u00020\u000bH\u0096\u0080\u0004J\u0014\u0010\u0017\u001a\u00020\u00112\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0096\u0082\u0004J\u0010\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u001e\u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u00020\u000b8\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lorg/brailleblaster/utd/matchers/NodeAncestorDelegatingMatcher;", "Lorg/brailleblaster/utd/matchers/DelegatingMatcher;", "<init>", "()V", "position", "Lorg/brailleblaster/utd/matchers/NodeAncestorDelegatingMatcher$Position;", "getPosition", "()Lorg/brailleblaster/utd/matchers/NodeAncestorDelegatingMatcher$Position;", "setPosition", "(Lorg/brailleblaster/utd/matchers/NodeAncestorDelegatingMatcher$Position;)V", "distance", "", "getDistance", "()I", "setDistance", "(I)V", "isMatch", "", "node", "Lnu/xom/Node;", "namespaces", "Lorg/brailleblaster/utd/NamespaceMap;", "hashCode", "equals", "other", "", "isIgnorableNode", "Position", "Companion", "utd"})
public final class NodeAncestorDelegatingMatcher
extends DelegatingMatcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Position position = Position.ANY;
    private int distance;
    @NotNull
    private static final Logger log;

    @XmlElement
    @Nullable
    public final Position getPosition() {
        return this.position;
    }

    public final void setPosition(@Nullable Position position) {
        this.position = position;
    }

    @XmlAttribute
    public final int getDistance() {
        return this.distance;
    }

    public final void setDistance(int n) {
        this.distance = n;
    }

    @Override
    public boolean isMatch(@NotNull Node node, @NotNull NamespaceMap namespaces) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)namespaces, (String)"namespaces");
        if (this.getMatcher() == null) {
            return true;
        }
        Document doc = node.getDocument();
        Node curNode = node;
        int loopLevel = this.distance;
        if (loopLevel < 1) {
            loopLevel = Integer.MAX_VALUE;
        }
        for (int i = 0; curNode != doc && i < loopLevel && curNode.getParent() != null; ++i) {
            ParentNode parent;
            if (Position.ANY != this.position) {
                int index = parent.indexOf(curNode);
                if (Position.START == this.position && index > 0) {
                    for (j = 0; j < index; ++j) {
                        Node tempNode = parent.getChild(j);
                        Intrinsics.checkNotNull((Object)tempNode);
                        if (this.isIgnorableNode(tempNode)) continue;
                        log.debug("Node {} is not at the start of the ancestor", (Object)curNode);
                        return false;
                    }
                } else if (Position.END == this.position && index + 1 < parent.getChildCount()) {
                    int n = parent.getChildCount();
                    for (j = index + 1; j < n; ++j) {
                        Node tempNode = parent.getChild(j);
                        Intrinsics.checkNotNull((Object)tempNode);
                        if (this.isIgnorableNode(tempNode)) continue;
                        log.debug("Node {} is not at the end of the ancestor", (Object)curNode);
                        return false;
                    }
                }
            }
            INodeMatcher iNodeMatcher = this.getMatcher();
            Intrinsics.checkNotNull((Object)iNodeMatcher);
            if (iNodeMatcher.isMatch((Node)parent, namespaces)) {
                return true;
            }
            curNode = (Node)parent;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        Position position = this.position;
        result = prime * result + (position != null ? position.hashCode() : 0);
        return result;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !super.equals(other)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.getClass(), other.getClass())) {
            return false;
        }
        NodeAncestorDelegatingMatcher o = (NodeAncestorDelegatingMatcher)other;
        return this.position == o.position;
    }

    private final boolean isIgnorableNode(Node node) {
        if (node instanceof Comment || node instanceof ProcessingInstruction) {
            return true;
        }
        if (node instanceof Text) {
            String string = ((Text)node).getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
            if (((CharSequence)string).length() == 0) {
                return true;
            }
        }
        return UTDElements.BRL.isA(node);
    }

    static {
        Logger logger = LoggerFactory.getLogger(NodeAncestorDelegatingMatcher.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        log = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/brailleblaster/utd/matchers/NodeAncestorDelegatingMatcher$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "utd"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/brailleblaster/utd/matchers/NodeAncestorDelegatingMatcher$Position;", "", "<init>", "(Ljava/lang/String;I)V", "ANY", "START", "END", "utd"})
    public static final class Position
    extends Enum<Position> {
        public static final /* enum */ Position ANY = new Position();
        public static final /* enum */ Position START = new Position();
        public static final /* enum */ Position END = new Position();
        private static final /* synthetic */ Position[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Position[] values() {
            return (Position[])$VALUES.clone();
        }

        public static Position valueOf(String value) {
            return Enum.valueOf(Position.class, value);
        }

        @NotNull
        public static EnumEntries<Position> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = positionArray = new Position[]{Position.ANY, Position.START, Position.END};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

