/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.utd.mathactions;

import java.util.concurrent.ExecutionException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import onl.mdw.mathcat4j.api.MathCat;
import org.brailleblaster.utd.MathBraileCode;
import org.brailleblaster.utd.MathIndicators;
import org.brailleblaster.utd.TextSpan;
import org.brailleblaster.utd.asciimath.AsciiMathConverter;
import org.brailleblaster.utd.properties.ContentType;
import org.brailleblaster.utd.properties.UTDElements;
import org.brailleblaster.utd.utils.UTDHelper;
import org.brailleblaster.utils.braille.BrailleUnicodeConverter;
import org.brailleblaster.utils.braille.MathCATUtilsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0014\u0010\u0004\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\f\u0010\u0007\u001a\u00020\u0003*\u00020\bH\u0002\u001a\f\u0010\t\u001a\u00020\u0003*\u00020\bH\u0002\u001a \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0001H\u0002\u001a\u0016\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u0018\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u0015"}, d2={"applyAsciiBraille", "", "asciiBraille", "", "applyMathIndicators", "mathIndicators", "Lorg/brailleblaster/utd/MathIndicators;", "isMathML", "Lnu/xom/Element;", "isMathTME", "createMathTextSpan", "Lorg/brailleblaster/utd/TextSpan;", "node", "Lnu/xom/Node;", "text", "braille", "translateAsciiMath", "brailleCode", "Lorg/brailleblaster/utd/MathBraileCode;", "translateMathML", "mml", "utd"})
public final class MathCatActionKt {
    private static final String applyAsciiBraille(String $this$applyAsciiBraille, boolean asciiBraille) {
        return asciiBraille ? BrailleUnicodeConverter.INSTANCE.unicodeToAsciiLouis($this$applyAsciiBraille) : $this$applyAsciiBraille;
    }

    private static final String applyMathIndicators(String $this$applyMathIndicators, MathIndicators mathIndicators) {
        return mathIndicators.getStart() + $this$applyMathIndicators + mathIndicators.getEnd();
    }

    private static final boolean isMathML(Element $this$isMathML) {
        return Intrinsics.areEqual((Object)$this$isMathML.getLocalName(), (Object)"math");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isMathTME(Element $this$isMathTME) {
        if (!Intrinsics.areEqual((Object)$this$isMathTME.getLocalName(), (Object)"tme")) return false;
        String string = $this$isMathTME.getAttributeValue("emphasis");
        if (string == null) {
            string = "";
        }
        char[] cArray = new char[]{','};
        if (!StringsKt.split$default((CharSequence)string, (char[])cArray, (boolean)false, (int)0, (int)6, null).contains("MATH")) return false;
        return true;
    }

    private static final TextSpan createMathTextSpan(Node node, String text, String braille) {
        Object object = UTDElements.BRL.create();
        Element $this$createMathTextSpan_u24lambda_u240 = object;
        boolean bl = false;
        String indices = SequencesKt.joinToString$default((Sequence)SequencesKt.take((Sequence)SequencesKt.generateSequence(MathCatActionKt::createMathTextSpan$lambda$0$0), (int)braille.length()), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        $this$createMathTextSpan_u24lambda_u240.addAttribute(new Attribute("index", indices));
        $this$createMathTextSpan_u24lambda_u240.addAttribute(new Attribute("text", text));
        $this$createMathTextSpan_u24lambda_u240.insertChild(braille, 0);
        Element brl = object;
        ParentNode parentNode = node.getParent();
        if (parentNode != null) {
            ParentNode parent = parentNode;
            boolean bl2 = false;
            int index = parent.indexOf(node);
            if (UTDHelper.getAssociatedBrlElement(parent, index) != null) {
                parent.removeChild(index + 1);
            }
            parent.insertChild((Node)brl, index + 1);
        }
        Object $this$createMathTextSpan_u24lambda_u242 = object = new TextSpan(node, text, null, 4, null);
        boolean bl3 = false;
        ((TextSpan)$this$createMathTextSpan_u24lambda_u242).setTranslated(true);
        ((TextSpan)$this$createMathTextSpan_u24lambda_u242).setContentType(ContentType.Math);
        ((TextSpan)$this$createMathTextSpan_u24lambda_u242).setBrlElement(brl);
        return object;
    }

    @NotNull
    public static final String translateAsciiMath(@NotNull String text, @NotNull MathBraileCode brailleCode) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)((Object)brailleCode), (String)"brailleCode");
        return CollectionsKt.joinToString$default((Iterable)((Iterable)AsciiMathConverter.toMathML$default(AsciiMathConverter.INSTANCE, text, true, false, false, 12, null)), (CharSequence)"", null, null, (int)0, null, arg_0 -> MathCatActionKt.translateAsciiMath$lambda$0(brailleCode, arg_0), (int)30, null);
    }

    private static final String translateMathML(String mml, MathBraileCode brailleCode) {
        String string;
        try {
            string = (String)MathCATUtilsKt.singleThreadedMathCAT(arg_0 -> MathCatActionKt.translateMathML$lambda$0(brailleCode, mml, arg_0));
        }
        catch (ExecutionException ex) {
            throw new RuntimeException("Problem translating MathML \"" + mml + "\"", ex.getCause());
        }
        return string;
    }

    private static final String createMathTextSpan$lambda$0$0() {
        return "0";
    }

    private static final CharSequence translateAsciiMath$lambda$0(MathBraileCode $brailleCode, Node it) {
        String string = it.toXML();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toXML(...)");
        return MathCatActionKt.translateMathML(string, $brailleCode);
    }

    private static final String translateMathML$lambda$0(MathBraileCode $brailleCode, String $mml, MathCat $this$singleThreadedMathCAT) {
        Intrinsics.checkNotNullParameter((Object)$this$singleThreadedMathCAT, (String)"$this$singleThreadedMathCAT");
        $this$singleThreadedMathCAT.setPreference("BrailleCode", $brailleCode.getPreferenceName());
        $this$singleThreadedMathCAT.setMathml($mml);
        String string = $this$singleThreadedMathCAT.getBraille();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getBraille(...)");
        return string;
    }

    public static final /* synthetic */ TextSpan access$createMathTextSpan(Node node, String text, String braille) {
        return MathCatActionKt.createMathTextSpan(node, text, braille);
    }

    public static final /* synthetic */ String access$applyAsciiBraille(String $receiver, boolean asciiBraille) {
        return MathCatActionKt.applyAsciiBraille($receiver, asciiBraille);
    }

    public static final /* synthetic */ String access$applyMathIndicators(String $receiver, MathIndicators mathIndicators) {
        return MathCatActionKt.applyMathIndicators($receiver, mathIndicators);
    }

    public static final /* synthetic */ boolean access$isMathML(Element $receiver) {
        return MathCatActionKt.isMathML($receiver);
    }

    public static final /* synthetic */ String access$translateMathML(String mml, MathBraileCode brailleCode) {
        return MathCatActionKt.translateMathML(mml, brailleCode);
    }

    public static final /* synthetic */ boolean access$isMathTME(Element $receiver) {
        return MathCatActionKt.isMathTME($receiver);
    }
}

