/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.utd.tables;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Nodes;
import nu.xom.ParentNode;
import org.brailleblaster.utd.FormatSelector;
import org.brailleblaster.utd.IStyle;
import org.brailleblaster.utd.IStyleMap;
import org.brailleblaster.utd.PageBuilder;
import org.brailleblaster.utd.formatters.Formatter;
import org.brailleblaster.utd.internal.elements.TableDivider;
import org.brailleblaster.utd.properties.BrailleTableType;
import org.brailleblaster.utd.properties.UTDElements;
import org.brailleblaster.utd.utils.TableUtils;
import org.brailleblaster.utd.utils.TextTranslator;
import org.brailleblaster.utd.utils.UTDHelper;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J4\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J$\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\fH\u0002J\u001c\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u0012H\u0002J$\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u00122\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u00a8\u0006\u001c"}, d2={"Lorg/brailleblaster/utd/tables/LinearTableFormatter;", "Lorg/brailleblaster/utd/formatters/Formatter;", "<init>", "()V", "format", "", "Lorg/brailleblaster/utd/PageBuilder;", "node", "Lnu/xom/Node;", "style", "Lorg/brailleblaster/utd/IStyle;", "pageBuilders", "", "formatSelector", "Lorg/brailleblaster/utd/FormatSelector;", "removeRowFromPageBuilder", "", "row", "", "Lnu/xom/Element;", "pageBuilder", "calculateNumOfCols", "", "cells", "fillCells", "element", "iStyleMap", "Lorg/brailleblaster/utd/IStyleMap;", "utd"})
@SourceDebugExtension(value={"SMAP\nLinearTableFormatter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LinearTableFormatter.kt\norg/brailleblaster/utd/tables/LinearTableFormatter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,167:1\n1#2:168\n1586#3:169\n1661#3,3:170\n*S KotlinDebug\n*F\n+ 1 LinearTableFormatter.kt\norg/brailleblaster/utd/tables/LinearTableFormatter\n*L\n164#1:169\n164#1:170,3\n*E\n"})
public final class LinearTableFormatter
extends Formatter {
    @Override
    @NotNull
    public Set<PageBuilder> format(@NotNull Node node, @NotNull IStyle style, @NotNull Set<PageBuilder> pageBuilders, @NotNull FormatSelector formatSelector) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter(pageBuilders, (String)"pageBuilders");
        Intrinsics.checkNotNullParameter((Object)formatSelector, (String)"formatSelector");
        Set mutPageBuilders = CollectionsKt.toMutableSet((Iterable)pageBuilders);
        if (!(node instanceof Element)) {
            return mutPageBuilders;
        }
        PageBuilder pageBuilder = (PageBuilder)CollectionsKt.last((Iterable)mutPageBuilders);
        TableUtils.INSTANCE.deleteExistingTable(node);
        Element originalTable = TableUtils.copyTable((Element)node);
        TableUtils.INSTANCE.removeBrlBetweenCells((Element)node, formatSelector.styleMap);
        TableUtils.INSTANCE.createSignsOfOmission(formatSelector.engine, (Element)node, formatSelector.styleMap, "\u2810\u2810\u2810");
        List<Element> caption = TableUtils.findCaption((Element)node, formatSelector.styleMap);
        for (Element brl : caption) {
            pageBuilder.setFirstLineIndent(6).setLeftIndent(4).addAtLeastLinesBefore(1);
            mutPageBuilders.addAll(PageBuilder.addBrl$default(pageBuilder, brl, null, 2, null));
            pageBuilder = (PageBuilder)CollectionsKt.last((Iterable)mutPageBuilders);
        }
        List<List<Element>> cells = this.fillCells((Element)node, formatSelector.styleMap);
        int numOfCols = this.calculateNumOfCols(cells);
        if (cells.isEmpty()) {
            return mutPageBuilders;
        }
        for (List<Element> row : cells) {
            for (Element cell : row) {
                TableDivider.DividerTypes dividerTypes;
                int col = row.indexOf(cell);
                Nodes query = UTDHelper.INSTANCE.getDescendantBrlFastNodes((Node)cell);
                if (query.size() <= 0) continue;
                Node node2 = query.get(query.size() - 1);
                Intrinsics.checkNotNull((Object)node2, (String)"null cannot be cast to non-null type nu.xom.Element");
                Element lastBrl = (Element)node2;
                TableDivider newSpan = new TableDivider();
                Element newBrl = UTDElements.BRL.create();
                if (col == 0) {
                    dividerTypes = TableDivider.DividerTypes.LINEAR_COLON;
                } else {
                    if (col == numOfCols - 1) continue;
                    dividerTypes = TableDivider.DividerTypes.LINEAR_SEMICOLON;
                }
                TableDivider.DividerTypes dividerType = dividerTypes;
                newSpan.setType(dividerType);
                String string = newSpan.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
                Pair pair = TextTranslator.translateIndexedText$default(TextTranslator.INSTANCE, string, formatSelector.engine, (short)0, BrailleTableType.UNCONTRACTED, 4, null);
                int[] idx = (int[])pair.component1();
                String transText = (String)pair.component2();
                newBrl.appendChild(transText);
                newBrl.addAttribute(new Attribute("index", ArraysKt.joinToString$default((int[])idx, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null)));
                query.append((Node)newBrl);
                newSpan.appendChild((Node)newBrl);
                ParentNode parentNode = lastBrl.getParent();
                Intrinsics.checkNotNull((Object)parentNode, (String)"null cannot be cast to non-null type nu.xom.Element");
                Element parent = (Element)parentNode;
                String type = parent.getAttributeValue("type", parent.getNamespaceURI("bb"));
                if (type != null && Intrinsics.areEqual((Object)type, (Object)"MATHML")) {
                    ParentNode parentNode2 = parent.getParent();
                    Intrinsics.checkNotNull((Object)parentNode2, (String)"null cannot be cast to non-null type nu.xom.Element");
                    parent = (Element)parentNode2;
                }
                parent.appendChild((Node)newSpan);
            }
        }
        pageBuilder.setStartOfBlock(true);
        Integer linesBefore = style.getLinesBefore(node, formatSelector.styleMap.getNamespaces());
        if (linesBefore != null) {
            pageBuilder.setMaxLines(linesBefore);
        } else {
            pageBuilder.addAtLeastLinesBefore(style.getLinesBefore());
        }
        pageBuilder.addAtLeastPages(style.getNewPagesBefore());
        pageBuilder.setFirstLineIndent(0);
        pageBuilder.setLeftIndent(2);
        boolean beginningOfPage = pageBuilder.getY() == 0 || pageBuilder.getY() == 1 && ((CharSequence)pageBuilder.getRunningHead()).length() > 0;
        int i = 0;
        block3: while (i < cells.size()) {
            List<Element> row = cells.get(i);
            for (Element cell : row) {
                Nodes query = UTDHelper.INSTANCE.getDescendantBrlFastNodes((Node)cell);
                int n = query.size();
                for (int brl = 0; brl < n; ++brl) {
                    int curPages = mutPageBuilders.size();
                    Node node3 = query.get(brl);
                    Intrinsics.checkNotNull((Object)node3, (String)"null cannot be cast to non-null type nu.xom.Element");
                    mutPageBuilders.addAll(PageBuilder.addBrl$default(pageBuilder, (Element)node3, null, 2, null));
                    pageBuilder = (PageBuilder)CollectionsKt.last((Iterable)mutPageBuilders);
                    if (mutPageBuilders.size() <= curPages || beginningOfPage) continue;
                    this.removeRowFromPageBuilder(row, mutPageBuilders);
                    pageBuilder.setX(0);
                    if (pageBuilder.isBlankPageWithPageNumbers()) {
                        pageBuilder.setY(0);
                    }
                    pageBuilder.setStartOfBlock(true);
                    --i;
                    beginningOfPage = true;
                    ++i;
                    continue block3;
                }
            }
            pageBuilder.setStartOfBlock(true);
            pageBuilder.addAtLeastLinesBefore(1);
            beginningOfPage = false;
            ++i;
        }
        ((Element)node).addAttribute(new Attribute("class", "utd:tableLinear"));
        ((Element)node).getParent().insertChild((Node)originalTable, ((Element)node).getParent().indexOf(node));
        int newPos = pageBuilder.findLastBlankLine();
        pageBuilder.setY(newPos >= pageBuilder.getLinesPerPage() ? pageBuilder.getLinesPerPage() - 1 : newPos);
        Integer linesAfter = style.getLinesAfter(node, formatSelector.styleMap.getNamespaces());
        if (linesAfter != null) {
            pageBuilder.setMaxLines(linesAfter);
        } else {
            pageBuilder.addAtLeastLinesAfter(Math.max(style.getLinesAfter(), 1));
        }
        pageBuilder.addAtLeastPages(style.getNewPagesAfter());
        return mutPageBuilders;
    }

    private final void removeRowFromPageBuilder(List<? extends Element> row, Set<PageBuilder> pageBuilder) {
        for (PageBuilder pb : pageBuilder) {
            for (Element element : row) {
                Nodes brls = UTDHelper.INSTANCE.getDescendantBrlFastNodes((Node)element);
                int n = brls.size();
                for (int i = 0; i < n; ++i) {
                    Node node = brls.get(i);
                    Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Element");
                    pb.removeBrl((Element)node);
                }
            }
        }
    }

    private final int calculateNumOfCols(List<? extends List<? extends Element>> cells) {
        Comparable comparable;
        Iterator iterator = ((Iterable)cells).iterator();
        if (!iterator.hasNext()) {
            comparable = null;
        } else {
            List it = (List)iterator.next();
            boolean bl = false;
            Comparable comparable2 = Integer.valueOf(it.size());
            while (iterator.hasNext()) {
                List it2 = (List)iterator.next();
                $i$a$-maxOfOrNull-LinearTableFormatter$calculateNumOfCols$1 = false;
                Comparable comparable3 = Integer.valueOf(it2.size());
                if (comparable2.compareTo(comparable3) >= 0) continue;
                comparable2 = comparable3;
            }
            comparable = comparable2;
        }
        Integer n = (Integer)comparable;
        return n != null ? n : 0;
    }

    /*
     * WARNING - void declaration
     */
    private final List<List<Element>> fillCells(Element element, IStyleMap iStyleMap) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = TableUtils.INSTANCE.findRows(element, iStyleMap);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Element element2 = (Element)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(CollectionsKt.toList((Iterable)TableUtils.INSTANCE.findCols((Element)it, iStyleMap)));
        }
        return (List)destination$iv$iv;
    }
}

