/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.utd.tables;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Nodes;
import org.brailleblaster.utd.FormatSelector;
import org.brailleblaster.utd.IStyle;
import org.brailleblaster.utd.IStyleMap;
import org.brailleblaster.utd.PageBuilder;
import org.brailleblaster.utd.PageSettings;
import org.brailleblaster.utd.formatters.Formatter;
import org.brailleblaster.utd.properties.Align;
import org.brailleblaster.utd.utils.PageBuilderHelper;
import org.brailleblaster.utd.utils.TableUtils;
import org.brailleblaster.utd.utils.UTDHelper;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J4\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J$\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u00102\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J$\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00060\fH\u0002\u00a8\u0006\u0019"}, d2={"Lorg/brailleblaster/utd/tables/StairstepTableFormatter;", "Lorg/brailleblaster/utd/formatters/Formatter;", "<init>", "()V", "format", "", "Lorg/brailleblaster/utd/PageBuilder;", "node", "Lnu/xom/Node;", "style", "Lorg/brailleblaster/utd/IStyle;", "pageBuilders", "", "formatSelector", "Lorg/brailleblaster/utd/FormatSelector;", "findCells", "", "Lnu/xom/Element;", "table", "styleMap", "Lorg/brailleblaster/utd/IStyleMap;", "removeRowFromPageBuilders", "", "row", "pageBuilder", "utd"})
@SourceDebugExtension(value={"SMAP\nStairstepTableFormatter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StairstepTableFormatter.kt\norg/brailleblaster/utd/tables/StairstepTableFormatter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,131:1\n1586#2:132\n1661#2,3:133\n*S KotlinDebug\n*F\n+ 1 StairstepTableFormatter.kt\norg/brailleblaster/utd/tables/StairstepTableFormatter\n*L\n118#1:132\n118#1:133,3\n*E\n"})
public final class StairstepTableFormatter
extends Formatter {
    @Override
    @NotNull
    public Set<PageBuilder> format(@NotNull Node node, @NotNull IStyle style, @NotNull Set<PageBuilder> pageBuilders, @NotNull FormatSelector formatSelector) {
        int page;
        boolean skipTop;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter(pageBuilders, (String)"pageBuilders");
        Intrinsics.checkNotNullParameter((Object)formatSelector, (String)"formatSelector");
        Set mutPageBuilders = CollectionsKt.toMutableSet((Iterable)pageBuilders);
        if (!(node instanceof Element)) {
            return mutPageBuilders;
        }
        TableUtils.INSTANCE.deleteExistingTable(node);
        Element originalTable = TableUtils.copyTable((Element)node);
        TableUtils.INSTANCE.removeBrlBetweenCells((Element)node, formatSelector.styleMap);
        TableUtils.INSTANCE.createSignsOfOmission(formatSelector.engine, (Element)node, formatSelector.styleMap, "\u2810\u2810\u2810");
        PageBuilder pageBuilder = (PageBuilder)CollectionsKt.last((Iterable)mutPageBuilders);
        pageBuilder.setAlignment(Align.LEFT);
        List<Element> caption = TableUtils.findCaption((Element)node, formatSelector.styleMap);
        for (Element brl : caption) {
            pageBuilder.setFirstLineIndent(6).setLeftIndent(4).addAtLeastLinesBefore(1);
            mutPageBuilders.addAll(PageBuilder.addBrl$default(pageBuilder, brl, null, 2, null));
            pageBuilder = (PageBuilder)CollectionsKt.last((Iterable)mutPageBuilders);
        }
        PageSettings pageNumbers = formatSelector.engine.getPageSettings();
        boolean bl = skipTop = PageBuilderHelper.getPrintPageNumberAt(pageNumbers, page = pageBuilder.getBraillePageNumber().getPageNumber()).isTop() && PageBuilderHelper.getPrintPageNumberAt(pageNumbers, page).isLeft() || PageBuilderHelper.getBraillePageNumberAt(pageNumbers, page).isTop() && PageBuilderHelper.getBraillePageNumberAt(pageNumbers, page).isLeft();
        if (pageBuilder.getY() == 0 && skipTop) {
            pageBuilder.setY(1);
        } else {
            Integer linesBefore = style.getLinesBefore(node, formatSelector.styleMap.getNamespaces());
            if (linesBefore != null) {
                pageBuilder.setMaxLines(linesBefore);
            } else {
                pageBuilder.addAtLeastLinesBefore(style.getLinesBefore());
            }
        }
        pageBuilder.addAtLeastPages(style.getNewPagesBefore());
        pageBuilder.setStartOfBlock(true);
        List<List<Element>> cells = this.findCells((Element)node, formatSelector.styleMap);
        boolean beginningOfPage = pageBuilder.getY() == 0 || pageBuilder.getY() == 1 && ((CharSequence)pageBuilder.getRunningHead()).length() > 0;
        int i = 0;
        block1: while (i < cells.size()) {
            List<Element> row = cells.get(i);
            int indent = 0;
            for (Element cell : row) {
                pageBuilder.addAtLeastLinesBefore(1);
                pageBuilder.setLeftIndent(indent);
                pageBuilder.setFirstLineIndent(indent);
                List<Element> brls = UTDHelper.getDescendantBrlFast((Node)cell);
                for (Element brl : brls) {
                    int size = mutPageBuilders.size();
                    mutPageBuilders.addAll(PageBuilder.addBrl$default(pageBuilder, brl, null, 2, null));
                    if (mutPageBuilders.size() > size && !beginningOfPage) {
                        this.removeRowFromPageBuilders(row, mutPageBuilders);
                        pageBuilder = (PageBuilder)CollectionsKt.last((Iterable)mutPageBuilders);
                        pageBuilder.setY(0);
                        pageBuilder.setStartOfBlock(true);
                        beginningOfPage = true;
                        --i;
                        ++i;
                        continue block1;
                    }
                    pageBuilder = (PageBuilder)CollectionsKt.last((Iterable)mutPageBuilders);
                }
                indent += 2;
            }
            beginningOfPage = false;
            ++i;
        }
        ((Element)node).addAttribute(new Attribute("class", "utd:tableStairstep"));
        ((Element)node).getParent().insertChild((Node)originalTable, ((Element)node).getParent().indexOf(node));
        int newPos = pageBuilder.findLastBlankLine();
        pageBuilder.setY(newPos >= pageBuilder.getLinesPerPage() ? pageBuilder.getLinesPerPage() - 1 : newPos);
        Integer linesAfter = style.getLinesAfter(node, formatSelector.styleMap.getNamespaces());
        if (linesAfter != null) {
            pageBuilder.setMaxLines(linesAfter);
        } else {
            pageBuilder.addAtLeastLinesAfter(RangesKt.coerceAtLeast((int)style.getLinesAfter(), (int)1));
        }
        pageBuilder.addAtLeastPages(style.getNewPagesAfter());
        return mutPageBuilders;
    }

    /*
     * WARNING - void declaration
     */
    private final List<List<Element>> findCells(Element table, IStyleMap styleMap) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = TableUtils.INSTANCE.findRows(table, styleMap);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Element element = (Element)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TableUtils.INSTANCE.findCols((Element)it, styleMap));
        }
        return (List)destination$iv$iv;
    }

    private final void removeRowFromPageBuilders(List<? extends Element> row, Set<PageBuilder> pageBuilder) {
        for (PageBuilder pb : pageBuilder) {
            for (Element element : row) {
                Nodes brls = UTDHelper.INSTANCE.getDescendantBrlFastNodes((Node)element);
                int n = brls.size();
                for (int i = 0; i < n; ++i) {
                    Node node = brls.get(i);
                    Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Element");
                    pb.removeBrl((Element)node);
                }
            }
        }
    }
}

