/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.utd.toc;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import nu.xom.Text;
import org.brailleblaster.utd.FormatSelector;
import org.brailleblaster.utd.IStyle;
import org.brailleblaster.utd.IStyleMap;
import org.brailleblaster.utd.NamespaceMap;
import org.brailleblaster.utd.PageBuilder;
import org.brailleblaster.utd.formatters.Formatter;
import org.brailleblaster.utd.internal.xml.XMLHandler;
import org.brailleblaster.utd.properties.Align;
import org.brailleblaster.utd.properties.UTDElements;
import org.brailleblaster.utd.toc.TOCAttributes;
import org.brailleblaster.utd.utils.PageBuilderHelper;
import org.brailleblaster.utd.utils.UTDHelper;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 &2\u00020\u0001:\u0001&B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J4\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002JU\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00112\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001e\u001a\u00020\u001bH\u0002\u00a2\u0006\u0002\u0010\u001fJE\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000b0\u00112\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001bH\u0002\u00a2\u0006\u0002\u0010!J0\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00112\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0017H\u0002R\u0012\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/brailleblaster/utd/toc/TOCFormatter;", "Lorg/brailleblaster/utd/formatters/Formatter;", "<init>", "()V", "workingTitle", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "titleAdded", "", "format", "", "Lorg/brailleblaster/utd/PageBuilder;", "node", "Lnu/xom/Node;", "style", "Lorg/brailleblaster/utd/IStyle;", "pageBuilders", "", "formatSelector", "Lorg/brailleblaster/utd/FormatSelector;", "removeBrl", "pageBuilder", "element", "Lnu/xom/Element;", "formatTitle", "origStyle", "pageLength", "", "pendingLines", "maxLines", "pendingPages", "(Lnu/xom/Element;Lorg/brailleblaster/utd/IStyle;Lorg/brailleblaster/utd/PageBuilder;Lorg/brailleblaster/utd/FormatSelector;IILjava/lang/Integer;I)Ljava/util/Set;", "formatHeading", "(Lnu/xom/Element;Lorg/brailleblaster/utd/IStyle;Lorg/brailleblaster/utd/PageBuilder;Lorg/brailleblaster/utd/FormatSelector;ILjava/lang/Integer;)Ljava/util/Set;", "formatPage", "retrieveFullTitle", "", "brl", "Companion", "utd"})
@SourceDebugExtension(value={"SMAP\nTOCFormatter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TOCFormatter.kt\norg/brailleblaster/utd/toc/TOCFormatter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,412:1\n1915#2,2:413\n*S KotlinDebug\n*F\n+ 1 TOCFormatter.kt\norg/brailleblaster/utd/toc/TOCFormatter\n*L\n142#1:413,2\n*E\n"})
public final class TOCFormatter
extends Formatter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private StringBuilder workingTitle = new StringBuilder();
    private boolean titleAdded;
    @NotNull
    private static final Logger log;
    private static long time;

    @Override
    @NotNull
    public Set<PageBuilder> format(@NotNull Node node, @NotNull IStyle style, @NotNull Set<PageBuilder> pageBuilders, @NotNull FormatSelector formatSelector) {
        boolean pageCheck;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter(pageBuilders, (String)"pageBuilders");
        Intrinsics.checkNotNullParameter((Object)formatSelector, (String)"formatSelector");
        Set mutPageBuilders = CollectionsKt.toMutableSet((Iterable)pageBuilders);
        if (!(node instanceof Element)) {
            return mutPageBuilders;
        }
        PageBuilder pageBuilder = (PageBuilder)CollectionsKt.last((Iterable)mutPageBuilders);
        pageBuilder.setSkipNumberLines(style.getSkipNumberLines());
        pageBuilder.setTOC(true);
        pageBuilder.setAfterTPage(false);
        boolean keepWithNext = style.isKeepWithNext();
        if (keepWithNext && !pageBuilder.getKeepWithNext()) {
            pageBuilder.setKeepWithNext(true);
        }
        pageBuilder.addAtLeastLinesBefore(1);
        Object pageMatch = null;
        TOCFormatter $this$format_u24lambda_u240 = this;
        boolean bl = false;
        pageMatch = (Element)XMLHandler.Companion.childrenRecursiveNodeVisitor(node, TOCFormatter::format$lambda$0$0);
        if (pageMatch == null) {
            Ref.ObjectRef pageResult = new Ref.ObjectRef();
            XMLHandler.Companion.followingVisitor(node, arg_0 -> TOCFormatter.format$lambda$0$1(pageResult, arg_0));
            pageMatch = pageResult.element;
        }
        StringBuilder sb = new StringBuilder();
        boolean bl2 = pageCheck = pageMatch != null;
        if (pageCheck) {
            List<Element> brlPages = UTDHelper.getDescendantBrlFast((Node)pageMatch);
            for (Element brlPage : brlPages) {
                UTDHelper.stripBRLOnly(brlPage);
                sb.append(UTDHelper.getFirstTextDescendant(brlPage).getValue());
            }
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String page = string;
        int curPages = mutPageBuilders.size();
        pageBuilder.setStartOfBlock(true);
        NamespaceMap namespaceMap = formatSelector.styleMap.getNamespaces();
        mutPageBuilders.addAll((Collection)this.formatTitle((Element)node, style, pageBuilder, formatSelector, page.length(), style.getLinesBefore(), style.getLinesBefore(node, namespaceMap), style.getNewPagesBefore()));
        if (mutPageBuilders.size() > curPages && !TOCFormatter.Companion.isTocHeading(node)) {
            if (keepWithNext) {
                pageBuilder = this.removeBrl(pageBuilder, (Element)node);
                pageBuilder.clearKeepWithNext();
                pageBuilder.setKeepWithNext(false);
                pageBuilder = (PageBuilder)CollectionsKt.last((Iterable)mutPageBuilders);
                pageBuilder = this.removeBrl(pageBuilder, (Element)node);
                mutPageBuilders.addAll((Collection)this.formatTitle((Element)node, style, pageBuilder, formatSelector, page.length(), 0, 0, 0));
            } else {
                pageBuilder = (PageBuilder)CollectionsKt.last((Iterable)mutPageBuilders);
            }
        }
        if (pageCheck) {
            mutPageBuilders.addAll((Collection)this.formatPage((Element)pageMatch, pageBuilder, formatSelector, page.length()));
        }
        if (keepWithNext) {
            Iterable $this$forEach$iv = mutPageBuilders;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PageBuilder pb = (PageBuilder)element$iv;
                boolean bl3 = false;
                pb.setKeepWithNext(false);
            }
        }
        this.workingTitle = new StringBuilder();
        this.titleAdded = false;
        return mutPageBuilders;
    }

    private final PageBuilder removeBrl(PageBuilder pageBuilder, Element element) {
        PageBuilder curPageBuilder = pageBuilder;
        if (UTDElements.BRL.isA((Node)element)) {
            curPageBuilder.removeBrl(element);
        }
        Iterator iterator = element.getChildElements().iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Element child = (Element)iterator2.next();
            Intrinsics.checkNotNull((Object)child);
            curPageBuilder = this.removeBrl(curPageBuilder, child);
        }
        return curPageBuilder;
    }

    private final Set<PageBuilder> formatTitle(Element element, IStyle origStyle, PageBuilder pageBuilder, FormatSelector formatSelector, int pageLength, int pendingLines, Integer maxLines, int pendingPages) {
        PageBuilder curPageBuilder = pageBuilder;
        Set results = new LinkedHashSet();
        if (TOCFormatter.Companion.isTocHeading((Node)element)) {
            results.addAll((Collection)this.formatHeading(element, origStyle, curPageBuilder, formatSelector, pendingLines, maxLines));
            return results;
        }
        results.add(curPageBuilder);
        curPageBuilder.setFirstLineIndent(origStyle.getFirstLineIndent());
        Align align = origStyle.getAlign();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)align), (String)"getAlign(...)");
        curPageBuilder.setAlignment(align);
        curPageBuilder.setSkipNumberLines(origStyle.getSkipNumberLines());
        curPageBuilder.setTOC(true);
        curPageBuilder.addAtLeastLinesBefore(pendingLines);
        if (maxLines != null) {
            curPageBuilder.setMaxLines(maxLines);
        }
        curPageBuilder.setCenteredWithDots(true);
        int n = element.getChildCount();
        for (int i = 0; i < n; ++i) {
            Attribute attribute;
            int size;
            if (element.getChild(i) instanceof Text) {
                Integer leftIndent;
                Element brl;
                Intrinsics.checkNotNull((Object)UTDHelper.getAssociatedBrlElement((ParentNode)element, i));
                if (PageBuilderHelper.isPageIndicator(brl)) {
                    results.addAll((Collection)PageBuilderHelper.handlePageIndicator(curPageBuilder, brl, origStyle, formatSelector));
                    curPageBuilder = (PageBuilder)CollectionsKt.last((Iterable)results);
                    continue;
                }
                this.workingTitle.append(this.retrieveFullTitle(brl));
                int dotSpace = 3;
                int rightIndent = -6;
                if (pageLength + dotSpace > 6) {
                    rightIndent = (pageLength + dotSpace) * -1;
                }
                Integer n2 = leftIndent = origStyle.getIndent();
                curPageBuilder.setLeftIndent(n2 != null ? n2 : 0);
                curPageBuilder.setRightIndent(rightIndent);
                size = results.size();
                results.addAll(PageBuilder.addBrl$default(curPageBuilder, brl, null, 2, null));
                if (results.size() > size) {
                    curPageBuilder = (PageBuilder)CollectionsKt.last((Iterable)results);
                }
                this.titleAdded = true;
                continue;
            }
            if (!(element.getChild(i) instanceof Element)) continue;
            Node node = element.getChild(i);
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Element");
            Element nextChild = (Element)node;
            IStyleMap styleMap = formatSelector.styleMap;
            Node node2 = element.getChild(i);
            Intrinsics.checkNotNullExpressionValue((Object)node2, (String)"getChild(...)");
            IStyle curStyle = (IStyle)styleMap.findValueOrDefault(node2);
            if (UTDElements.BRL.isA((Node)nextChild) || (attribute = TOCAttributes.TYPE.getAttribute(nextChild)) != null && Intrinsics.areEqual((Object)attribute.getValue(), (Object)"page")) continue;
            size = results.size();
            results.addAll((Collection)this.formatTitle(nextChild, origStyle, curPageBuilder, formatSelector, pageLength, curStyle.getLinesBefore(), curStyle.getLinesBefore((Node)nextChild, styleMap.getNamespaces()), curStyle.getNewPagesBefore()));
            if (results.size() <= size) continue;
            curPageBuilder = (PageBuilder)CollectionsKt.last((Iterable)results);
        }
        curPageBuilder.setLeftIndent(0);
        curPageBuilder.setRightIndent(0);
        curPageBuilder.addAtLeastLinesAfter(origStyle.getLinesAfter());
        return results;
    }

    private final Set<PageBuilder> formatHeading(Element element, IStyle style, PageBuilder pageBuilder, FormatSelector formatSelector, int pendingLines, Integer maxLines) {
        PageBuilder curPageBuilder = pageBuilder;
        Set results = new LinkedHashSet();
        results.add(curPageBuilder);
        curPageBuilder.setTOC(true);
        int n = element.getChildCount();
        for (int i = 0; i < n; ++i) {
            Attribute attribute;
            IStyle curStyle;
            if (element.getChild(i) instanceof Text) {
                Integer leftIndent;
                Element brl;
                Intrinsics.checkNotNull((Object)UTDHelper.getAssociatedBrlElement((ParentNode)element, i));
                if (PageBuilderHelper.isPageIndicator(brl)) {
                    results.addAll((Collection)PageBuilderHelper.handlePageIndicator(curPageBuilder, brl, style, formatSelector));
                    curPageBuilder = (PageBuilder)CollectionsKt.last((Iterable)results);
                    continue;
                }
                curPageBuilder.addAtLeastLinesBefore(pendingLines);
                if (maxLines != null) {
                    curPageBuilder.setMaxLines(maxLines);
                }
                if (style.getNewPagesBefore() > 0) {
                    curPageBuilder.addAtLeastPages(style.getNewPagesBefore());
                    results.addAll((Collection)curPageBuilder.processSpacing());
                    curPageBuilder = (PageBuilder)CollectionsKt.last((Iterable)results);
                }
                curPageBuilder.setFirstLineIndent(style.getFirstLineIndent());
                Align align = style.getAlign();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)align), (String)"getAlign(...)");
                curPageBuilder.setAlignment(align);
                curPageBuilder.setSkipNumberLines(style.getSkipNumberLines());
                Integer n2 = leftIndent = style.getIndent();
                curPageBuilder.setLeftIndent(n2 != null ? n2 : 0);
                int size = results.size();
                results.addAll(PageBuilder.addBrl$default(curPageBuilder, brl, null, 2, null));
                if (results.size() <= size) continue;
                curPageBuilder = (PageBuilder)CollectionsKt.last((Iterable)results);
                continue;
            }
            if (!(element.getChild(i) instanceof Element)) continue;
            Node node = element.getChild(i);
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Element");
            Element nextChild = (Element)node;
            IStyleMap styleMap = formatSelector.styleMap;
            IStyle iStyle = curStyle = Intrinsics.areEqual((Object)nextChild.getLocalName(), (Object)"INLINE") ? style : (IStyle)styleMap.findValueOrDefault((Node)nextChild);
            if (UTDElements.BRL.isA((Node)nextChild) || (attribute = TOCAttributes.TYPE.getAttribute(nextChild)) != null && Intrinsics.areEqual((Object)attribute.getValue(), (Object)"page")) continue;
            int size = results.size();
            results.addAll((Collection)this.formatHeading(nextChild, curStyle, curPageBuilder, formatSelector, curStyle.getLinesBefore(), curStyle.getLinesBefore((Node)nextChild, styleMap.getNamespaces())));
            if (results.size() <= size) continue;
            curPageBuilder = (PageBuilder)CollectionsKt.last((Iterable)results);
        }
        curPageBuilder.addAtLeastLinesAfter(style.getLinesAfter());
        return results;
    }

    private final Set<PageBuilder> formatPage(Element element, PageBuilder pageBuilder, FormatSelector formatSelector, int pageLength) {
        PageBuilder curPageBuilder = pageBuilder;
        Set results = new LinkedHashSet();
        results.add(curPageBuilder);
        curPageBuilder.finishSegment();
        curPageBuilder.setAlignment(Align.LEFT);
        int curX = curPageBuilder.getX();
        List<Element> brls = UTDHelper.getDescendantBrlFast((Node)element);
        if (!((Collection)brls).isEmpty()) {
            int endX = curPageBuilder.getCellsPerLine() - pageLength;
            if (pageLength > 0 && this.titleAdded && endX - curX != 1) {
                Element guideDots;
                char guideDot = '\"';
                if (!formatSelector.engine.getBrailleSettings().isUseAsciiBraille()) {
                    guideDot = '\u2810';
                }
                Element element2 = guideDots = curPageBuilder.fillSpace(guideDot, endX - curX, 1, 4);
                if (element2 != null) {
                    element2.addAttribute(new Attribute("type", "guideDots"));
                }
            }
            curPageBuilder.setX(curPageBuilder.getCellsPerLine() - pageLength);
            curPageBuilder.setLeftIndent(0);
            int origMaxLines = curPageBuilder.getMaxLines();
            curPageBuilder.setMaxLines(-1);
            for (Element brl : brls) {
                int size = results.size();
                results.addAll(PageBuilder.addBrl$default(curPageBuilder, brl, null, 2, null));
                if (results.size() <= size) continue;
                curPageBuilder = (PageBuilder)CollectionsKt.last((Iterable)results);
            }
            curPageBuilder.setMaxLines(origMaxLines);
        }
        return results;
    }

    private final String retrieveFullTitle(Element brl) {
        StringBuilder fullTitle = new StringBuilder();
        int n = brl.getChildCount();
        for (int i = 0; i < n; ++i) {
            if (brl.getChild(i) instanceof Text) {
                fullTitle.append(brl.getChild(i).getValue());
                continue;
            }
            if (!(brl.getChild(i) instanceof Element)) continue;
            Node node = brl.getChild(i);
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Element");
            fullTitle.append(this.retrieveFullTitle((Element)node));
        }
        String string = fullTitle.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final boolean format$lambda$0$0(Node curNode) {
        Intrinsics.checkNotNullParameter((Object)curNode, (String)"curNode");
        return TOCFormatter.Companion.isTocPage(curNode);
    }

    private static final boolean format$lambda$0$1(Ref.ObjectRef $pageResult, Node curNode) {
        Intrinsics.checkNotNullParameter((Object)curNode, (String)"curNode");
        log.debug("Current node: {}", (Object)curNode);
        if (curNode instanceof Text) {
            return true;
        }
        if (TOCFormatter.Companion.isTocPage(curNode)) {
            $pageResult.element = (Element)curNode;
            return true;
        }
        return false;
    }

    static {
        Logger logger = LoggerFactory.getLogger(TOCFormatter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        log = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lorg/brailleblaster/utd/toc/TOCFormatter$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "time", "", "getTime", "()J", "setTime", "(J)V", "isTocPage", "", "curNode", "Lnu/xom/Node;", "isTocHeading", "isTocAttr", "value", "", "utd"})
    public static final class Companion {
        private Companion() {
        }

        public final long getTime() {
            return time;
        }

        public final void setTime(long l) {
            time = l;
        }

        private final boolean isTocPage(Node curNode) {
            return this.isTocAttr(curNode, "page");
        }

        private final boolean isTocHeading(Node curNode) {
            return this.isTocAttr(curNode, "heading");
        }

        private final boolean isTocAttr(Node curNode, String value) {
            if (!(curNode instanceof Element)) {
                return false;
            }
            Attribute tocTypeAttrib = TOCAttributes.TYPE.getAttribute((Element)curNode);
            return tocTypeAttrib != null && Intrinsics.areEqual((Object)tocTypeAttrib.getValue(), (Object)value);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

