/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.utd.utils;

import java.text.DecimalFormat;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.brailleblaster.utils.LengthUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0004\b\u000b\u0010\fBI\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\r\u0012\u0006\u0010\u0006\u001a\u00020\r\u0012\u0006\u0010\u0007\u001a\u00020\r\u0012\u0006\u0010\b\u001a\u00020\r\u0012\u0006\u0010\t\u001a\u00020\r\u0012\u0006\u0010\n\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u000b\u0010\u0010J\u000e\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0016\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0017\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\n\u0010\u0018\u001a\u00020\u0003H\u0096\u0080\u0004J\u000e\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001aR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0012\u00a8\u0006\u001c"}, d2={"Lorg/brailleblaster/utd/utils/Page;", "", "type", "", "width", "", "height", "leftMargin", "rightMargin", "topMargin", "bottomMargin", "<init>", "(Ljava/lang/String;IIIIII)V", "", "units", "Lorg/brailleblaster/utils/LengthUtils$Units;", "(Ljava/lang/String;DDDDDDLorg/brailleblaster/utils/LengthUtils$Units;)V", "getWidth", "()I", "getHeight", "getLeftMargin", "getRightMargin", "getTopMargin", "getBottomMargin", "toString", "df", "Ljava/text/DecimalFormat;", "Companion", "utd"})
public final class Page {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String type;
    private final int width;
    private final int height;
    private final int leftMargin;
    private final int rightMargin;
    private final int topMargin;
    private final int bottomMargin;
    @JvmField
    @NotNull
    public static final List<Page> STANDARD_PAGES;
    @NotNull
    private static final Page DEFAULT_PAGE;

    public Page(@NotNull String type, int width, int height, int leftMargin, int rightMargin, int topMargin, int bottomMargin) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.type = type;
        this.width = width;
        this.height = height;
        this.leftMargin = leftMargin;
        this.rightMargin = rightMargin;
        this.topMargin = topMargin;
        this.bottomMargin = bottomMargin;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final int getLeftMargin() {
        return this.leftMargin;
    }

    public final int getRightMargin() {
        return this.rightMargin;
    }

    public final int getTopMargin() {
        return this.topMargin;
    }

    public final int getBottomMargin() {
        return this.bottomMargin;
    }

    public Page(@NotNull String type, double width, double height, double leftMargin, double rightMargin, double topMargin, double bottomMargin, @NotNull LengthUtils.Units units) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)units, (String)"units");
        this(type, units.fromUnits(width), units.fromUnits(height), units.fromUnits(leftMargin), units.fromUnits(rightMargin), units.fromUnits(topMargin), units.fromUnits(bottomMargin));
    }

    public final double getWidth(@NotNull LengthUtils.Units units) {
        Intrinsics.checkNotNullParameter((Object)units, (String)"units");
        return units.asUnits(this.width);
    }

    public final double getHeight(@NotNull LengthUtils.Units units) {
        Intrinsics.checkNotNullParameter((Object)units, (String)"units");
        return units.asUnits(this.height);
    }

    public final double getLeftMargin(@NotNull LengthUtils.Units units) {
        Intrinsics.checkNotNullParameter((Object)units, (String)"units");
        return units.asUnits(this.leftMargin);
    }

    public final double getRightMargin(@NotNull LengthUtils.Units units) {
        Intrinsics.checkNotNullParameter((Object)units, (String)"units");
        return units.asUnits(this.rightMargin);
    }

    public final double getTopMargin(@NotNull LengthUtils.Units units) {
        Intrinsics.checkNotNullParameter((Object)units, (String)"units");
        return units.asUnits(this.topMargin);
    }

    public final double getBottomMargin(@NotNull LengthUtils.Units units) {
        Intrinsics.checkNotNullParameter((Object)units, (String)"units");
        return units.asUnits(this.bottomMargin);
    }

    @NotNull
    public String toString() {
        return this.type + " (" + this.width + ", " + this.height + ")";
    }

    @NotNull
    public final String toString(@NotNull LengthUtils.Units units) {
        Intrinsics.checkNotNullParameter((Object)units, (String)"units");
        return this.type + " (" + units.asUnits(this.width) + ", " + units.asUnits(this.height);
    }

    @NotNull
    public final String toString(@NotNull LengthUtils.Units units, @NotNull DecimalFormat df) {
        Intrinsics.checkNotNullParameter((Object)units, (String)"units");
        Intrinsics.checkNotNullParameter((Object)df, (String)"df");
        return this.type + " (" + df.format(units.asUnits(this.width)) + ", " + df.format(units.asUnits(this.height)) + ")";
    }

    static {
        Object[] objectArray = new Page[]{new Page("Standard", 292100, 279400, 25400, 18700, 12700, 16700), new Page("Letter", 215900, 279400, 7600, 9900, 12700, 16700), new Page("Legal", 215900, 355600, 12700, 17200, 25400, 30200), new Page("A3", 297000, 420000, 25000, 24000, 35000, 35000), new Page("A4", 210000, 297000, 15100, 15100, 23500, 23500), new Page("A5", 148000, 210000, 17000, 12700, 10000, 10000)};
        STANDARD_PAGES = CollectionsKt.listOf((Object[])objectArray);
        DEFAULT_PAGE = STANDARD_PAGES.get(0);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/brailleblaster/utd/utils/Page$Companion;", "", "<init>", "()V", "STANDARD_PAGES", "", "Lorg/brailleblaster/utd/utils/Page;", "DEFAULT_PAGE", "getDEFAULT_PAGE", "()Lorg/brailleblaster/utd/utils/Page;", "utd"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Page getDEFAULT_PAGE() {
            return DEFAULT_PAGE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

